/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the rule and the threshold under which a prediction can be accepted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptRule implements SdkPojo, Serializable, ToCopyableBuilder<AcceptRule.Builder, AcceptRule> {
    private static final SdkField<String> RULE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("rule")
            .getter(getter(AcceptRule::ruleAsString)).setter(setter(Builder::rule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()).build();

    private static final SdkField<Float> THRESHOLD_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("threshold").getter(getter(AcceptRule::threshold)).setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_FIELD, THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String rule;

    private final Float threshold;

    private AcceptRule(BuilderImpl builder) {
        this.rule = builder.rule;
        this.threshold = builder.threshold;
    }

    /**
     * <p>
     * Specifies whether you want to accept the top prediction for all targets or none.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rule} will return
     * {@link AcceptRuleBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleAsString}.
     * </p>
     * 
     * @return Specifies whether you want to accept the top prediction for all targets or none.
     * @see AcceptRuleBehavior
     */
    public final AcceptRuleBehavior rule() {
        return AcceptRuleBehavior.fromValue(rule);
    }

    /**
     * <p>
     * Specifies whether you want to accept the top prediction for all targets or none.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rule} will return
     * {@link AcceptRuleBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleAsString}.
     * </p>
     * 
     * @return Specifies whether you want to accept the top prediction for all targets or none.
     * @see AcceptRuleBehavior
     */
    public final String ruleAsString() {
        return rule;
    }

    /**
     * <p>
     * The confidence score that specifies the condition at which a prediction can be accepted.
     * </p>
     * 
     * @return The confidence score that specifies the condition at which a prediction can be accepted.
     */
    public final Float threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptRule)) {
            return false;
        }
        AcceptRule other = (AcceptRule) obj;
        return Objects.equals(ruleAsString(), other.ruleAsString()) && Objects.equals(threshold(), other.threshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptRule").add("Rule", ruleAsString()).add("Threshold", threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rule":
            return Optional.ofNullable(clazz.cast(ruleAsString()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptRule, T> g) {
        return obj -> g.apply((AcceptRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceptRule> {
        /**
         * <p>
         * Specifies whether you want to accept the top prediction for all targets or none.
         * </p>
         * 
         * @param rule
         *        Specifies whether you want to accept the top prediction for all targets or none.
         * @see AcceptRuleBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptRuleBehavior
         */
        Builder rule(String rule);

        /**
         * <p>
         * Specifies whether you want to accept the top prediction for all targets or none.
         * </p>
         * 
         * @param rule
         *        Specifies whether you want to accept the top prediction for all targets or none.
         * @see AcceptRuleBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceptRuleBehavior
         */
        Builder rule(AcceptRuleBehavior rule);

        /**
         * <p>
         * The confidence score that specifies the condition at which a prediction can be accepted.
         * </p>
         * 
         * @param threshold
         *        The confidence score that specifies the condition at which a prediction can be accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Float threshold);
    }

    static final class BuilderImpl implements Builder {
        private String rule;

        private Float threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptRule model) {
            rule(model.rule);
            threshold(model.threshold);
        }

        public final String getRule() {
            return rule;
        }

        public final void setRule(String rule) {
            this.rule = rule;
        }

        @Override
        public final Builder rule(String rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public final Builder rule(AcceptRuleBehavior rule) {
            this.rule(rule == null ? null : rule.toString());
            return this;
        }

        public final Float getThreshold() {
            return threshold;
        }

        public final void setThreshold(Float threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Float threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public AcceptRule build() {
            return new AcceptRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
