/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriptionRequestRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateSubscriptionRequestRequest.Builder, CreateSubscriptionRequestRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSubscriptionRequestRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateSubscriptionRequestRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> REQUEST_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestReason").getter(getter(CreateSubscriptionRequestRequest::requestReason))
            .setter(setter(Builder::requestReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestReason").build()).build();

    private static final SdkField<List<SubscribedListingInput>> SUBSCRIBED_LISTINGS_FIELD = SdkField
            .<List<SubscribedListingInput>> builder(MarshallingType.LIST)
            .memberName("subscribedListings")
            .getter(getter(CreateSubscriptionRequestRequest::subscribedListings))
            .setter(setter(Builder::subscribedListings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedListingInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedListingInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SubscribedPrincipalInput>> SUBSCRIBED_PRINCIPALS_FIELD = SdkField
            .<List<SubscribedPrincipalInput>> builder(MarshallingType.LIST)
            .memberName("subscribedPrincipals")
            .getter(getter(CreateSubscriptionRequestRequest::subscribedPrincipals))
            .setter(setter(Builder::subscribedPrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubscribedPrincipalInput> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubscribedPrincipalInput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, REQUEST_REASON_FIELD, SUBSCRIBED_LISTINGS_FIELD, SUBSCRIBED_PRINCIPALS_FIELD));

    private final String clientToken;

    private final String domainIdentifier;

    private final String requestReason;

    private final List<SubscribedListingInput> subscribedListings;

    private final List<SubscribedPrincipalInput> subscribedPrincipals;

    private CreateSubscriptionRequestRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.requestReason = builder.requestReason;
        this.subscribedListings = builder.subscribedListings;
        this.subscribedPrincipals = builder.subscribedPrincipals;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the subscription request is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the subscription request is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The reason for the subscription request.
     * </p>
     * 
     * @return The reason for the subscription request.
     */
    public final String requestReason() {
        return requestReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscribedListings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribedListings() {
        return subscribedListings != null && !(subscribedListings instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribedListings} method.
     * </p>
     * 
     * @return
     */
    public final List<SubscribedListingInput> subscribedListings() {
        return subscribedListings;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubscribedPrincipals property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubscribedPrincipals() {
        return subscribedPrincipals != null && !(subscribedPrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon DataZone principals for whom the subscription request is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubscribedPrincipals} method.
     * </p>
     * 
     * @return The Amazon DataZone principals for whom the subscription request is created.
     */
    public final List<SubscribedPrincipalInput> subscribedPrincipals() {
        return subscribedPrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(requestReason());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribedListings() ? subscribedListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubscribedPrincipals() ? subscribedPrincipals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionRequestRequest)) {
            return false;
        }
        CreateSubscriptionRequestRequest other = (CreateSubscriptionRequestRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(requestReason(), other.requestReason())
                && hasSubscribedListings() == other.hasSubscribedListings()
                && Objects.equals(subscribedListings(), other.subscribedListings())
                && hasSubscribedPrincipals() == other.hasSubscribedPrincipals()
                && Objects.equals(subscribedPrincipals(), other.subscribedPrincipals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriptionRequestRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier())
                .add("RequestReason", requestReason() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SubscribedListings", hasSubscribedListings() ? subscribedListings() : null)
                .add("SubscribedPrincipals", hasSubscribedPrincipals() ? subscribedPrincipals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "requestReason":
            return Optional.ofNullable(clazz.cast(requestReason()));
        case "subscribedListings":
            return Optional.ofNullable(clazz.cast(subscribedListings()));
        case "subscribedPrincipals":
            return Optional.ofNullable(clazz.cast(subscribedPrincipals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionRequestRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriptionRequestRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the subscription request is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which the subscription request is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The reason for the subscription request.
         * </p>
         * 
         * @param requestReason
         *        The reason for the subscription request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestReason(String requestReason);

        /**
         * <p/>
         * 
         * @param subscribedListings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListings(Collection<SubscribedListingInput> subscribedListings);

        /**
         * <p/>
         * 
         * @param subscribedListings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedListings(SubscribedListingInput... subscribedListings);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedListingInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedListingInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedListingInput.Builder#build()} is called
         * immediately and its result is passed to {@link #subscribedListings(List<SubscribedListingInput>)}.
         * 
         * @param subscribedListings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscribedListingInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedListings(java.util.Collection<SubscribedListingInput>)
         */
        Builder subscribedListings(Consumer<SubscribedListingInput.Builder>... subscribedListings);

        /**
         * <p>
         * The Amazon DataZone principals for whom the subscription request is created.
         * </p>
         * 
         * @param subscribedPrincipals
         *        The Amazon DataZone principals for whom the subscription request is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedPrincipals(Collection<SubscribedPrincipalInput> subscribedPrincipals);

        /**
         * <p>
         * The Amazon DataZone principals for whom the subscription request is created.
         * </p>
         * 
         * @param subscribedPrincipals
         *        The Amazon DataZone principals for whom the subscription request is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscribedPrincipals(SubscribedPrincipalInput... subscribedPrincipals);

        /**
         * <p>
         * The Amazon DataZone principals for whom the subscription request is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput.Builder#build()} is called
         * immediately and its result is passed to {@link #subscribedPrincipals(List<SubscribedPrincipalInput>)}.
         * 
         * @param subscribedPrincipals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.SubscribedPrincipalInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscribedPrincipals(java.util.Collection<SubscribedPrincipalInput>)
         */
        Builder subscribedPrincipals(Consumer<SubscribedPrincipalInput.Builder>... subscribedPrincipals);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String requestReason;

        private List<SubscribedListingInput> subscribedListings = DefaultSdkAutoConstructList.getInstance();

        private List<SubscribedPrincipalInput> subscribedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionRequestRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            requestReason(model.requestReason);
            subscribedListings(model.subscribedListings);
            subscribedPrincipals(model.subscribedPrincipals);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getRequestReason() {
            return requestReason;
        }

        public final void setRequestReason(String requestReason) {
            this.requestReason = requestReason;
        }

        @Override
        public final Builder requestReason(String requestReason) {
            this.requestReason = requestReason;
            return this;
        }

        public final List<SubscribedListingInput.Builder> getSubscribedListings() {
            List<SubscribedListingInput.Builder> result = SubscribedListingInputsCopier.copyToBuilder(this.subscribedListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedListings(Collection<SubscribedListingInput.BuilderImpl> subscribedListings) {
            this.subscribedListings = SubscribedListingInputsCopier.copyFromBuilder(subscribedListings);
        }

        @Override
        public final Builder subscribedListings(Collection<SubscribedListingInput> subscribedListings) {
            this.subscribedListings = SubscribedListingInputsCopier.copy(subscribedListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(SubscribedListingInput... subscribedListings) {
            subscribedListings(Arrays.asList(subscribedListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(Consumer<SubscribedListingInput.Builder>... subscribedListings) {
            subscribedListings(Stream.of(subscribedListings).map(c -> SubscribedListingInput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SubscribedPrincipalInput.Builder> getSubscribedPrincipals() {
            List<SubscribedPrincipalInput.Builder> result = SubscribedPrincipalInputsCopier
                    .copyToBuilder(this.subscribedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedPrincipals(Collection<SubscribedPrincipalInput.BuilderImpl> subscribedPrincipals) {
            this.subscribedPrincipals = SubscribedPrincipalInputsCopier.copyFromBuilder(subscribedPrincipals);
        }

        @Override
        public final Builder subscribedPrincipals(Collection<SubscribedPrincipalInput> subscribedPrincipals) {
            this.subscribedPrincipals = SubscribedPrincipalInputsCopier.copy(subscribedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(SubscribedPrincipalInput... subscribedPrincipals) {
            subscribedPrincipals(Arrays.asList(subscribedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(Consumer<SubscribedPrincipalInput.Builder>... subscribedPrincipals) {
            subscribedPrincipals(Stream.of(subscribedPrincipals)
                    .map(c -> SubscribedPrincipalInput.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionRequestRequest build() {
            return new CreateSubscriptionRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
