/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters of the environment action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionParameters.Builder, ActionParameters> {
    private static final SdkField<AwsConsoleLinkParameters> AWS_CONSOLE_LINK_FIELD = SdkField
            .<AwsConsoleLinkParameters> builder(MarshallingType.SDK_POJO).memberName("awsConsoleLink")
            .getter(getter(ActionParameters::awsConsoleLink)).setter(setter(Builder::awsConsoleLink))
            .constructor(AwsConsoleLinkParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsConsoleLink").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_CONSOLE_LINK_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsConsoleLinkParameters awsConsoleLink;

    private final Type type;

    private ActionParameters(BuilderImpl builder) {
        this.awsConsoleLink = builder.awsConsoleLink;
        this.type = builder.type;
    }

    /**
     * <p>
     * The console link specified as part of the environment action.
     * </p>
     * 
     * @return The console link specified as part of the environment action.
     */
    public final AwsConsoleLinkParameters awsConsoleLink() {
        return awsConsoleLink;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsConsoleLink());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionParameters)) {
            return false;
        }
        ActionParameters other = (ActionParameters) obj;
        return Objects.equals(awsConsoleLink(), other.awsConsoleLink());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionParameters").add("AwsConsoleLink", awsConsoleLink()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsConsoleLink":
            return Optional.ofNullable(clazz.cast(awsConsoleLink()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #awsConsoleLink()} initialized to the given value.
     *
     * <p>
     * The console link specified as part of the environment action.
     * </p>
     * 
     * @param awsConsoleLink
     *        The console link specified as part of the environment action.
     */
    public static ActionParameters fromAwsConsoleLink(AwsConsoleLinkParameters awsConsoleLink) {
        return builder().awsConsoleLink(awsConsoleLink).build();
    }

    /**
     * Create an instance of this class with {@link #awsConsoleLink()} initialized to the given value.
     *
     * <p>
     * The console link specified as part of the environment action.
     * </p>
     * 
     * @param awsConsoleLink
     *        The console link specified as part of the environment action.
     */
    public static ActionParameters fromAwsConsoleLink(Consumer<AwsConsoleLinkParameters.Builder> awsConsoleLink) {
        AwsConsoleLinkParameters.Builder builder = AwsConsoleLinkParameters.builder();
        awsConsoleLink.accept(builder);
        return fromAwsConsoleLink(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionParameters, T> g) {
        return obj -> g.apply((ActionParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionParameters> {
        /**
         * <p>
         * The console link specified as part of the environment action.
         * </p>
         * 
         * @param awsConsoleLink
         *        The console link specified as part of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsConsoleLink(AwsConsoleLinkParameters awsConsoleLink);

        /**
         * <p>
         * The console link specified as part of the environment action.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsConsoleLinkParameters.Builder}
         * avoiding the need to create one manually via {@link AwsConsoleLinkParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsConsoleLinkParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #awsConsoleLink(AwsConsoleLinkParameters)}.
         * 
         * @param awsConsoleLink
         *        a consumer that will call methods on {@link AwsConsoleLinkParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsConsoleLink(AwsConsoleLinkParameters)
         */
        default Builder awsConsoleLink(Consumer<AwsConsoleLinkParameters.Builder> awsConsoleLink) {
            return awsConsoleLink(AwsConsoleLinkParameters.builder().applyMutation(awsConsoleLink).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsConsoleLinkParameters awsConsoleLink;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ActionParameters model) {
            awsConsoleLink(model.awsConsoleLink);
        }

        public final AwsConsoleLinkParameters.Builder getAwsConsoleLink() {
            return awsConsoleLink != null ? awsConsoleLink.toBuilder() : null;
        }

        public final void setAwsConsoleLink(AwsConsoleLinkParameters.BuilderImpl awsConsoleLink) {
            Object oldValue = this.awsConsoleLink;
            this.awsConsoleLink = awsConsoleLink != null ? awsConsoleLink.build() : null;
            handleUnionValueChange(Type.AWS_CONSOLE_LINK, oldValue, this.awsConsoleLink);
        }

        @Override
        public final Builder awsConsoleLink(AwsConsoleLinkParameters awsConsoleLink) {
            Object oldValue = this.awsConsoleLink;
            this.awsConsoleLink = awsConsoleLink;
            handleUnionValueChange(Type.AWS_CONSOLE_LINK, oldValue, this.awsConsoleLink);
            return this;
        }

        @Override
        public ActionParameters build() {
            return new ActionParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ActionParameters#type()
     */
    public enum Type {
        AWS_CONSOLE_LINK,

        UNKNOWN_TO_SDK_VERSION
    }
}
