/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentActionRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateEnvironmentActionRequest.Builder, CreateEnvironmentActionRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentActionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateEnvironmentActionRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(CreateEnvironmentActionRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentActionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ActionParameters> PARAMETERS_FIELD = SdkField
            .<ActionParameters> builder(MarshallingType.SDK_POJO).memberName("parameters")
            .getter(getter(CreateEnvironmentActionRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(ActionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PARAMETERS_FIELD));

    private final String description;

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final String name;

    private final ActionParameters parameters;

    private CreateEnvironmentActionRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The description of the environment action that is being created in the environment.
     * </p>
     * 
     * @return The description of the environment action that is being created in the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the environment action is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the environment action is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the environment in which the environment action is created.
     * </p>
     * 
     * @return The ID of the environment in which the environment action is created.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The name of the environment action.
     * </p>
     * 
     * @return The name of the environment action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The parameters of the environment action.
     * </p>
     * 
     * @return The parameters of the environment action.
     */
    public final ActionParameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentActionRequest)) {
            return false;
        }
        CreateEnvironmentActionRequest other = (CreateEnvironmentActionRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentActionRequest").add("Description", description())
                .add("DomainIdentifier", domainIdentifier()).add("EnvironmentIdentifier", environmentIdentifier())
                .add("Name", name()).add("Parameters", parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentActionRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentActionRequest> {
        /**
         * <p>
         * The description of the environment action that is being created in the environment.
         * </p>
         * 
         * @param description
         *        The description of the environment action that is being created in the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the environment action is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the Amazon DataZone domain in which the environment action is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the environment in which the environment action is created.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment in which the environment action is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The name of the environment action.
         * </p>
         * 
         * @param name
         *        The name of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The parameters of the environment action.
         * </p>
         * 
         * @param parameters
         *        The parameters of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ActionParameters parameters);

        /**
         * <p>
         * The parameters of the environment action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionParameters.Builder} avoiding the
         * need to create one manually via {@link ActionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(ActionParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link ActionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(ActionParameters)
         */
        default Builder parameters(Consumer<ActionParameters.Builder> parameters) {
            return parameters(ActionParameters.builder().applyMutation(parameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String description;

        private String domainIdentifier;

        private String environmentIdentifier;

        private String name;

        private ActionParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentActionRequest model) {
            super(model);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            name(model.name);
            parameters(model.parameters);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ActionParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(ActionParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(ActionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentActionRequest build() {
            return new CreateEnvironmentActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
