/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAssetFilterRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateAssetFilterRequest.Builder, CreateAssetFilterRequest> {
    private static final SdkField<String> ASSET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetIdentifier").getter(getter(CreateAssetFilterRequest::assetIdentifier))
            .setter(setter(Builder::assetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetIdentifier").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAssetFilterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AssetFilterConfiguration> CONFIGURATION_FIELD = SdkField
            .<AssetFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateAssetFilterRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AssetFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAssetFilterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateAssetFilterRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAssetFilterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDENTIFIER_FIELD,
            CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD));

    private final String assetIdentifier;

    private final String clientToken;

    private final AssetFilterConfiguration configuration;

    private final String description;

    private final String domainIdentifier;

    private final String name;

    private CreateAssetFilterRequest(BuilderImpl builder) {
        super(builder);
        this.assetIdentifier = builder.assetIdentifier;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the data asset.
     * </p>
     * 
     * @return The ID of the data asset.
     */
    public final String assetIdentifier() {
        return assetIdentifier;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration of the asset filter.
     * </p>
     * 
     * @return The configuration of the asset filter.
     */
    public final AssetFilterConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The description of the asset filter.
     * </p>
     * 
     * @return The description of the asset filter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain in which you want to create an asset filter.
     * </p>
     * 
     * @return The ID of the domain in which you want to create an asset filter.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The name of the asset filter.
     * </p>
     * 
     * @return The name of the asset filter.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetFilterRequest)) {
            return false;
        }
        CreateAssetFilterRequest other = (CreateAssetFilterRequest) obj;
        return Objects.equals(assetIdentifier(), other.assetIdentifier()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAssetFilterRequest").add("AssetIdentifier", assetIdentifier())
                .add("ClientToken", clientToken()).add("Configuration", configuration())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetIdentifier":
            return Optional.ofNullable(clazz.cast(assetIdentifier()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetFilterRequest, T> g) {
        return obj -> g.apply((CreateAssetFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAssetFilterRequest> {
        /**
         * <p>
         * The ID of the data asset.
         * </p>
         * 
         * @param assetIdentifier
         *        The ID of the data asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIdentifier(String assetIdentifier);

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration of the asset filter.
         * </p>
         * 
         * @param configuration
         *        The configuration of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AssetFilterConfiguration configuration);

        /**
         * <p>
         * The configuration of the asset filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link AssetFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AssetFilterConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AssetFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AssetFilterConfiguration)
         */
        default Builder configuration(Consumer<AssetFilterConfiguration.Builder> configuration) {
            return configuration(AssetFilterConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The description of the asset filter.
         * </p>
         * 
         * @param description
         *        The description of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain in which you want to create an asset filter.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain in which you want to create an asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The name of the asset filter.
         * </p>
         * 
         * @param name
         *        The name of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String assetIdentifier;

        private String clientToken;

        private AssetFilterConfiguration configuration;

        private String description;

        private String domainIdentifier;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetFilterRequest model) {
            super(model);
            assetIdentifier(model.assetIdentifier);
            clientToken(model.clientToken);
            configuration(model.configuration);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            name(model.name);
        }

        public final String getAssetIdentifier() {
            return assetIdentifier;
        }

        public final void setAssetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
        }

        @Override
        public final Builder assetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AssetFilterConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AssetFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AssetFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetFilterRequest build() {
            return new CreateAssetFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
