/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the policy grant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectPolicyGrantDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateProjectPolicyGrantDetail.Builder, CreateProjectPolicyGrantDetail> {
    private static final SdkField<Boolean> INCLUDE_CHILD_DOMAIN_UNITS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildDomainUnits").getter(getter(CreateProjectPolicyGrantDetail::includeChildDomainUnits))
            .setter(setter(Builder::includeChildDomainUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildDomainUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INCLUDE_CHILD_DOMAIN_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean includeChildDomainUnits;

    private CreateProjectPolicyGrantDetail(BuilderImpl builder) {
        this.includeChildDomainUnits = builder.includeChildDomainUnits;
    }

    /**
     * <p>
     * Specifies whether the policy grant is applied to child domain units.
     * </p>
     * 
     * @return Specifies whether the policy grant is applied to child domain units.
     */
    public final Boolean includeChildDomainUnits() {
        return includeChildDomainUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(includeChildDomainUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectPolicyGrantDetail)) {
            return false;
        }
        CreateProjectPolicyGrantDetail other = (CreateProjectPolicyGrantDetail) obj;
        return Objects.equals(includeChildDomainUnits(), other.includeChildDomainUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectPolicyGrantDetail").add("IncludeChildDomainUnits", includeChildDomainUnits())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "includeChildDomainUnits":
            return Optional.ofNullable(clazz.cast(includeChildDomainUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectPolicyGrantDetail, T> g) {
        return obj -> g.apply((CreateProjectPolicyGrantDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateProjectPolicyGrantDetail> {
        /**
         * <p>
         * Specifies whether the policy grant is applied to child domain units.
         * </p>
         * 
         * @param includeChildDomainUnits
         *        Specifies whether the policy grant is applied to child domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildDomainUnits(Boolean includeChildDomainUnits);
    }

    static final class BuilderImpl implements Builder {
        private Boolean includeChildDomainUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectPolicyGrantDetail model) {
            includeChildDomainUnits(model.includeChildDomainUnits);
        }

        public final Boolean getIncludeChildDomainUnits() {
            return includeChildDomainUnits;
        }

        public final void setIncludeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
        }

        @Override
        public final Builder includeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
            return this;
        }

        @Override
        public CreateProjectPolicyGrantDetail build() {
            return new CreateProjectPolicyGrantDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
