/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentActionResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetEnvironmentActionResponse.Builder, GetEnvironmentActionResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetEnvironmentActionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetEnvironmentActionResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(GetEnvironmentActionResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetEnvironmentActionResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetEnvironmentActionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ActionParameters> PARAMETERS_FIELD = SdkField
            .<ActionParameters> builder(MarshallingType.SDK_POJO).memberName("parameters")
            .getter(getter(GetEnvironmentActionResponse::parameters)).setter(setter(Builder::parameters))
            .constructor(ActionParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_ID_FIELD, ENVIRONMENT_ID_FIELD, ID_FIELD, NAME_FIELD, PARAMETERS_FIELD));

    private final String description;

    private final String domainId;

    private final String environmentId;

    private final String id;

    private final String name;

    private final ActionParameters parameters;

    private GetEnvironmentActionResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentId = builder.environmentId;
        this.id = builder.id;
        this.name = builder.name;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The description of the environment action.
     * </p>
     * 
     * @return The description of the environment action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the environment action lives.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the environment action lives.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The environment ID of the environment action.
     * </p>
     * 
     * @return The environment ID of the environment action.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The ID of the environment action.
     * </p>
     * 
     * @return The ID of the environment action.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment action.
     * </p>
     * 
     * @return The name of the environment action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The parameters of the environment action.
     * </p>
     * 
     * @return The parameters of the environment action.
     */
    public final ActionParameters parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentActionResponse)) {
            return false;
        }
        GetEnvironmentActionResponse other = (GetEnvironmentActionResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentActionResponse").add("Description", description()).add("DomainId", domainId())
                .add("EnvironmentId", environmentId()).add("Id", id()).add("Name", name()).add("Parameters", parameters())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentActionResponse, T> g) {
        return obj -> g.apply((GetEnvironmentActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEnvironmentActionResponse> {
        /**
         * <p>
         * The description of the environment action.
         * </p>
         * 
         * @param description
         *        The description of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the environment action lives.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which the environment action lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The environment ID of the environment action.
         * </p>
         * 
         * @param environmentId
         *        The environment ID of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The ID of the environment action.
         * </p>
         * 
         * @param id
         *        The ID of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment action.
         * </p>
         * 
         * @param name
         *        The name of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The parameters of the environment action.
         * </p>
         * 
         * @param parameters
         *        The parameters of the environment action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ActionParameters parameters);

        /**
         * <p>
         * The parameters of the environment action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionParameters.Builder} avoiding the
         * need to create one manually via {@link ActionParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionParameters.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(ActionParameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link ActionParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(ActionParameters)
         */
        default Builder parameters(Consumer<ActionParameters.Builder> parameters) {
            return parameters(ActionParameters.builder().applyMutation(parameters).build());
        }
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String description;

        private String domainId;

        private String environmentId;

        private String id;

        private String name;

        private ActionParameters parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentActionResponse model) {
            super(model);
            description(model.description);
            domainId(model.domainId);
            environmentId(model.environmentId);
            id(model.id);
            name(model.name);
            parameters(model.parameters);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ActionParameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(ActionParameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        public final Builder parameters(ActionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Override
        public GetEnvironmentActionResponse build() {
            return new GetEnvironmentActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
