/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEnvironmentBlueprintConfigurationRequest extends DataZoneRequest implements
        ToCopyableBuilder<PutEnvironmentBlueprintConfigurationRequest.Builder, PutEnvironmentBlueprintConfigurationRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(PutEnvironmentBlueprintConfigurationRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<List<String>> ENABLED_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enabledRegions")
            .getter(getter(PutEnvironmentBlueprintConfigurationRequest::enabledRegions))
            .setter(setter(Builder::enabledRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintIdentifier")
            .getter(getter(PutEnvironmentBlueprintConfigurationRequest::environmentBlueprintIdentifier))
            .setter(setter(Builder::environmentBlueprintIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentBlueprintIdentifier")
                    .build()).build();

    private static final SdkField<String> MANAGE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("manageAccessRoleArn").getter(getter(PutEnvironmentBlueprintConfigurationRequest::manageAccessRoleArn))
            .setter(setter(Builder::manageAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRoleArn").build())
            .build();

    private static final SdkField<List<ProvisioningConfiguration>> PROVISIONING_CONFIGURATIONS_FIELD = SdkField
            .<List<ProvisioningConfiguration>> builder(MarshallingType.LIST)
            .memberName("provisioningConfigurations")
            .getter(getter(PutEnvironmentBlueprintConfigurationRequest::provisioningConfigurations))
            .setter(setter(Builder::provisioningConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProvisioningConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProvisioningConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provisioningRoleArn").getter(getter(PutEnvironmentBlueprintConfigurationRequest::provisioningRoleArn))
            .setter(setter(Builder::provisioningRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build())
            .build();

    private static final SdkField<Map<String, Map<String, String>>> REGIONAL_PARAMETERS_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("regionalParameters")
            .getter(getter(PutEnvironmentBlueprintConfigurationRequest::regionalParameters))
            .setter(setter(Builder::regionalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            ENABLED_REGIONS_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD, MANAGE_ACCESS_ROLE_ARN_FIELD,
            PROVISIONING_CONFIGURATIONS_FIELD, PROVISIONING_ROLE_ARN_FIELD, REGIONAL_PARAMETERS_FIELD));

    private final String domainIdentifier;

    private final List<String> enabledRegions;

    private final String environmentBlueprintIdentifier;

    private final String manageAccessRoleArn;

    private final List<ProvisioningConfiguration> provisioningConfigurations;

    private final String provisioningRoleArn;

    private final Map<String, Map<String, String>> regionalParameters;

    private PutEnvironmentBlueprintConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.enabledRegions = builder.enabledRegions;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.manageAccessRoleArn = builder.manageAccessRoleArn;
        this.provisioningConfigurations = builder.provisioningConfigurations;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.regionalParameters = builder.regionalParameters;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledRegions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnabledRegions() {
        return enabledRegions != null && !(enabledRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the enabled Amazon Web Services Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledRegions} method.
     * </p>
     * 
     * @return Specifies the enabled Amazon Web Services Regions.
     */
    public final List<String> enabledRegions() {
        return enabledRegions;
    }

    /**
     * <p>
     * The identifier of the environment blueprint.
     * </p>
     * 
     * @return The identifier of the environment blueprint.
     */
    public final String environmentBlueprintIdentifier() {
        return environmentBlueprintIdentifier;
    }

    /**
     * <p>
     * The ARN of the manage access role.
     * </p>
     * 
     * @return The ARN of the manage access role.
     */
    public final String manageAccessRoleArn() {
        return manageAccessRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisioningConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasProvisioningConfigurations() {
        return provisioningConfigurations != null && !(provisioningConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The provisioning configuration of a blueprint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisioningConfigurations} method.
     * </p>
     * 
     * @return The provisioning configuration of a blueprint.
     */
    public final List<ProvisioningConfiguration> provisioningConfigurations() {
        return provisioningConfigurations;
    }

    /**
     * <p>
     * The ARN of the provisioning role.
     * </p>
     * 
     * @return The ARN of the provisioning role.
     */
    public final String provisioningRoleArn() {
        return provisioningRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionalParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegionalParameters() {
        return regionalParameters != null && !(regionalParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The regional parameters in the environment blueprint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionalParameters} method.
     * </p>
     * 
     * @return The regional parameters in the environment blueprint.
     */
    public final Map<String, Map<String, String>> regionalParameters() {
        return regionalParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledRegions() ? enabledRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(manageAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisioningConfigurations() ? provisioningConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionalParameters() ? regionalParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEnvironmentBlueprintConfigurationRequest)) {
            return false;
        }
        PutEnvironmentBlueprintConfigurationRequest other = (PutEnvironmentBlueprintConfigurationRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && hasEnabledRegions() == other.hasEnabledRegions()
                && Objects.equals(enabledRegions(), other.enabledRegions())
                && Objects.equals(environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier())
                && Objects.equals(manageAccessRoleArn(), other.manageAccessRoleArn())
                && hasProvisioningConfigurations() == other.hasProvisioningConfigurations()
                && Objects.equals(provisioningConfigurations(), other.provisioningConfigurations())
                && Objects.equals(provisioningRoleArn(), other.provisioningRoleArn())
                && hasRegionalParameters() == other.hasRegionalParameters()
                && Objects.equals(regionalParameters(), other.regionalParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutEnvironmentBlueprintConfigurationRequest").add("DomainIdentifier", domainIdentifier())
                .add("EnabledRegions", hasEnabledRegions() ? enabledRegions() : null)
                .add("EnvironmentBlueprintIdentifier", environmentBlueprintIdentifier())
                .add("ManageAccessRoleArn", manageAccessRoleArn())
                .add("ProvisioningConfigurations", hasProvisioningConfigurations() ? provisioningConfigurations() : null)
                .add("ProvisioningRoleArn", provisioningRoleArn())
                .add("RegionalParameters", hasRegionalParameters() ? regionalParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "enabledRegions":
            return Optional.ofNullable(clazz.cast(enabledRegions()));
        case "environmentBlueprintIdentifier":
            return Optional.ofNullable(clazz.cast(environmentBlueprintIdentifier()));
        case "manageAccessRoleArn":
            return Optional.ofNullable(clazz.cast(manageAccessRoleArn()));
        case "provisioningConfigurations":
            return Optional.ofNullable(clazz.cast(provisioningConfigurations()));
        case "provisioningRoleArn":
            return Optional.ofNullable(clazz.cast(provisioningRoleArn()));
        case "regionalParameters":
            return Optional.ofNullable(clazz.cast(regionalParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEnvironmentBlueprintConfigurationRequest, T> g) {
        return obj -> g.apply((PutEnvironmentBlueprintConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEnvironmentBlueprintConfigurationRequest> {
        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * Specifies the enabled Amazon Web Services Regions.
         * </p>
         * 
         * @param enabledRegions
         *        Specifies the enabled Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledRegions(Collection<String> enabledRegions);

        /**
         * <p>
         * Specifies the enabled Amazon Web Services Regions.
         * </p>
         * 
         * @param enabledRegions
         *        Specifies the enabled Amazon Web Services Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledRegions(String... enabledRegions);

        /**
         * <p>
         * The identifier of the environment blueprint.
         * </p>
         * 
         * @param environmentBlueprintIdentifier
         *        The identifier of the environment blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier);

        /**
         * <p>
         * The ARN of the manage access role.
         * </p>
         * 
         * @param manageAccessRoleArn
         *        The ARN of the manage access role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageAccessRoleArn(String manageAccessRoleArn);

        /**
         * <p>
         * The provisioning configuration of a blueprint.
         * </p>
         * 
         * @param provisioningConfigurations
         *        The provisioning configuration of a blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningConfigurations(Collection<ProvisioningConfiguration> provisioningConfigurations);

        /**
         * <p>
         * The provisioning configuration of a blueprint.
         * </p>
         * 
         * @param provisioningConfigurations
         *        The provisioning configuration of a blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningConfigurations(ProvisioningConfiguration... provisioningConfigurations);

        /**
         * <p>
         * The provisioning configuration of a blueprint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #provisioningConfigurations(List<ProvisioningConfiguration>)}.
         * 
         * @param provisioningConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningConfigurations(java.util.Collection<ProvisioningConfiguration>)
         */
        Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder>... provisioningConfigurations);

        /**
         * <p>
         * The ARN of the provisioning role.
         * </p>
         * 
         * @param provisioningRoleArn
         *        The ARN of the provisioning role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningRoleArn(String provisioningRoleArn);

        /**
         * <p>
         * The regional parameters in the environment blueprint.
         * </p>
         * 
         * @param regionalParameters
         *        The regional parameters in the environment blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private List<String> enabledRegions = DefaultSdkAutoConstructList.getInstance();

        private String environmentBlueprintIdentifier;

        private String manageAccessRoleArn;

        private List<ProvisioningConfiguration> provisioningConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String provisioningRoleArn;

        private Map<String, Map<String, String>> regionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEnvironmentBlueprintConfigurationRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            enabledRegions(model.enabledRegions);
            environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            manageAccessRoleArn(model.manageAccessRoleArn);
            provisioningConfigurations(model.provisioningConfigurations);
            provisioningRoleArn(model.provisioningRoleArn);
            regionalParameters(model.regionalParameters);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Collection<String> getEnabledRegions() {
            if (enabledRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledRegions;
        }

        public final void setEnabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
        }

        @Override
        public final Builder enabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledRegions(String... enabledRegions) {
            enabledRegions(Arrays.asList(enabledRegions));
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final String getManageAccessRoleArn() {
            return manageAccessRoleArn;
        }

        public final void setManageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
        }

        @Override
        public final Builder manageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
            return this;
        }

        public final List<ProvisioningConfiguration.Builder> getProvisioningConfigurations() {
            List<ProvisioningConfiguration.Builder> result = ProvisioningConfigurationListCopier
                    .copyToBuilder(this.provisioningConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningConfigurations(
                Collection<ProvisioningConfiguration.BuilderImpl> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copyFromBuilder(provisioningConfigurations);
        }

        @Override
        public final Builder provisioningConfigurations(Collection<ProvisioningConfiguration> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copy(provisioningConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(ProvisioningConfiguration... provisioningConfigurations) {
            provisioningConfigurations(Arrays.asList(provisioningConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder>... provisioningConfigurations) {
            provisioningConfigurations(Stream.of(provisioningConfigurations)
                    .map(c -> ProvisioningConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProvisioningRoleArn() {
            return provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getRegionalParameters() {
            if (regionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return regionalParameters;
        }

        public final void setRegionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
        }

        @Override
        public final Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEnvironmentBlueprintConfigurationRequest build() {
            return new PutEnvironmentBlueprintConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
