/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveEntityOwnerRequest extends DataZoneRequest implements
        ToCopyableBuilder<RemoveEntityOwnerRequest.Builder, RemoveEntityOwnerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(RemoveEntityOwnerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(RemoveEntityOwnerRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityIdentifier").getter(getter(RemoveEntityOwnerRequest::entityIdentifier))
            .setter(setter(Builder::entityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(RemoveEntityOwnerRequest::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()).build();

    private static final SdkField<OwnerProperties> OWNER_FIELD = SdkField.<OwnerProperties> builder(MarshallingType.SDK_POJO)
            .memberName("owner").getter(getter(RemoveEntityOwnerRequest::owner)).setter(setter(Builder::owner))
            .constructor(OwnerProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, OWNER_FIELD));

    private final String clientToken;

    private final String domainIdentifier;

    private final String entityIdentifier;

    private final String entityType;

    private final OwnerProperties owner;

    private RemoveEntityOwnerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.owner = builder.owner;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the domain where you want to remove an owner from an entity.
     * </p>
     * 
     * @return The ID of the domain where you want to remove an owner from an entity.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the entity from which you want to remove an owner.
     * </p>
     * 
     * @return The ID of the entity from which you want to remove an owner.
     */
    public final String entityIdentifier() {
        return entityIdentifier;
    }

    /**
     * <p>
     * The type of the entity from which you want to remove an owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link DataZoneEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the entity from which you want to remove an owner.
     * @see DataZoneEntityType
     */
    public final DataZoneEntityType entityType() {
        return DataZoneEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the entity from which you want to remove an owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link DataZoneEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the entity from which you want to remove an owner.
     * @see DataZoneEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The owner that you want to remove from an entity.
     * </p>
     * 
     * @return The owner that you want to remove from an entity.
     */
    public final OwnerProperties owner() {
        return owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveEntityOwnerRequest)) {
            return false;
        }
        RemoveEntityOwnerRequest other = (RemoveEntityOwnerRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(entityIdentifier(), other.entityIdentifier())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(owner(), other.owner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveEntityOwnerRequest").add("ClientToken", clientToken())
                .add("DomainIdentifier", domainIdentifier()).add("EntityIdentifier", entityIdentifier())
                .add("EntityType", entityTypeAsString()).add("Owner", owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "entityIdentifier":
            return Optional.ofNullable(clazz.cast(entityIdentifier()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "owner":
            return Optional.ofNullable(clazz.cast(owner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveEntityOwnerRequest, T> g) {
        return obj -> g.apply((RemoveEntityOwnerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveEntityOwnerRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the domain where you want to remove an owner from an entity.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where you want to remove an owner from an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the entity from which you want to remove an owner.
         * </p>
         * 
         * @param entityIdentifier
         *        The ID of the entity from which you want to remove an owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityIdentifier(String entityIdentifier);

        /**
         * <p>
         * The type of the entity from which you want to remove an owner.
         * </p>
         * 
         * @param entityType
         *        The type of the entity from which you want to remove an owner.
         * @see DataZoneEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataZoneEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the entity from which you want to remove an owner.
         * </p>
         * 
         * @param entityType
         *        The type of the entity from which you want to remove an owner.
         * @see DataZoneEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataZoneEntityType
         */
        Builder entityType(DataZoneEntityType entityType);

        /**
         * <p>
         * The owner that you want to remove from an entity.
         * </p>
         * 
         * @param owner
         *        The owner that you want to remove from an entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(OwnerProperties owner);

        /**
         * <p>
         * The owner that you want to remove from an entity.
         * </p>
         * This is a convenience method that creates an instance of the {@link OwnerProperties.Builder} avoiding the
         * need to create one manually via {@link OwnerProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnerProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #owner(OwnerProperties)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link OwnerProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(OwnerProperties)
         */
        default Builder owner(Consumer<OwnerProperties.Builder> owner) {
            return owner(OwnerProperties.builder().applyMutation(owner).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String domainIdentifier;

        private String entityIdentifier;

        private String entityType;

        private OwnerProperties owner;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveEntityOwnerRequest model) {
            super(model);
            clientToken(model.clientToken);
            domainIdentifier(model.domainIdentifier);
            entityIdentifier(model.entityIdentifier);
            entityType(model.entityType);
            owner(model.owner);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(DataZoneEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final OwnerProperties.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        public final void setOwner(OwnerProperties.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(OwnerProperties owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveEntityOwnerRequest build() {
            return new RemoveEntityOwnerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
