/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the results of the <code>SearchTypes</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchTypesResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchTypesResultItem.Builder, SearchTypesResultItem> {
    private static final SdkField<AssetTypeItem> ASSET_TYPE_ITEM_FIELD = SdkField
            .<AssetTypeItem> builder(MarshallingType.SDK_POJO).memberName("assetTypeItem")
            .getter(getter(SearchTypesResultItem::assetTypeItem)).setter(setter(Builder::assetTypeItem))
            .constructor(AssetTypeItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetTypeItem").build()).build();

    private static final SdkField<FormTypeData> FORM_TYPE_ITEM_FIELD = SdkField.<FormTypeData> builder(MarshallingType.SDK_POJO)
            .memberName("formTypeItem").getter(getter(SearchTypesResultItem::formTypeItem)).setter(setter(Builder::formTypeItem))
            .constructor(FormTypeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formTypeItem").build()).build();

    private static final SdkField<LineageNodeTypeItem> LINEAGE_NODE_TYPE_ITEM_FIELD = SdkField
            .<LineageNodeTypeItem> builder(MarshallingType.SDK_POJO).memberName("lineageNodeTypeItem")
            .getter(getter(SearchTypesResultItem::lineageNodeTypeItem)).setter(setter(Builder::lineageNodeTypeItem))
            .constructor(LineageNodeTypeItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageNodeTypeItem").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_TYPE_ITEM_FIELD,
            FORM_TYPE_ITEM_FIELD, LINEAGE_NODE_TYPE_ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final AssetTypeItem assetTypeItem;

    private final FormTypeData formTypeItem;

    private final LineageNodeTypeItem lineageNodeTypeItem;

    private final Type type;

    private SearchTypesResultItem(BuilderImpl builder) {
        this.assetTypeItem = builder.assetTypeItem;
        this.formTypeItem = builder.formTypeItem;
        this.lineageNodeTypeItem = builder.lineageNodeTypeItem;
        this.type = builder.type;
    }

    /**
     * <p>
     * The asset type included in the results of the <code>SearchTypes</code> action.
     * </p>
     * 
     * @return The asset type included in the results of the <code>SearchTypes</code> action.
     */
    public final AssetTypeItem assetTypeItem() {
        return assetTypeItem;
    }

    /**
     * <p>
     * The form type included in the results of the <code>SearchTypes</code> action.
     * </p>
     * 
     * @return The form type included in the results of the <code>SearchTypes</code> action.
     */
    public final FormTypeData formTypeItem() {
        return formTypeItem;
    }

    /**
     * <p>
     * The details of a data lineage node type.
     * </p>
     * 
     * @return The details of a data lineage node type.
     */
    public final LineageNodeTypeItem lineageNodeTypeItem() {
        return lineageNodeTypeItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetTypeItem());
        hashCode = 31 * hashCode + Objects.hashCode(formTypeItem());
        hashCode = 31 * hashCode + Objects.hashCode(lineageNodeTypeItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTypesResultItem)) {
            return false;
        }
        SearchTypesResultItem other = (SearchTypesResultItem) obj;
        return Objects.equals(assetTypeItem(), other.assetTypeItem()) && Objects.equals(formTypeItem(), other.formTypeItem())
                && Objects.equals(lineageNodeTypeItem(), other.lineageNodeTypeItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchTypesResultItem").add("AssetTypeItem", assetTypeItem())
                .add("FormTypeItem", formTypeItem()).add("LineageNodeTypeItem", lineageNodeTypeItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetTypeItem":
            return Optional.ofNullable(clazz.cast(assetTypeItem()));
        case "formTypeItem":
            return Optional.ofNullable(clazz.cast(formTypeItem()));
        case "lineageNodeTypeItem":
            return Optional.ofNullable(clazz.cast(lineageNodeTypeItem()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #assetTypeItem()} initialized to the given value.
     *
     * <p>
     * The asset type included in the results of the <code>SearchTypes</code> action.
     * </p>
     * 
     * @param assetTypeItem
     *        The asset type included in the results of the <code>SearchTypes</code> action.
     */
    public static SearchTypesResultItem fromAssetTypeItem(AssetTypeItem assetTypeItem) {
        return builder().assetTypeItem(assetTypeItem).build();
    }

    /**
     * Create an instance of this class with {@link #assetTypeItem()} initialized to the given value.
     *
     * <p>
     * The asset type included in the results of the <code>SearchTypes</code> action.
     * </p>
     * 
     * @param assetTypeItem
     *        The asset type included in the results of the <code>SearchTypes</code> action.
     */
    public static SearchTypesResultItem fromAssetTypeItem(Consumer<AssetTypeItem.Builder> assetTypeItem) {
        AssetTypeItem.Builder builder = AssetTypeItem.builder();
        assetTypeItem.accept(builder);
        return fromAssetTypeItem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #formTypeItem()} initialized to the given value.
     *
     * <p>
     * The form type included in the results of the <code>SearchTypes</code> action.
     * </p>
     * 
     * @param formTypeItem
     *        The form type included in the results of the <code>SearchTypes</code> action.
     */
    public static SearchTypesResultItem fromFormTypeItem(FormTypeData formTypeItem) {
        return builder().formTypeItem(formTypeItem).build();
    }

    /**
     * Create an instance of this class with {@link #formTypeItem()} initialized to the given value.
     *
     * <p>
     * The form type included in the results of the <code>SearchTypes</code> action.
     * </p>
     * 
     * @param formTypeItem
     *        The form type included in the results of the <code>SearchTypes</code> action.
     */
    public static SearchTypesResultItem fromFormTypeItem(Consumer<FormTypeData.Builder> formTypeItem) {
        FormTypeData.Builder builder = FormTypeData.builder();
        formTypeItem.accept(builder);
        return fromFormTypeItem(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lineageNodeTypeItem()} initialized to the given value.
     *
     * <p>
     * The details of a data lineage node type.
     * </p>
     * 
     * @param lineageNodeTypeItem
     *        The details of a data lineage node type.
     */
    public static SearchTypesResultItem fromLineageNodeTypeItem(LineageNodeTypeItem lineageNodeTypeItem) {
        return builder().lineageNodeTypeItem(lineageNodeTypeItem).build();
    }

    /**
     * Create an instance of this class with {@link #lineageNodeTypeItem()} initialized to the given value.
     *
     * <p>
     * The details of a data lineage node type.
     * </p>
     * 
     * @param lineageNodeTypeItem
     *        The details of a data lineage node type.
     */
    public static SearchTypesResultItem fromLineageNodeTypeItem(Consumer<LineageNodeTypeItem.Builder> lineageNodeTypeItem) {
        LineageNodeTypeItem.Builder builder = LineageNodeTypeItem.builder();
        lineageNodeTypeItem.accept(builder);
        return fromLineageNodeTypeItem(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTypesResultItem, T> g) {
        return obj -> g.apply((SearchTypesResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchTypesResultItem> {
        /**
         * <p>
         * The asset type included in the results of the <code>SearchTypes</code> action.
         * </p>
         * 
         * @param assetTypeItem
         *        The asset type included in the results of the <code>SearchTypes</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetTypeItem(AssetTypeItem assetTypeItem);

        /**
         * <p>
         * The asset type included in the results of the <code>SearchTypes</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetTypeItem.Builder} avoiding the need
         * to create one manually via {@link AssetTypeItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetTypeItem.Builder#build()} is called immediately and its
         * result is passed to {@link #assetTypeItem(AssetTypeItem)}.
         * 
         * @param assetTypeItem
         *        a consumer that will call methods on {@link AssetTypeItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetTypeItem(AssetTypeItem)
         */
        default Builder assetTypeItem(Consumer<AssetTypeItem.Builder> assetTypeItem) {
            return assetTypeItem(AssetTypeItem.builder().applyMutation(assetTypeItem).build());
        }

        /**
         * <p>
         * The form type included in the results of the <code>SearchTypes</code> action.
         * </p>
         * 
         * @param formTypeItem
         *        The form type included in the results of the <code>SearchTypes</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formTypeItem(FormTypeData formTypeItem);

        /**
         * <p>
         * The form type included in the results of the <code>SearchTypes</code> action.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormTypeData.Builder} avoiding the need
         * to create one manually via {@link FormTypeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormTypeData.Builder#build()} is called immediately and its
         * result is passed to {@link #formTypeItem(FormTypeData)}.
         * 
         * @param formTypeItem
         *        a consumer that will call methods on {@link FormTypeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formTypeItem(FormTypeData)
         */
        default Builder formTypeItem(Consumer<FormTypeData.Builder> formTypeItem) {
            return formTypeItem(FormTypeData.builder().applyMutation(formTypeItem).build());
        }

        /**
         * <p>
         * The details of a data lineage node type.
         * </p>
         * 
         * @param lineageNodeTypeItem
         *        The details of a data lineage node type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageNodeTypeItem(LineageNodeTypeItem lineageNodeTypeItem);

        /**
         * <p>
         * The details of a data lineage node type.
         * </p>
         * This is a convenience method that creates an instance of the {@link LineageNodeTypeItem.Builder} avoiding the
         * need to create one manually via {@link LineageNodeTypeItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LineageNodeTypeItem.Builder#build()} is called immediately and
         * its result is passed to {@link #lineageNodeTypeItem(LineageNodeTypeItem)}.
         * 
         * @param lineageNodeTypeItem
         *        a consumer that will call methods on {@link LineageNodeTypeItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lineageNodeTypeItem(LineageNodeTypeItem)
         */
        default Builder lineageNodeTypeItem(Consumer<LineageNodeTypeItem.Builder> lineageNodeTypeItem) {
            return lineageNodeTypeItem(LineageNodeTypeItem.builder().applyMutation(lineageNodeTypeItem).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AssetTypeItem assetTypeItem;

        private FormTypeData formTypeItem;

        private LineageNodeTypeItem lineageNodeTypeItem;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTypesResultItem model) {
            assetTypeItem(model.assetTypeItem);
            formTypeItem(model.formTypeItem);
            lineageNodeTypeItem(model.lineageNodeTypeItem);
        }

        public final AssetTypeItem.Builder getAssetTypeItem() {
            return assetTypeItem != null ? assetTypeItem.toBuilder() : null;
        }

        public final void setAssetTypeItem(AssetTypeItem.BuilderImpl assetTypeItem) {
            Object oldValue = this.assetTypeItem;
            this.assetTypeItem = assetTypeItem != null ? assetTypeItem.build() : null;
            handleUnionValueChange(Type.ASSET_TYPE_ITEM, oldValue, this.assetTypeItem);
        }

        @Override
        public final Builder assetTypeItem(AssetTypeItem assetTypeItem) {
            Object oldValue = this.assetTypeItem;
            this.assetTypeItem = assetTypeItem;
            handleUnionValueChange(Type.ASSET_TYPE_ITEM, oldValue, this.assetTypeItem);
            return this;
        }

        public final FormTypeData.Builder getFormTypeItem() {
            return formTypeItem != null ? formTypeItem.toBuilder() : null;
        }

        public final void setFormTypeItem(FormTypeData.BuilderImpl formTypeItem) {
            Object oldValue = this.formTypeItem;
            this.formTypeItem = formTypeItem != null ? formTypeItem.build() : null;
            handleUnionValueChange(Type.FORM_TYPE_ITEM, oldValue, this.formTypeItem);
        }

        @Override
        public final Builder formTypeItem(FormTypeData formTypeItem) {
            Object oldValue = this.formTypeItem;
            this.formTypeItem = formTypeItem;
            handleUnionValueChange(Type.FORM_TYPE_ITEM, oldValue, this.formTypeItem);
            return this;
        }

        public final LineageNodeTypeItem.Builder getLineageNodeTypeItem() {
            return lineageNodeTypeItem != null ? lineageNodeTypeItem.toBuilder() : null;
        }

        public final void setLineageNodeTypeItem(LineageNodeTypeItem.BuilderImpl lineageNodeTypeItem) {
            Object oldValue = this.lineageNodeTypeItem;
            this.lineageNodeTypeItem = lineageNodeTypeItem != null ? lineageNodeTypeItem.build() : null;
            handleUnionValueChange(Type.LINEAGE_NODE_TYPE_ITEM, oldValue, this.lineageNodeTypeItem);
        }

        @Override
        public final Builder lineageNodeTypeItem(LineageNodeTypeItem lineageNodeTypeItem) {
            Object oldValue = this.lineageNodeTypeItem;
            this.lineageNodeTypeItem = lineageNodeTypeItem;
            handleUnionValueChange(Type.LINEAGE_NODE_TYPE_ITEM, oldValue, this.lineageNodeTypeItem);
            return this;
        }

        @Override
        public SearchTypesResultItem build() {
            return new SearchTypesResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SearchTypesResultItem#type()
     */
    public enum Type {
        ASSET_TYPE_ITEM,

        FORM_TYPE_ITEM,

        LINEAGE_NODE_TYPE_ITEM,

        UNKNOWN_TO_SDK_VERSION
    }
}
