/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the self granting status for a data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfGrantStatusOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfGrantStatusOutput.Builder, SelfGrantStatusOutput> {
    private static final SdkField<GlueSelfGrantStatusOutput> GLUE_SELF_GRANT_STATUS_FIELD = SdkField
            .<GlueSelfGrantStatusOutput> builder(MarshallingType.SDK_POJO).memberName("glueSelfGrantStatus")
            .getter(getter(SelfGrantStatusOutput::glueSelfGrantStatus)).setter(setter(Builder::glueSelfGrantStatus))
            .constructor(GlueSelfGrantStatusOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueSelfGrantStatus").build())
            .build();

    private static final SdkField<RedshiftSelfGrantStatusOutput> REDSHIFT_SELF_GRANT_STATUS_FIELD = SdkField
            .<RedshiftSelfGrantStatusOutput> builder(MarshallingType.SDK_POJO).memberName("redshiftSelfGrantStatus")
            .getter(getter(SelfGrantStatusOutput::redshiftSelfGrantStatus)).setter(setter(Builder::redshiftSelfGrantStatus))
            .constructor(RedshiftSelfGrantStatusOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftSelfGrantStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_SELF_GRANT_STATUS_FIELD,
            REDSHIFT_SELF_GRANT_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final GlueSelfGrantStatusOutput glueSelfGrantStatus;

    private final RedshiftSelfGrantStatusOutput redshiftSelfGrantStatus;

    private final Type type;

    private SelfGrantStatusOutput(BuilderImpl builder) {
        this.glueSelfGrantStatus = builder.glueSelfGrantStatus;
        this.redshiftSelfGrantStatus = builder.redshiftSelfGrantStatus;
        this.type = builder.type;
    }

    /**
     * <p>
     * The details for the self granting status for a Glue data source.
     * </p>
     * 
     * @return The details for the self granting status for a Glue data source.
     */
    public final GlueSelfGrantStatusOutput glueSelfGrantStatus() {
        return glueSelfGrantStatus;
    }

    /**
     * <p>
     * The details for the self granting status for an Amazon Redshift data source.
     * </p>
     * 
     * @return The details for the self granting status for an Amazon Redshift data source.
     */
    public final RedshiftSelfGrantStatusOutput redshiftSelfGrantStatus() {
        return redshiftSelfGrantStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueSelfGrantStatus());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftSelfGrantStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfGrantStatusOutput)) {
            return false;
        }
        SelfGrantStatusOutput other = (SelfGrantStatusOutput) obj;
        return Objects.equals(glueSelfGrantStatus(), other.glueSelfGrantStatus())
                && Objects.equals(redshiftSelfGrantStatus(), other.redshiftSelfGrantStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfGrantStatusOutput").add("GlueSelfGrantStatus", glueSelfGrantStatus())
                .add("RedshiftSelfGrantStatus", redshiftSelfGrantStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glueSelfGrantStatus":
            return Optional.ofNullable(clazz.cast(glueSelfGrantStatus()));
        case "redshiftSelfGrantStatus":
            return Optional.ofNullable(clazz.cast(redshiftSelfGrantStatus()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #glueSelfGrantStatus()} initialized to the given value.
     *
     * <p>
     * The details for the self granting status for a Glue data source.
     * </p>
     * 
     * @param glueSelfGrantStatus
     *        The details for the self granting status for a Glue data source.
     */
    public static SelfGrantStatusOutput fromGlueSelfGrantStatus(GlueSelfGrantStatusOutput glueSelfGrantStatus) {
        return builder().glueSelfGrantStatus(glueSelfGrantStatus).build();
    }

    /**
     * Create an instance of this class with {@link #glueSelfGrantStatus()} initialized to the given value.
     *
     * <p>
     * The details for the self granting status for a Glue data source.
     * </p>
     * 
     * @param glueSelfGrantStatus
     *        The details for the self granting status for a Glue data source.
     */
    public static SelfGrantStatusOutput fromGlueSelfGrantStatus(Consumer<GlueSelfGrantStatusOutput.Builder> glueSelfGrantStatus) {
        GlueSelfGrantStatusOutput.Builder builder = GlueSelfGrantStatusOutput.builder();
        glueSelfGrantStatus.accept(builder);
        return fromGlueSelfGrantStatus(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftSelfGrantStatus()} initialized to the given value.
     *
     * <p>
     * The details for the self granting status for an Amazon Redshift data source.
     * </p>
     * 
     * @param redshiftSelfGrantStatus
     *        The details for the self granting status for an Amazon Redshift data source.
     */
    public static SelfGrantStatusOutput fromRedshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput redshiftSelfGrantStatus) {
        return builder().redshiftSelfGrantStatus(redshiftSelfGrantStatus).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftSelfGrantStatus()} initialized to the given value.
     *
     * <p>
     * The details for the self granting status for an Amazon Redshift data source.
     * </p>
     * 
     * @param redshiftSelfGrantStatus
     *        The details for the self granting status for an Amazon Redshift data source.
     */
    public static SelfGrantStatusOutput fromRedshiftSelfGrantStatus(
            Consumer<RedshiftSelfGrantStatusOutput.Builder> redshiftSelfGrantStatus) {
        RedshiftSelfGrantStatusOutput.Builder builder = RedshiftSelfGrantStatusOutput.builder();
        redshiftSelfGrantStatus.accept(builder);
        return fromRedshiftSelfGrantStatus(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfGrantStatusOutput, T> g) {
        return obj -> g.apply((SelfGrantStatusOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfGrantStatusOutput> {
        /**
         * <p>
         * The details for the self granting status for a Glue data source.
         * </p>
         * 
         * @param glueSelfGrantStatus
         *        The details for the self granting status for a Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueSelfGrantStatus(GlueSelfGrantStatusOutput glueSelfGrantStatus);

        /**
         * <p>
         * The details for the self granting status for a Glue data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlueSelfGrantStatusOutput.Builder}
         * avoiding the need to create one manually via {@link GlueSelfGrantStatusOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlueSelfGrantStatusOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #glueSelfGrantStatus(GlueSelfGrantStatusOutput)}.
         * 
         * @param glueSelfGrantStatus
         *        a consumer that will call methods on {@link GlueSelfGrantStatusOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueSelfGrantStatus(GlueSelfGrantStatusOutput)
         */
        default Builder glueSelfGrantStatus(Consumer<GlueSelfGrantStatusOutput.Builder> glueSelfGrantStatus) {
            return glueSelfGrantStatus(GlueSelfGrantStatusOutput.builder().applyMutation(glueSelfGrantStatus).build());
        }

        /**
         * <p>
         * The details for the self granting status for an Amazon Redshift data source.
         * </p>
         * 
         * @param redshiftSelfGrantStatus
         *        The details for the self granting status for an Amazon Redshift data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput redshiftSelfGrantStatus);

        /**
         * <p>
         * The details for the self granting status for an Amazon Redshift data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftSelfGrantStatusOutput.Builder}
         * avoiding the need to create one manually via {@link RedshiftSelfGrantStatusOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftSelfGrantStatusOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #redshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput)}.
         * 
         * @param redshiftSelfGrantStatus
         *        a consumer that will call methods on {@link RedshiftSelfGrantStatusOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput)
         */
        default Builder redshiftSelfGrantStatus(Consumer<RedshiftSelfGrantStatusOutput.Builder> redshiftSelfGrantStatus) {
            return redshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput.builder().applyMutation(redshiftSelfGrantStatus).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GlueSelfGrantStatusOutput glueSelfGrantStatus;

        private RedshiftSelfGrantStatusOutput redshiftSelfGrantStatus;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SelfGrantStatusOutput model) {
            glueSelfGrantStatus(model.glueSelfGrantStatus);
            redshiftSelfGrantStatus(model.redshiftSelfGrantStatus);
        }

        public final GlueSelfGrantStatusOutput.Builder getGlueSelfGrantStatus() {
            return glueSelfGrantStatus != null ? glueSelfGrantStatus.toBuilder() : null;
        }

        public final void setGlueSelfGrantStatus(GlueSelfGrantStatusOutput.BuilderImpl glueSelfGrantStatus) {
            Object oldValue = this.glueSelfGrantStatus;
            this.glueSelfGrantStatus = glueSelfGrantStatus != null ? glueSelfGrantStatus.build() : null;
            handleUnionValueChange(Type.GLUE_SELF_GRANT_STATUS, oldValue, this.glueSelfGrantStatus);
        }

        @Override
        public final Builder glueSelfGrantStatus(GlueSelfGrantStatusOutput glueSelfGrantStatus) {
            Object oldValue = this.glueSelfGrantStatus;
            this.glueSelfGrantStatus = glueSelfGrantStatus;
            handleUnionValueChange(Type.GLUE_SELF_GRANT_STATUS, oldValue, this.glueSelfGrantStatus);
            return this;
        }

        public final RedshiftSelfGrantStatusOutput.Builder getRedshiftSelfGrantStatus() {
            return redshiftSelfGrantStatus != null ? redshiftSelfGrantStatus.toBuilder() : null;
        }

        public final void setRedshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput.BuilderImpl redshiftSelfGrantStatus) {
            Object oldValue = this.redshiftSelfGrantStatus;
            this.redshiftSelfGrantStatus = redshiftSelfGrantStatus != null ? redshiftSelfGrantStatus.build() : null;
            handleUnionValueChange(Type.REDSHIFT_SELF_GRANT_STATUS, oldValue, this.redshiftSelfGrantStatus);
        }

        @Override
        public final Builder redshiftSelfGrantStatus(RedshiftSelfGrantStatusOutput redshiftSelfGrantStatus) {
            Object oldValue = this.redshiftSelfGrantStatus;
            this.redshiftSelfGrantStatus = redshiftSelfGrantStatus;
            handleUnionValueChange(Type.REDSHIFT_SELF_GRANT_STATUS, oldValue, this.redshiftSelfGrantStatus);
            return this;
        }

        @Override
        public SelfGrantStatusOutput build() {
            return new SelfGrantStatusOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SelfGrantStatusOutput#type()
     */
    public enum Type {
        GLUE_SELF_GRANT_STATUS,

        REDSHIFT_SELF_GRANT_STATUS,

        UNKNOWN_TO_SDK_VERSION
    }
}
