/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainUnitsForParentRequest extends DataZoneRequest implements
        ToCopyableBuilder<ListDomainUnitsForParentRequest.Builder, ListDomainUnitsForParentRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(ListDomainUnitsForParentRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListDomainUnitsForParentRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListDomainUnitsForParentRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PARENT_DOMAIN_UNIT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("parentDomainUnitIdentifier")
            .getter(getter(ListDomainUnitsForParentRequest::parentDomainUnitIdentifier))
            .setter(setter(Builder::parentDomainUnitIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("parentDomainUnitIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PARENT_DOMAIN_UNIT_IDENTIFIER_FIELD));

    private final String domainIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String parentDomainUnitIdentifier;

    private ListDomainUnitsForParentRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.parentDomainUnitIdentifier = builder.parentDomainUnitIdentifier;
    }

    /**
     * <p>
     * The ID of the domain in which you want to list domain units for a parent domain unit.
     * </p>
     * 
     * @return The ID of the domain in which you want to list domain units for a parent domain unit.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The maximum number of domain units to return in a single call to ListDomainUnitsForParent. When the number of
     * domain units to be listed is greater than the value of MaxResults, the response contains a NextToken value that
     * you can use in a subsequent call to ListDomainUnitsForParent to list the next set of domain units.
     * </p>
     * 
     * @return The maximum number of domain units to return in a single call to ListDomainUnitsForParent. When the
     *         number of domain units to be listed is greater than the value of MaxResults, the response contains a
     *         NextToken value that you can use in a subsequent call to ListDomainUnitsForParent to list the next set of
     *         domain units.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * When the number of domain units is greater than the default value for the MaxResults parameter, or if you
     * explicitly specify a value for MaxResults that is less than the number of domain units, the response includes a
     * pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     * ListDomainUnitsForParent to list the next set of domain units.
     * </p>
     * 
     * @return When the number of domain units is greater than the default value for the MaxResults parameter, or if you
     *         explicitly specify a value for MaxResults that is less than the number of domain units, the response
     *         includes a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
     *         ListDomainUnitsForParent to list the next set of domain units.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the parent domain unit.
     * </p>
     * 
     * @return The ID of the parent domain unit.
     */
    public final String parentDomainUnitIdentifier() {
        return parentDomainUnitIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(parentDomainUnitIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainUnitsForParentRequest)) {
            return false;
        }
        ListDomainUnitsForParentRequest other = (ListDomainUnitsForParentRequest) obj;
        return Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(parentDomainUnitIdentifier(), other.parentDomainUnitIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDomainUnitsForParentRequest").add("DomainIdentifier", domainIdentifier())
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("ParentDomainUnitIdentifier", parentDomainUnitIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "parentDomainUnitIdentifier":
            return Optional.ofNullable(clazz.cast(parentDomainUnitIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainUnitsForParentRequest, T> g) {
        return obj -> g.apply((ListDomainUnitsForParentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainUnitsForParentRequest> {
        /**
         * <p>
         * The ID of the domain in which you want to list domain units for a parent domain unit.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain in which you want to list domain units for a parent domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The maximum number of domain units to return in a single call to ListDomainUnitsForParent. When the number of
         * domain units to be listed is greater than the value of MaxResults, the response contains a NextToken value
         * that you can use in a subsequent call to ListDomainUnitsForParent to list the next set of domain units.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of domain units to return in a single call to ListDomainUnitsForParent. When the
         *        number of domain units to be listed is greater than the value of MaxResults, the response contains a
         *        NextToken value that you can use in a subsequent call to ListDomainUnitsForParent to list the next set
         *        of domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * When the number of domain units is greater than the default value for the MaxResults parameter, or if you
         * explicitly specify a value for MaxResults that is less than the number of domain units, the response includes
         * a pagination token named NextToken. You can specify this NextToken value in a subsequent call to
         * ListDomainUnitsForParent to list the next set of domain units.
         * </p>
         * 
         * @param nextToken
         *        When the number of domain units is greater than the default value for the MaxResults parameter, or if
         *        you explicitly specify a value for MaxResults that is less than the number of domain units, the
         *        response includes a pagination token named NextToken. You can specify this NextToken value in a
         *        subsequent call to ListDomainUnitsForParent to list the next set of domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the parent domain unit.
         * </p>
         * 
         * @param parentDomainUnitIdentifier
         *        The ID of the parent domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentDomainUnitIdentifier(String parentDomainUnitIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String domainIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String parentDomainUnitIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainUnitsForParentRequest model) {
            super(model);
            domainIdentifier(model.domainIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            parentDomainUnitIdentifier(model.parentDomainUnitIdentifier);
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getParentDomainUnitIdentifier() {
            return parentDomainUnitIdentifier;
        }

        public final void setParentDomainUnitIdentifier(String parentDomainUnitIdentifier) {
            this.parentDomainUnitIdentifier = parentDomainUnitIdentifier;
        }

        @Override
        public final Builder parentDomainUnitIdentifier(String parentDomainUnitIdentifier) {
            this.parentDomainUnitIdentifier = parentDomainUnitIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDomainUnitsForParentRequest build() {
            return new ListDomainUnitsForParentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
