/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostTimeSeriesDataPointsResponse extends DataZoneResponse implements
        ToCopyableBuilder<PostTimeSeriesDataPointsResponse.Builder, PostTimeSeriesDataPointsResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(PostTimeSeriesDataPointsResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(PostTimeSeriesDataPointsResponse::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(PostTimeSeriesDataPointsResponse::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<List<TimeSeriesDataPointFormOutput>> FORMS_FIELD = SdkField
            .<List<TimeSeriesDataPointFormOutput>> builder(MarshallingType.LIST)
            .memberName("forms")
            .getter(getter(PostTimeSeriesDataPointsResponse::forms))
            .setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesDataPointFormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesDataPointFormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, FORMS_FIELD));

    private final String domainId;

    private final String entityId;

    private final String entityType;

    private final List<TimeSeriesDataPointFormOutput> forms;

    private PostTimeSeriesDataPointsResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.forms = builder.forms;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which you want to post time series data points.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which you want to post time series data points.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the asset for which you want to post time series data points.
     * </p>
     * 
     * @return The ID of the asset for which you want to post time series data points.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to post data points.
     * @see TimeSeriesEntityType
     */
    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the asset for which you want to post data points.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to post data points.
     * @see TimeSeriesEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Forms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasForms() {
        return forms != null && !(forms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The forms that contain the data points that you have posted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasForms} method.
     * </p>
     * 
     * @return The forms that contain the data points that you have posted.
     */
    public final List<TimeSeriesDataPointFormOutput> forms() {
        return forms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasForms() ? forms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTimeSeriesDataPointsResponse)) {
            return false;
        }
        PostTimeSeriesDataPointsResponse other = (PostTimeSeriesDataPointsResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString()) && hasForms() == other.hasForms()
                && Objects.equals(forms(), other.forms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostTimeSeriesDataPointsResponse").add("DomainId", domainId()).add("EntityId", entityId())
                .add("EntityType", entityTypeAsString()).add("Forms", hasForms() ? forms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostTimeSeriesDataPointsResponse, T> g) {
        return obj -> g.apply((PostTimeSeriesDataPointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PostTimeSeriesDataPointsResponse> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain in which you want to post time series data points.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which you want to post time series data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the asset for which you want to post time series data points.
         * </p>
         * 
         * @param entityId
         *        The ID of the asset for which you want to post time series data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The type of the asset for which you want to post data points.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to post data points.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the asset for which you want to post data points.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to post data points.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(TimeSeriesEntityType entityType);

        /**
         * <p>
         * The forms that contain the data points that you have posted.
         * </p>
         * 
         * @param forms
         *        The forms that contain the data points that you have posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(Collection<TimeSeriesDataPointFormOutput> forms);

        /**
         * <p>
         * The forms that contain the data points that you have posted.
         * </p>
         * 
         * @param forms
         *        The forms that contain the data points that you have posted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(TimeSeriesDataPointFormOutput... forms);

        /**
         * <p>
         * The forms that contain the data points that you have posted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutput.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutput.Builder#build()} is
         * called immediately and its result is passed to {@link #forms(List<TimeSeriesDataPointFormOutput>)}.
         * 
         * @param forms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forms(java.util.Collection<TimeSeriesDataPointFormOutput>)
         */
        Builder forms(Consumer<TimeSeriesDataPointFormOutput.Builder>... forms);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String domainId;

        private String entityId;

        private String entityType;

        private List<TimeSeriesDataPointFormOutput> forms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PostTimeSeriesDataPointsResponse model) {
            super(model);
            domainId(model.domainId);
            entityId(model.entityId);
            entityType(model.entityType);
            forms(model.forms);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final List<TimeSeriesDataPointFormOutput.Builder> getForms() {
            List<TimeSeriesDataPointFormOutput.Builder> result = TimeSeriesDataPointFormOutputListCopier
                    .copyToBuilder(this.forms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForms(Collection<TimeSeriesDataPointFormOutput.BuilderImpl> forms) {
            this.forms = TimeSeriesDataPointFormOutputListCopier.copyFromBuilder(forms);
        }

        @Override
        public final Builder forms(Collection<TimeSeriesDataPointFormOutput> forms) {
            this.forms = TimeSeriesDataPointFormOutputListCopier.copy(forms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(TimeSeriesDataPointFormOutput... forms) {
            forms(Arrays.asList(forms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(Consumer<TimeSeriesDataPointFormOutput.Builder>... forms) {
            forms(Stream.of(forms).map(c -> TimeSeriesDataPointFormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PostTimeSeriesDataPointsResponse build() {
            return new PostTimeSeriesDataPointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
