/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssetFilterRequest extends DataZoneRequest implements
        ToCopyableBuilder<UpdateAssetFilterRequest.Builder, UpdateAssetFilterRequest> {
    private static final SdkField<String> ASSET_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetIdentifier").getter(getter(UpdateAssetFilterRequest::assetIdentifier))
            .setter(setter(Builder::assetIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetIdentifier").build()).build();

    private static final SdkField<AssetFilterConfiguration> CONFIGURATION_FIELD = SdkField
            .<AssetFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(UpdateAssetFilterRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(AssetFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAssetFilterRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(UpdateAssetFilterRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identifier").getter(getter(UpdateAssetFilterRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAssetFilterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDENTIFIER_FIELD,
            CONFIGURATION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, NAME_FIELD));

    private final String assetIdentifier;

    private final AssetFilterConfiguration configuration;

    private final String description;

    private final String domainIdentifier;

    private final String identifier;

    private final String name;

    private UpdateAssetFilterRequest(BuilderImpl builder) {
        super(builder);
        this.assetIdentifier = builder.assetIdentifier;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the data asset.
     * </p>
     * 
     * @return The ID of the data asset.
     */
    public final String assetIdentifier() {
        return assetIdentifier;
    }

    /**
     * <p>
     * The configuration of the asset filter.
     * </p>
     * 
     * @return The configuration of the asset filter.
     */
    public final AssetFilterConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The description of the asset filter.
     * </p>
     * 
     * @return The description of the asset filter.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where you want to update an asset filter.
     * </p>
     * 
     * @return The ID of the domain where you want to update an asset filter.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the asset filter.
     * </p>
     * 
     * @return The ID of the asset filter.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The name of the asset filter.
     * </p>
     * 
     * @return The name of the asset filter.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetFilterRequest)) {
            return false;
        }
        UpdateAssetFilterRequest other = (UpdateAssetFilterRequest) obj;
        return Objects.equals(assetIdentifier(), other.assetIdentifier())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssetFilterRequest").add("AssetIdentifier", assetIdentifier())
                .add("Configuration", configuration())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("Identifier", identifier()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetIdentifier":
            return Optional.ofNullable(clazz.cast(assetIdentifier()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetFilterRequest, T> g) {
        return obj -> g.apply((UpdateAssetFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssetFilterRequest> {
        /**
         * <p>
         * The ID of the data asset.
         * </p>
         * 
         * @param assetIdentifier
         *        The ID of the data asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetIdentifier(String assetIdentifier);

        /**
         * <p>
         * The configuration of the asset filter.
         * </p>
         * 
         * @param configuration
         *        The configuration of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AssetFilterConfiguration configuration);

        /**
         * <p>
         * The configuration of the asset filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link AssetFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(AssetFilterConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AssetFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AssetFilterConfiguration)
         */
        default Builder configuration(Consumer<AssetFilterConfiguration.Builder> configuration) {
            return configuration(AssetFilterConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The description of the asset filter.
         * </p>
         * 
         * @param description
         *        The description of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where you want to update an asset filter.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where you want to update an asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the asset filter.
         * </p>
         * 
         * @param identifier
         *        The ID of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The name of the asset filter.
         * </p>
         * 
         * @param name
         *        The name of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String assetIdentifier;

        private AssetFilterConfiguration configuration;

        private String description;

        private String domainIdentifier;

        private String identifier;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetFilterRequest model) {
            super(model);
            assetIdentifier(model.assetIdentifier);
            configuration(model.configuration);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            identifier(model.identifier);
            name(model.name);
        }

        public final String getAssetIdentifier() {
            return assetIdentifier;
        }

        public final void setAssetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
        }

        @Override
        public final Builder assetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public final AssetFilterConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AssetFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AssetFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetFilterRequest build() {
            return new UpdateAssetFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
