/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The domain unit filter of the project grant filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainUnitFilterForProject implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainUnitFilterForProject.Builder, DomainUnitFilterForProject> {
    private static final SdkField<String> DOMAIN_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnit").getter(getter(DomainUnitFilterForProject::domainUnit)).setter(setter(Builder::domainUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnit").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILD_DOMAIN_UNITS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildDomainUnits").getter(getter(DomainUnitFilterForProject::includeChildDomainUnits))
            .setter(setter(Builder::includeChildDomainUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildDomainUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_FIELD,
            INCLUDE_CHILD_DOMAIN_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainUnit;

    private final Boolean includeChildDomainUnits;

    private DomainUnitFilterForProject(BuilderImpl builder) {
        this.domainUnit = builder.domainUnit;
        this.includeChildDomainUnits = builder.includeChildDomainUnits;
    }

    /**
     * <p>
     * The domain unit ID to use in the filter.
     * </p>
     * 
     * @return The domain unit ID to use in the filter.
     */
    public final String domainUnit() {
        return domainUnit;
    }

    /**
     * <p>
     * Specifies whether to include child domain units.
     * </p>
     * 
     * @return Specifies whether to include child domain units.
     */
    public final Boolean includeChildDomainUnits() {
        return includeChildDomainUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainUnit());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildDomainUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainUnitFilterForProject)) {
            return false;
        }
        DomainUnitFilterForProject other = (DomainUnitFilterForProject) obj;
        return Objects.equals(domainUnit(), other.domainUnit())
                && Objects.equals(includeChildDomainUnits(), other.includeChildDomainUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainUnitFilterForProject").add("DomainUnit", domainUnit())
                .add("IncludeChildDomainUnits", includeChildDomainUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainUnit":
            return Optional.ofNullable(clazz.cast(domainUnit()));
        case "includeChildDomainUnits":
            return Optional.ofNullable(clazz.cast(includeChildDomainUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainUnitFilterForProject, T> g) {
        return obj -> g.apply((DomainUnitFilterForProject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainUnitFilterForProject> {
        /**
         * <p>
         * The domain unit ID to use in the filter.
         * </p>
         * 
         * @param domainUnit
         *        The domain unit ID to use in the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnit(String domainUnit);

        /**
         * <p>
         * Specifies whether to include child domain units.
         * </p>
         * 
         * @param includeChildDomainUnits
         *        Specifies whether to include child domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildDomainUnits(Boolean includeChildDomainUnits);
    }

    static final class BuilderImpl implements Builder {
        private String domainUnit;

        private Boolean includeChildDomainUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainUnitFilterForProject model) {
            domainUnit(model.domainUnit);
            includeChildDomainUnits(model.includeChildDomainUnits);
        }

        public final String getDomainUnit() {
            return domainUnit;
        }

        public final void setDomainUnit(String domainUnit) {
            this.domainUnit = domainUnit;
        }

        @Override
        public final Builder domainUnit(String domainUnit) {
            this.domainUnit = domainUnit;
            return this;
        }

        public final Boolean getIncludeChildDomainUnits() {
            return includeChildDomainUnits;
        }

        public final void setIncludeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
        }

        @Override
        public final Builder includeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
            return this;
        }

        @Override
        public DomainUnitFilterForProject build() {
            return new DomainUnitFilterForProject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
