/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The row filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowFilter implements SdkPojo, Serializable, ToCopyableBuilder<RowFilter.Builder, RowFilter> {
    private static final SdkField<List<RowFilter>> AND_FIELD = SdkField
            .<List<RowFilter>> builder(MarshallingType.LIST)
            .memberName("and")
            .getter(getter(RowFilter::and))
            .setter(setter(Builder::and))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RowFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RowFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RowFilterExpression> EXPRESSION_FIELD = SdkField
            .<RowFilterExpression> builder(MarshallingType.SDK_POJO).memberName("expression")
            .getter(getter(RowFilter::expression)).setter(setter(Builder::expression)).constructor(RowFilterExpression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<List<RowFilter>> OR_FIELD = SdkField
            .<List<RowFilter>> builder(MarshallingType.LIST)
            .memberName("or")
            .getter(getter(RowFilter::or))
            .setter(setter(Builder::or))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RowFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(RowFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, EXPRESSION_FIELD,
            OR_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RowFilter> and;

    private final RowFilterExpression expression;

    private final List<RowFilter> or;

    private final Type type;

    private RowFilter(BuilderImpl builder) {
        this.and = builder.and;
        this.expression = builder.expression;
        this.or = builder.or;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the And property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAnd() {
        return and != null && !(and instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The 'and' clause of the row filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnd} method.
     * </p>
     * 
     * @return The 'and' clause of the row filter.
     */
    public final List<RowFilter> and() {
        return and;
    }

    /**
     * <p>
     * The expression of the row filter.
     * </p>
     * 
     * @return The expression of the row filter.
     */
    public final RowFilterExpression expression() {
        return expression;
    }

    /**
     * For responses, this returns true if the service returned a value for the Or property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOr() {
        return or != null && !(or instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The 'or' clause of the row filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOr} method.
     * </p>
     * 
     * @return The 'or' clause of the row filter.
     */
    public final List<RowFilter> or() {
        return or;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAnd() ? and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(hasOr() ? or() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowFilter)) {
            return false;
        }
        RowFilter other = (RowFilter) obj;
        return hasAnd() == other.hasAnd() && Objects.equals(and(), other.and())
                && Objects.equals(expression(), other.expression()) && hasOr() == other.hasOr()
                && Objects.equals(or(), other.or());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowFilter").add("And", hasAnd() ? and() : null).add("Expression", expression())
                .add("Or", hasOr() ? or() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "and":
            return Optional.ofNullable(clazz.cast(and()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "or":
            return Optional.ofNullable(clazz.cast(or()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #and()} initialized to the given value.
     *
     * <p>
     * The 'and' clause of the row filter.
     * </p>
     * 
     * @param and
     *        The 'and' clause of the row filter.
     */
    public static RowFilter fromAnd(List<RowFilter> and) {
        return builder().and(and).build();
    }

    /**
     * Create an instance of this class with {@link #expression()} initialized to the given value.
     *
     * <p>
     * The expression of the row filter.
     * </p>
     * 
     * @param expression
     *        The expression of the row filter.
     */
    public static RowFilter fromExpression(RowFilterExpression expression) {
        return builder().expression(expression).build();
    }

    /**
     * Create an instance of this class with {@link #expression()} initialized to the given value.
     *
     * <p>
     * The expression of the row filter.
     * </p>
     * 
     * @param expression
     *        The expression of the row filter.
     */
    public static RowFilter fromExpression(Consumer<RowFilterExpression.Builder> expression) {
        RowFilterExpression.Builder builder = RowFilterExpression.builder();
        expression.accept(builder);
        return fromExpression(builder.build());
    }

    /**
     * Create an instance of this class with {@link #or()} initialized to the given value.
     *
     * <p>
     * The 'or' clause of the row filter.
     * </p>
     * 
     * @param or
     *        The 'or' clause of the row filter.
     */
    public static RowFilter fromOr(List<RowFilter> or) {
        return builder().or(or).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowFilter, T> g) {
        return obj -> g.apply((RowFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowFilter> {
        /**
         * <p>
         * The 'and' clause of the row filter.
         * </p>
         * 
         * @param and
         *        The 'and' clause of the row filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(Collection<RowFilter> and);

        /**
         * <p>
         * The 'and' clause of the row filter.
         * </p>
         * 
         * @param and
         *        The 'and' clause of the row filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder and(RowFilter... and);

        /**
         * <p>
         * The 'and' clause of the row filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.RowFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.RowFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.RowFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #and(List<RowFilter>)}.
         * 
         * @param and
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.RowFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #and(java.util.Collection<RowFilter>)
         */
        Builder and(Consumer<Builder>... and);

        /**
         * <p>
         * The expression of the row filter.
         * </p>
         * 
         * @param expression
         *        The expression of the row filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(RowFilterExpression expression);

        /**
         * <p>
         * The expression of the row filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowFilterExpression.Builder} avoiding the
         * need to create one manually via {@link RowFilterExpression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowFilterExpression.Builder#build()} is called immediately and
         * its result is passed to {@link #expression(RowFilterExpression)}.
         * 
         * @param expression
         *        a consumer that will call methods on {@link RowFilterExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #expression(RowFilterExpression)
         */
        default Builder expression(Consumer<RowFilterExpression.Builder> expression) {
            return expression(RowFilterExpression.builder().applyMutation(expression).build());
        }

        /**
         * <p>
         * The 'or' clause of the row filter.
         * </p>
         * 
         * @param or
         *        The 'or' clause of the row filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(Collection<RowFilter> or);

        /**
         * <p>
         * The 'or' clause of the row filter.
         * </p>
         * 
         * @param or
         *        The 'or' clause of the row filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder or(RowFilter... or);

        /**
         * <p>
         * The 'or' clause of the row filter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.RowFilter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.RowFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.RowFilter.Builder#build()} is called immediately and
         * its result is passed to {@link #or(List<RowFilter>)}.
         * 
         * @param or
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.RowFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #or(java.util.Collection<RowFilter>)
         */
        Builder or(Consumer<Builder>... or);
    }

    static final class BuilderImpl implements Builder {
        private List<RowFilter> and = DefaultSdkAutoConstructList.getInstance();

        private RowFilterExpression expression;

        private List<RowFilter> or = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RowFilter model) {
            and(model.and);
            expression(model.expression);
            or(model.or);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = RowFilterListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            Object oldValue = this.and;
            this.and = RowFilterListCopier.copyFromBuilder(and);
            handleUnionValueChange(Type.AND, oldValue, this.and);
        }

        @Override
        public final Builder and(Collection<RowFilter> and) {
            Object oldValue = this.and;
            this.and = RowFilterListCopier.copy(and);
            handleUnionValueChange(Type.AND, oldValue, this.and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(RowFilter... and) {
            and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder>... and) {
            and(Stream.of(and).map(c -> RowFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final RowFilterExpression.Builder getExpression() {
            return expression != null ? expression.toBuilder() : null;
        }

        public final void setExpression(RowFilterExpression.BuilderImpl expression) {
            Object oldValue = this.expression;
            this.expression = expression != null ? expression.build() : null;
            handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
        }

        @Override
        public final Builder expression(RowFilterExpression expression) {
            Object oldValue = this.expression;
            this.expression = expression;
            handleUnionValueChange(Type.EXPRESSION, oldValue, this.expression);
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = RowFilterListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            Object oldValue = this.or;
            this.or = RowFilterListCopier.copyFromBuilder(or);
            handleUnionValueChange(Type.OR, oldValue, this.or);
        }

        @Override
        public final Builder or(Collection<RowFilter> or) {
            Object oldValue = this.or;
            this.or = RowFilterListCopier.copy(or);
            handleUnionValueChange(Type.OR, oldValue, this.or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(RowFilter... or) {
            or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder>... or) {
            or(Stream.of(or).map(c -> RowFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RowFilter build() {
            return new RowFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RowFilter#type()
     */
    public enum Type {
        AND,

        EXPRESSION,

        OR,

        UNKNOWN_TO_SDK_VERSION
    }
}
