/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainResponse extends DataZoneResponse implements
        ToCopyableBuilder<UpdateDomainResponse.Builder, UpdateDomainResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDomainResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainExecutionRole").getter(getter(UpdateDomainResponse::domainExecutionRole))
            .setter(setter(Builder::domainExecutionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainExecutionRole").build())
            .build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateDomainResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt").getter(getter(UpdateDomainResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDomainResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROOT_DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootDomainUnitId").getter(getter(UpdateDomainResponse::rootDomainUnitId))
            .setter(setter(Builder::rootDomainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDomainUnitId").build()).build();

    private static final SdkField<SingleSignOn> SINGLE_SIGN_ON_FIELD = SdkField.<SingleSignOn> builder(MarshallingType.SDK_POJO)
            .memberName("singleSignOn").getter(getter(UpdateDomainResponse::singleSignOn)).setter(setter(Builder::singleSignOn))
            .constructor(SingleSignOn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleSignOn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            DOMAIN_EXECUTION_ROLE_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, ROOT_DOMAIN_UNIT_ID_FIELD,
            SINGLE_SIGN_ON_FIELD));

    private final String description;

    private final String domainExecutionRole;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String rootDomainUnitId;

    private final SingleSignOn singleSignOn;

    private UpdateDomainResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainExecutionRole = builder.domainExecutionRole;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.rootDomainUnitId = builder.rootDomainUnitId;
        this.singleSignOn = builder.singleSignOn;
    }

    /**
     * <p>
     * The description to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The description to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final String domainExecutionRole() {
        return domainExecutionRole;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies the timestamp of when the domain was last updated.
     * </p>
     * 
     * @return Specifies the timestamp of when the domain was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name to be updated as part of the <code>UpdateDomain</code> action.
     * </p>
     * 
     * @return The name to be updated as part of the <code>UpdateDomain</code> action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the root domain unit.
     * </p>
     * 
     * @return The ID of the root domain unit.
     */
    public final String rootDomainUnitId() {
        return rootDomainUnitId;
    }

    /**
     * <p>
     * The single sign-on option of the Amazon DataZone domain.
     * </p>
     * 
     * @return The single sign-on option of the Amazon DataZone domain.
     */
    public final SingleSignOn singleSignOn() {
        return singleSignOn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rootDomainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainResponse)) {
            return false;
        }
        UpdateDomainResponse other = (UpdateDomainResponse) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(domainExecutionRole(), other.domainExecutionRole()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(rootDomainUnitId(), other.rootDomainUnitId())
                && Objects.equals(singleSignOn(), other.singleSignOn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainResponse").add("Description", description())
                .add("DomainExecutionRole", domainExecutionRole()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Name", name()).add("RootDomainUnitId", rootDomainUnitId()).add("SingleSignOn", singleSignOn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainExecutionRole":
            return Optional.ofNullable(clazz.cast(domainExecutionRole()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "rootDomainUnitId":
            return Optional.ofNullable(clazz.cast(rootDomainUnitId()));
        case "singleSignOn":
            return Optional.ofNullable(clazz.cast(singleSignOn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainResponse, T> g) {
        return obj -> g.apply((UpdateDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainResponse> {
        /**
         * <p>
         * The description to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param description
         *        The description to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param domainExecutionRole
         *        The domain execution role to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainExecutionRole(String domainExecutionRole);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param id
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies the timestamp of when the domain was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Specifies the timestamp of when the domain was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name to be updated as part of the <code>UpdateDomain</code> action.
         * </p>
         * 
         * @param name
         *        The name to be updated as part of the <code>UpdateDomain</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the root domain unit.
         * </p>
         * 
         * @param rootDomainUnitId
         *        The ID of the root domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDomainUnitId(String rootDomainUnitId);

        /**
         * <p>
         * The single sign-on option of the Amazon DataZone domain.
         * </p>
         * 
         * @param singleSignOn
         *        The single sign-on option of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOn(SingleSignOn singleSignOn);

        /**
         * <p>
         * The single sign-on option of the Amazon DataZone domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleSignOn.Builder} avoiding the need
         * to create one manually via {@link SingleSignOn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleSignOn.Builder#build()} is called immediately and its
         * result is passed to {@link #singleSignOn(SingleSignOn)}.
         * 
         * @param singleSignOn
         *        a consumer that will call methods on {@link SingleSignOn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleSignOn(SingleSignOn)
         */
        default Builder singleSignOn(Consumer<SingleSignOn.Builder> singleSignOn) {
            return singleSignOn(SingleSignOn.builder().applyMutation(singleSignOn).build());
        }
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String description;

        private String domainExecutionRole;

        private String id;

        private Instant lastUpdatedAt;

        private String name;

        private String rootDomainUnitId;

        private SingleSignOn singleSignOn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainResponse model) {
            super(model);
            description(model.description);
            domainExecutionRole(model.domainExecutionRole);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            rootDomainUnitId(model.rootDomainUnitId);
            singleSignOn(model.singleSignOn);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainExecutionRole() {
            return domainExecutionRole;
        }

        public final void setDomainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
        }

        @Override
        public final Builder domainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRootDomainUnitId() {
            return rootDomainUnitId;
        }

        public final void setRootDomainUnitId(String rootDomainUnitId) {
            this.rootDomainUnitId = rootDomainUnitId;
        }

        @Override
        public final Builder rootDomainUnitId(String rootDomainUnitId) {
            this.rootDomainUnitId = rootDomainUnitId;
            return this;
        }

        public final SingleSignOn.Builder getSingleSignOn() {
            return singleSignOn != null ? singleSignOn.toBuilder() : null;
        }

        public final void setSingleSignOn(SingleSignOn.BuilderImpl singleSignOn) {
            this.singleSignOn = singleSignOn != null ? singleSignOn.build() : null;
        }

        @Override
        public final Builder singleSignOn(SingleSignOn singleSignOn) {
            this.singleSignOn = singleSignOn;
            return this;
        }

        @Override
        public UpdateDomainResponse build() {
            return new UpdateDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
