/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.TermRelationsClassifiesListCopier;
import software.amazon.awssdk.services.datazone.model.TermRelationsIsAListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TermRelations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TermRelations> {
    private static final SdkField<List<String>> CLASSIFIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("classifies").getter(TermRelations.getter(TermRelations::classifies)).setter(TermRelations.setter(Builder::classifies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classifies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ISA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("isA").getter(TermRelations.getter(TermRelations::isA)).setter(TermRelations.setter(Builder::isA)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isA").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLASSIFIES_FIELD, ISA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("classifies", CLASSIFIES_FIELD);
            this.put("isA", ISA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> classifies;
    private final List<String> isA;

    private TermRelations(BuilderImpl builder) {
        this.classifies = builder.classifies;
        this.isA = builder.isA;
    }

    public final boolean hasClassifies() {
        return this.classifies != null && !(this.classifies instanceof SdkAutoConstructList);
    }

    public final List<String> classifies() {
        return this.classifies;
    }

    public final boolean hasIsA() {
        return this.isA != null && !(this.isA instanceof SdkAutoConstructList);
    }

    public final List<String> isA() {
        return this.isA;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClassifies() ? this.classifies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIsA() ? this.isA() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TermRelations)) {
            return false;
        }
        TermRelations other = (TermRelations)obj;
        return this.hasClassifies() == other.hasClassifies() && Objects.equals(this.classifies(), other.classifies()) && this.hasIsA() == other.hasIsA() && Objects.equals(this.isA(), other.isA());
    }

    public final String toString() {
        return ToString.builder((String)"TermRelations").add("Classifies", this.hasClassifies() ? this.classifies() : null).add("IsA", this.hasIsA() ? this.isA() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "classifies": {
                return Optional.ofNullable(clazz.cast(this.classifies()));
            }
            case "isA": {
                return Optional.ofNullable(clazz.cast(this.isA()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TermRelations, T> g) {
        return obj -> g.apply((TermRelations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> classifies = DefaultSdkAutoConstructList.getInstance();
        private List<String> isA = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TermRelations model) {
            this.classifies(model.classifies);
            this.isA(model.isA);
        }

        public final Collection<String> getClassifies() {
            if (this.classifies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.classifies;
        }

        public final void setClassifies(Collection<String> classifies) {
            this.classifies = TermRelationsClassifiesListCopier.copy(classifies);
        }

        @Override
        public final Builder classifies(Collection<String> classifies) {
            this.classifies = TermRelationsClassifiesListCopier.copy(classifies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classifies(String ... classifies) {
            this.classifies(Arrays.asList(classifies));
            return this;
        }

        public final Collection<String> getIsA() {
            if (this.isA instanceof SdkAutoConstructList) {
                return null;
            }
            return this.isA;
        }

        public final void setIsA(Collection<String> isA) {
            this.isA = TermRelationsIsAListCopier.copy(isA);
        }

        @Override
        public final Builder isA(Collection<String> isA) {
            this.isA = TermRelationsIsAListCopier.copy(isA);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder isA(String ... isA) {
            this.isA(Arrays.asList(isA));
            return this;
        }

        public TermRelations build() {
            return new TermRelations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TermRelations> {
        public Builder classifies(Collection<String> var1);

        public Builder classifies(String ... var1);

        public Builder isA(Collection<String> var1);

        public Builder isA(String ... var1);
    }
}

