/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the asset filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetFilterConfiguration.Builder, AssetFilterConfiguration> {
    private static final SdkField<ColumnFilterConfiguration> COLUMN_CONFIGURATION_FIELD = SdkField
            .<ColumnFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("columnConfiguration")
            .getter(getter(AssetFilterConfiguration::columnConfiguration)).setter(setter(Builder::columnConfiguration))
            .constructor(ColumnFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnConfiguration").build())
            .build();

    private static final SdkField<RowFilterConfiguration> ROW_CONFIGURATION_FIELD = SdkField
            .<RowFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("rowConfiguration")
            .getter(getter(AssetFilterConfiguration::rowConfiguration)).setter(setter(Builder::rowConfiguration))
            .constructor(RowFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rowConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_CONFIGURATION_FIELD,
            ROW_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("columnConfiguration", COLUMN_CONFIGURATION_FIELD);
                    put("rowConfiguration", ROW_CONFIGURATION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final ColumnFilterConfiguration columnConfiguration;

    private final RowFilterConfiguration rowConfiguration;

    private final Type type;

    private AssetFilterConfiguration(BuilderImpl builder) {
        this.columnConfiguration = builder.columnConfiguration;
        this.rowConfiguration = builder.rowConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * The column configuration of the asset filter.
     * </p>
     * 
     * @return The column configuration of the asset filter.
     */
    public final ColumnFilterConfiguration columnConfiguration() {
        return columnConfiguration;
    }

    /**
     * <p>
     * The row configuration of the asset filter.
     * </p>
     * 
     * @return The row configuration of the asset filter.
     */
    public final RowFilterConfiguration rowConfiguration() {
        return rowConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(rowConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetFilterConfiguration)) {
            return false;
        }
        AssetFilterConfiguration other = (AssetFilterConfiguration) obj;
        return Objects.equals(columnConfiguration(), other.columnConfiguration())
                && Objects.equals(rowConfiguration(), other.rowConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetFilterConfiguration").add("ColumnConfiguration", columnConfiguration())
                .add("RowConfiguration", rowConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnConfiguration":
            return Optional.ofNullable(clazz.cast(columnConfiguration()));
        case "rowConfiguration":
            return Optional.ofNullable(clazz.cast(rowConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #columnConfiguration()} initialized to the given value.
     *
     * <p>
     * The column configuration of the asset filter.
     * </p>
     * 
     * @param columnConfiguration
     *        The column configuration of the asset filter.
     */
    public static AssetFilterConfiguration fromColumnConfiguration(ColumnFilterConfiguration columnConfiguration) {
        return builder().columnConfiguration(columnConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #columnConfiguration()} initialized to the given value.
     *
     * <p>
     * The column configuration of the asset filter.
     * </p>
     * 
     * @param columnConfiguration
     *        The column configuration of the asset filter.
     */
    public static AssetFilterConfiguration fromColumnConfiguration(Consumer<ColumnFilterConfiguration.Builder> columnConfiguration) {
        ColumnFilterConfiguration.Builder builder = ColumnFilterConfiguration.builder();
        columnConfiguration.accept(builder);
        return fromColumnConfiguration(builder.build());
    }

    /**
     * Create an instance of this class with {@link #rowConfiguration()} initialized to the given value.
     *
     * <p>
     * The row configuration of the asset filter.
     * </p>
     * 
     * @param rowConfiguration
     *        The row configuration of the asset filter.
     */
    public static AssetFilterConfiguration fromRowConfiguration(RowFilterConfiguration rowConfiguration) {
        return builder().rowConfiguration(rowConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #rowConfiguration()} initialized to the given value.
     *
     * <p>
     * The row configuration of the asset filter.
     * </p>
     * 
     * @param rowConfiguration
     *        The row configuration of the asset filter.
     */
    public static AssetFilterConfiguration fromRowConfiguration(Consumer<RowFilterConfiguration.Builder> rowConfiguration) {
        RowFilterConfiguration.Builder builder = RowFilterConfiguration.builder();
        rowConfiguration.accept(builder);
        return fromRowConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetFilterConfiguration, T> g) {
        return obj -> g.apply((AssetFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetFilterConfiguration> {
        /**
         * <p>
         * The column configuration of the asset filter.
         * </p>
         * 
         * @param columnConfiguration
         *        The column configuration of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnConfiguration(ColumnFilterConfiguration columnConfiguration);

        /**
         * <p>
         * The column configuration of the asset filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link ColumnFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #columnConfiguration(ColumnFilterConfiguration)}.
         * 
         * @param columnConfiguration
         *        a consumer that will call methods on {@link ColumnFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnConfiguration(ColumnFilterConfiguration)
         */
        default Builder columnConfiguration(Consumer<ColumnFilterConfiguration.Builder> columnConfiguration) {
            return columnConfiguration(ColumnFilterConfiguration.builder().applyMutation(columnConfiguration).build());
        }

        /**
         * <p>
         * The row configuration of the asset filter.
         * </p>
         * 
         * @param rowConfiguration
         *        The row configuration of the asset filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowConfiguration(RowFilterConfiguration rowConfiguration);

        /**
         * <p>
         * The row configuration of the asset filter.
         * </p>
         * This is a convenience method that creates an instance of the {@link RowFilterConfiguration.Builder} avoiding
         * the need to create one manually via {@link RowFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowFilterConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #rowConfiguration(RowFilterConfiguration)}.
         * 
         * @param rowConfiguration
         *        a consumer that will call methods on {@link RowFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowConfiguration(RowFilterConfiguration)
         */
        default Builder rowConfiguration(Consumer<RowFilterConfiguration.Builder> rowConfiguration) {
            return rowConfiguration(RowFilterConfiguration.builder().applyMutation(rowConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnFilterConfiguration columnConfiguration;

        private RowFilterConfiguration rowConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssetFilterConfiguration model) {
            columnConfiguration(model.columnConfiguration);
            rowConfiguration(model.rowConfiguration);
        }

        public final ColumnFilterConfiguration.Builder getColumnConfiguration() {
            return columnConfiguration != null ? columnConfiguration.toBuilder() : null;
        }

        public final void setColumnConfiguration(ColumnFilterConfiguration.BuilderImpl columnConfiguration) {
            Object oldValue = this.columnConfiguration;
            this.columnConfiguration = columnConfiguration != null ? columnConfiguration.build() : null;
            handleUnionValueChange(Type.COLUMN_CONFIGURATION, oldValue, this.columnConfiguration);
        }

        @Override
        public final Builder columnConfiguration(ColumnFilterConfiguration columnConfiguration) {
            Object oldValue = this.columnConfiguration;
            this.columnConfiguration = columnConfiguration;
            handleUnionValueChange(Type.COLUMN_CONFIGURATION, oldValue, this.columnConfiguration);
            return this;
        }

        public final RowFilterConfiguration.Builder getRowConfiguration() {
            return rowConfiguration != null ? rowConfiguration.toBuilder() : null;
        }

        public final void setRowConfiguration(RowFilterConfiguration.BuilderImpl rowConfiguration) {
            Object oldValue = this.rowConfiguration;
            this.rowConfiguration = rowConfiguration != null ? rowConfiguration.build() : null;
            handleUnionValueChange(Type.ROW_CONFIGURATION, oldValue, this.rowConfiguration);
        }

        @Override
        public final Builder rowConfiguration(RowFilterConfiguration rowConfiguration) {
            Object oldValue = this.rowConfiguration;
            this.rowConfiguration = rowConfiguration;
            handleUnionValueChange(Type.ROW_CONFIGURATION, oldValue, this.rowConfiguration);
            return this;
        }

        @Override
        public AssetFilterConfiguration build() {
            return new AssetFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AssetFilterConfiguration#type()
     */
    public enum Type {
        COLUMN_CONFIGURATION,

        ROW_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
