/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The listing of the asset in a data product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetInDataProductListingItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetInDataProductListingItem.Builder, AssetInDataProductListingItem> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(AssetInDataProductListingItem::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(AssetInDataProductListingItem::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(AssetInDataProductListingItem::entityType))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("entityId", ENTITY_ID_FIELD);
                    put("entityRevision", ENTITY_REVISION_FIELD);
                    put("entityType", ENTITY_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String entityId;

    private final String entityRevision;

    private final String entityType;

    private AssetInDataProductListingItem(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
    }

    /**
     * <p>
     * The entity ID of the listing of the asset in a data product.
     * </p>
     * 
     * @return The entity ID of the listing of the asset in a data product.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The entity revision of the listing of the asset in a data product.
     * </p>
     * 
     * @return The entity revision of the listing of the asset in a data product.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * <p>
     * The entity type of the listing of the asset in a data product.
     * </p>
     * 
     * @return The entity type of the listing of the asset in a data product.
     */
    public final String entityType() {
        return entityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetInDataProductListingItem)) {
            return false;
        }
        AssetInDataProductListingItem other = (AssetInDataProductListingItem) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(entityRevision(), other.entityRevision())
                && Objects.equals(entityType(), other.entityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetInDataProductListingItem").add("EntityId", entityId())
                .add("EntityRevision", entityRevision()).add("EntityType", entityType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetInDataProductListingItem, T> g) {
        return obj -> g.apply((AssetInDataProductListingItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetInDataProductListingItem> {
        /**
         * <p>
         * The entity ID of the listing of the asset in a data product.
         * </p>
         * 
         * @param entityId
         *        The entity ID of the listing of the asset in a data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The entity revision of the listing of the asset in a data product.
         * </p>
         * 
         * @param entityRevision
         *        The entity revision of the listing of the asset in a data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The entity type of the listing of the asset in a data product.
         * </p>
         * 
         * @param entityType
         *        The entity type of the listing of the asset in a data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);
    }

    static final class BuilderImpl implements Builder {
        private String entityId;

        private String entityRevision;

        private String entityType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetInDataProductListingItem model) {
            entityId(model.entityId);
            entityRevision(model.entityRevision);
            entityType(model.entityType);
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public AssetInDataProductListingItem build() {
            return new AssetInDataProductListingItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
