/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an asset published in an Amazon DataZone catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetListingItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetListingItem.Builder, AssetListingItem> {
    private static final SdkField<AssetListingItemAdditionalAttributes> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<AssetListingItemAdditionalAttributes> builder(MarshallingType.SDK_POJO).memberName("additionalAttributes")
            .getter(getter(AssetListingItem::additionalAttributes)).setter(setter(Builder::additionalAttributes))
            .constructor(AssetListingItemAdditionalAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(AssetListingItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssetListingItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(AssetListingItem::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityRevision").getter(getter(AssetListingItem::entityRevision))
            .setter(setter(Builder::entityRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(AssetListingItem::entityType)).setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<DetailedGlossaryTerm>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(AssetListingItem::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DetailedGlossaryTerm> builder(MarshallingType.SDK_POJO)
                                            .constructor(DetailedGlossaryTerm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LISTING_CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingCreatedBy").getter(getter(AssetListingItem::listingCreatedBy))
            .setter(setter(Builder::listingCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingCreatedBy").build()).build();

    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingId").getter(getter(AssetListingItem::listingId)).setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()).build();

    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingRevision").getter(getter(AssetListingItem::listingRevision))
            .setter(setter(Builder::listingRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()).build();

    private static final SdkField<String> LISTING_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingUpdatedBy").getter(getter(AssetListingItem::listingUpdatedBy))
            .setter(setter(Builder::listingUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingUpdatedBy").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AssetListingItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(AssetListingItem::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD,
            CREATED_AT_FIELD, DESCRIPTION_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD, GLOSSARY_TERMS_FIELD,
            LISTING_CREATED_BY_FIELD, LISTING_ID_FIELD, LISTING_REVISION_FIELD, LISTING_UPDATED_BY_FIELD, NAME_FIELD,
            OWNING_PROJECT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("additionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
                    put("createdAt", CREATED_AT_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("entityId", ENTITY_ID_FIELD);
                    put("entityRevision", ENTITY_REVISION_FIELD);
                    put("entityType", ENTITY_TYPE_FIELD);
                    put("glossaryTerms", GLOSSARY_TERMS_FIELD);
                    put("listingCreatedBy", LISTING_CREATED_BY_FIELD);
                    put("listingId", LISTING_ID_FIELD);
                    put("listingRevision", LISTING_REVISION_FIELD);
                    put("listingUpdatedBy", LISTING_UPDATED_BY_FIELD);
                    put("name", NAME_FIELD);
                    put("owningProjectId", OWNING_PROJECT_ID_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AssetListingItemAdditionalAttributes additionalAttributes;

    private final Instant createdAt;

    private final String description;

    private final String entityId;

    private final String entityRevision;

    private final String entityType;

    private final List<DetailedGlossaryTerm> glossaryTerms;

    private final String listingCreatedBy;

    private final String listingId;

    private final String listingRevision;

    private final String listingUpdatedBy;

    private final String name;

    private final String owningProjectId;

    private AssetListingItem(BuilderImpl builder) {
        this.additionalAttributes = builder.additionalAttributes;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
        this.glossaryTerms = builder.glossaryTerms;
        this.listingCreatedBy = builder.listingCreatedBy;
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
        this.listingUpdatedBy = builder.listingUpdatedBy;
        this.name = builder.name;
        this.owningProjectId = builder.owningProjectId;
    }

    /**
     * <p>
     * The additional attributes of an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The additional attributes of an asset published in an Amazon DataZone catalog.
     */
    public final AssetListingItemAdditionalAttributes additionalAttributes() {
        return additionalAttributes;
    }

    /**
     * <p>
     * The timestamp of when an asset published in an Amazon DataZone catalog was created.
     * </p>
     * 
     * @return The timestamp of when an asset published in an Amazon DataZone catalog was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of an asset published in an Amazon DataZone catalog.
     * </p>
     * 
     * @return The description of an asset published in an Amazon DataZone catalog.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the inventory asset.
     * </p>
     * 
     * @return The identifier of the inventory asset.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The revision of the inventory asset.
     * </p>
     * 
     * @return The revision of the inventory asset.
     */
    public final String entityRevision() {
        return entityRevision;
    }

    /**
     * <p>
     * The type of the inventory asset.
     * </p>
     * 
     * @return The type of the inventory asset.
     */
    public final String entityType() {
        return entityType;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Glossary terms attached to the inventory asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return Glossary terms attached to the inventory asset.
     */
    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the listing.
     * </p>
     * 
     * @return The Amazon DataZone user who created the listing.
     */
    public final String listingCreatedBy() {
        return listingCreatedBy;
    }

    /**
     * <p>
     * The identifier of the listing (asset published in Amazon DataZone catalog).
     * </p>
     * 
     * @return The identifier of the listing (asset published in Amazon DataZone catalog).
     */
    public final String listingId() {
        return listingId;
    }

    /**
     * <p>
     * The revision of the listing (asset published in Amazon DataZone catalog).
     * </p>
     * 
     * @return The revision of the listing (asset published in Amazon DataZone catalog).
     */
    public final String listingRevision() {
        return listingRevision;
    }

    /**
     * <p>
     * The Amazon DataZone user who updated the listing.
     * </p>
     * 
     * @return The Amazon DataZone user who updated the listing.
     */
    public final String listingUpdatedBy() {
        return listingUpdatedBy;
    }

    /**
     * <p>
     * The name of the inventory asset.
     * </p>
     * 
     * @return The name of the inventory asset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the project that owns the inventory asset.
     * </p>
     * 
     * @return The identifier of the project that owns the inventory asset.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(additionalAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(entityType());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(listingCreatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        hashCode = 31 * hashCode + Objects.hashCode(listingRevision());
        hashCode = 31 * hashCode + Objects.hashCode(listingUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListingItem)) {
            return false;
        }
        AssetListingItem other = (AssetListingItem) obj;
        return Objects.equals(additionalAttributes(), other.additionalAttributes())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(entityId(), other.entityId()) && Objects.equals(entityRevision(), other.entityRevision())
                && Objects.equals(entityType(), other.entityType()) && hasGlossaryTerms() == other.hasGlossaryTerms()
                && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(listingCreatedBy(), other.listingCreatedBy()) && Objects.equals(listingId(), other.listingId())
                && Objects.equals(listingRevision(), other.listingRevision())
                && Objects.equals(listingUpdatedBy(), other.listingUpdatedBy()) && Objects.equals(name(), other.name())
                && Objects.equals(owningProjectId(), other.owningProjectId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetListingItem").add("AdditionalAttributes", additionalAttributes())
                .add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("EntityId", entityId())
                .add("EntityRevision", entityRevision()).add("EntityType", entityType())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("ListingCreatedBy", listingCreatedBy())
                .add("ListingId", listingId()).add("ListingRevision", listingRevision())
                .add("ListingUpdatedBy", listingUpdatedBy())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("OwningProjectId", owningProjectId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityRevision":
            return Optional.ofNullable(clazz.cast(entityRevision()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityType()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "listingCreatedBy":
            return Optional.ofNullable(clazz.cast(listingCreatedBy()));
        case "listingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        case "listingRevision":
            return Optional.ofNullable(clazz.cast(listingRevision()));
        case "listingUpdatedBy":
            return Optional.ofNullable(clazz.cast(listingUpdatedBy()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetListingItem, T> g) {
        return obj -> g.apply((AssetListingItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetListingItem> {
        /**
         * <p>
         * The additional attributes of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param additionalAttributes
         *        The additional attributes of an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(AssetListingItemAdditionalAttributes additionalAttributes);

        /**
         * <p>
         * The additional attributes of an asset published in an Amazon DataZone catalog.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AssetListingItemAdditionalAttributes.Builder} avoiding the need to create one manually via
         * {@link AssetListingItemAdditionalAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetListingItemAdditionalAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalAttributes(AssetListingItemAdditionalAttributes)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on {@link AssetListingItemAdditionalAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(AssetListingItemAdditionalAttributes)
         */
        default Builder additionalAttributes(Consumer<AssetListingItemAdditionalAttributes.Builder> additionalAttributes) {
            return additionalAttributes(AssetListingItemAdditionalAttributes.builder().applyMutation(additionalAttributes)
                    .build());
        }

        /**
         * <p>
         * The timestamp of when an asset published in an Amazon DataZone catalog was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when an asset published in an Amazon DataZone catalog was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of an asset published in an Amazon DataZone catalog.
         * </p>
         * 
         * @param description
         *        The description of an asset published in an Amazon DataZone catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the inventory asset.
         * </p>
         * 
         * @param entityId
         *        The identifier of the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The revision of the inventory asset.
         * </p>
         * 
         * @param entityRevision
         *        The revision of the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityRevision(String entityRevision);

        /**
         * <p>
         * The type of the inventory asset.
         * </p>
         * 
         * @param entityType
         *        The type of the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * Glossary terms attached to the inventory asset.
         * </p>
         * 
         * @param glossaryTerms
         *        Glossary terms attached to the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms);

        /**
         * <p>
         * Glossary terms attached to the inventory asset.
         * </p>
         * 
         * @param glossaryTerms
         *        Glossary terms attached to the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms);

        /**
         * <p>
         * Glossary terms attached to the inventory asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder#build()} is called
         * immediately and its result is passed to {@link #glossaryTerms(List<DetailedGlossaryTerm>)}.
         * 
         * @param glossaryTerms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glossaryTerms(java.util.Collection<DetailedGlossaryTerm>)
         */
        Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms);

        /**
         * <p>
         * The Amazon DataZone user who created the listing.
         * </p>
         * 
         * @param listingCreatedBy
         *        The Amazon DataZone user who created the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingCreatedBy(String listingCreatedBy);

        /**
         * <p>
         * The identifier of the listing (asset published in Amazon DataZone catalog).
         * </p>
         * 
         * @param listingId
         *        The identifier of the listing (asset published in Amazon DataZone catalog).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);

        /**
         * <p>
         * The revision of the listing (asset published in Amazon DataZone catalog).
         * </p>
         * 
         * @param listingRevision
         *        The revision of the listing (asset published in Amazon DataZone catalog).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingRevision(String listingRevision);

        /**
         * <p>
         * The Amazon DataZone user who updated the listing.
         * </p>
         * 
         * @param listingUpdatedBy
         *        The Amazon DataZone user who updated the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingUpdatedBy(String listingUpdatedBy);

        /**
         * <p>
         * The name of the inventory asset.
         * </p>
         * 
         * @param name
         *        The name of the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the project that owns the inventory asset.
         * </p>
         * 
         * @param owningProjectId
         *        The identifier of the project that owns the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);
    }

    static final class BuilderImpl implements Builder {
        private AssetListingItemAdditionalAttributes additionalAttributes;

        private Instant createdAt;

        private String description;

        private String entityId;

        private String entityRevision;

        private String entityType;

        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String listingCreatedBy;

        private String listingId;

        private String listingRevision;

        private String listingUpdatedBy;

        private String name;

        private String owningProjectId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListingItem model) {
            additionalAttributes(model.additionalAttributes);
            createdAt(model.createdAt);
            description(model.description);
            entityId(model.entityId);
            entityRevision(model.entityRevision);
            entityType(model.entityType);
            glossaryTerms(model.glossaryTerms);
            listingCreatedBy(model.listingCreatedBy);
            listingId(model.listingId);
            listingRevision(model.listingRevision);
            listingUpdatedBy(model.listingUpdatedBy);
            name(model.name);
            owningProjectId(model.owningProjectId);
        }

        public final AssetListingItemAdditionalAttributes.Builder getAdditionalAttributes() {
            return additionalAttributes != null ? additionalAttributes.toBuilder() : null;
        }

        public final void setAdditionalAttributes(AssetListingItemAdditionalAttributes.BuilderImpl additionalAttributes) {
            this.additionalAttributes = additionalAttributes != null ? additionalAttributes.build() : null;
        }

        @Override
        public final Builder additionalAttributes(AssetListingItemAdditionalAttributes additionalAttributes) {
            this.additionalAttributes = additionalAttributes;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder>... glossaryTerms) {
            glossaryTerms(Stream.of(glossaryTerms).map(c -> DetailedGlossaryTerm.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getListingCreatedBy() {
            return listingCreatedBy;
        }

        public final void setListingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
        }

        @Override
        public final Builder listingCreatedBy(String listingCreatedBy) {
            this.listingCreatedBy = listingCreatedBy;
            return this;
        }

        public final String getListingId() {
            return listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        public final String getListingUpdatedBy() {
            return listingUpdatedBy;
        }

        public final void setListingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
        }

        @Override
        public final Builder listingUpdatedBy(String listingUpdatedBy) {
            this.listingUpdatedBy = listingUpdatedBy;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        @Override
        public AssetListingItem build() {
            return new AssetListingItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
