/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional attributes of an inventory asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetListingItemAdditionalAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetListingItemAdditionalAttributes.Builder, AssetListingItemAdditionalAttributes> {
    private static final SdkField<String> FORMS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("forms")
            .getter(getter(AssetListingItemAdditionalAttributes::forms)).setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()).build();

    private static final SdkField<List<TimeSeriesDataPointSummaryFormOutput>> LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD = SdkField
            .<List<TimeSeriesDataPointSummaryFormOutput>> builder(MarshallingType.LIST)
            .memberName("latestTimeSeriesDataPointForms")
            .getter(getter(AssetListingItemAdditionalAttributes::latestTimeSeriesDataPointForms))
            .setter(setter(Builder::latestTimeSeriesDataPointForms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestTimeSeriesDataPointForms")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesDataPointSummaryFormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesDataPointSummaryFormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMS_FIELD,
            LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("forms", FORMS_FIELD);
                    put("latestTimeSeriesDataPointForms", LATEST_TIME_SERIES_DATA_POINT_FORMS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String forms;

    private final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms;

    private AssetListingItemAdditionalAttributes(BuilderImpl builder) {
        this.forms = builder.forms;
        this.latestTimeSeriesDataPointForms = builder.latestTimeSeriesDataPointForms;
    }

    /**
     * <p>
     * The metadata forms that form additional attributes of the metadata asset.
     * </p>
     * 
     * @return The metadata forms that form additional attributes of the metadata asset.
     */
    public final String forms() {
        return forms;
    }

    /**
     * For responses, this returns true if the service returned a value for the LatestTimeSeriesDataPointForms property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLatestTimeSeriesDataPointForms() {
        return latestTimeSeriesDataPointForms != null && !(latestTimeSeriesDataPointForms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The latest time series data points forms included in the additional attributes of an asset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLatestTimeSeriesDataPointForms} method.
     * </p>
     * 
     * @return The latest time series data points forms included in the additional attributes of an asset.
     */
    public final List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms() {
        return latestTimeSeriesDataPointForms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forms());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasLatestTimeSeriesDataPointForms() ? latestTimeSeriesDataPointForms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetListingItemAdditionalAttributes)) {
            return false;
        }
        AssetListingItemAdditionalAttributes other = (AssetListingItemAdditionalAttributes) obj;
        return Objects.equals(forms(), other.forms())
                && hasLatestTimeSeriesDataPointForms() == other.hasLatestTimeSeriesDataPointForms()
                && Objects.equals(latestTimeSeriesDataPointForms(), other.latestTimeSeriesDataPointForms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AssetListingItemAdditionalAttributes")
                .add("Forms", forms())
                .add("LatestTimeSeriesDataPointForms",
                        hasLatestTimeSeriesDataPointForms() ? latestTimeSeriesDataPointForms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        case "latestTimeSeriesDataPointForms":
            return Optional.ofNullable(clazz.cast(latestTimeSeriesDataPointForms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetListingItemAdditionalAttributes, T> g) {
        return obj -> g.apply((AssetListingItemAdditionalAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetListingItemAdditionalAttributes> {
        /**
         * <p>
         * The metadata forms that form additional attributes of the metadata asset.
         * </p>
         * 
         * @param forms
         *        The metadata forms that form additional attributes of the metadata asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(String forms);

        /**
         * <p>
         * The latest time series data points forms included in the additional attributes of an asset.
         * </p>
         * 
         * @param latestTimeSeriesDataPointForms
         *        The latest time series data points forms included in the additional attributes of an asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestTimeSeriesDataPointForms(Collection<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms);

        /**
         * <p>
         * The latest time series data points forms included in the additional attributes of an asset.
         * </p>
         * 
         * @param latestTimeSeriesDataPointForms
         *        The latest time series data points forms included in the additional attributes of an asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestTimeSeriesDataPointForms(TimeSeriesDataPointSummaryFormOutput... latestTimeSeriesDataPointForms);

        /**
         * <p>
         * The latest time series data points forms included in the additional attributes of an asset.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #latestTimeSeriesDataPointForms(List<TimeSeriesDataPointSummaryFormOutput>)}.
         * 
         * @param latestTimeSeriesDataPointForms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointSummaryFormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestTimeSeriesDataPointForms(java.util.Collection<TimeSeriesDataPointSummaryFormOutput>)
         */
        Builder latestTimeSeriesDataPointForms(
                Consumer<TimeSeriesDataPointSummaryFormOutput.Builder>... latestTimeSeriesDataPointForms);
    }

    static final class BuilderImpl implements Builder {
        private String forms;

        private List<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetListingItemAdditionalAttributes model) {
            forms(model.forms);
            latestTimeSeriesDataPointForms(model.latestTimeSeriesDataPointForms);
        }

        public final String getForms() {
            return forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<TimeSeriesDataPointSummaryFormOutput.Builder> getLatestTimeSeriesDataPointForms() {
            List<TimeSeriesDataPointSummaryFormOutput.Builder> result = TimeSeriesDataPointSummaryFormOutputListCopier
                    .copyToBuilder(this.latestTimeSeriesDataPointForms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLatestTimeSeriesDataPointForms(
                Collection<TimeSeriesDataPointSummaryFormOutput.BuilderImpl> latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms = TimeSeriesDataPointSummaryFormOutputListCopier
                    .copyFromBuilder(latestTimeSeriesDataPointForms);
        }

        @Override
        public final Builder latestTimeSeriesDataPointForms(
                Collection<TimeSeriesDataPointSummaryFormOutput> latestTimeSeriesDataPointForms) {
            this.latestTimeSeriesDataPointForms = TimeSeriesDataPointSummaryFormOutputListCopier
                    .copy(latestTimeSeriesDataPointForms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointForms(
                TimeSeriesDataPointSummaryFormOutput... latestTimeSeriesDataPointForms) {
            latestTimeSeriesDataPointForms(Arrays.asList(latestTimeSeriesDataPointForms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder latestTimeSeriesDataPointForms(
                Consumer<TimeSeriesDataPointSummaryFormOutput.Builder>... latestTimeSeriesDataPointForms) {
            latestTimeSeriesDataPointForms(Stream.of(latestTimeSeriesDataPointForms)
                    .map(c -> TimeSeriesDataPointSummaryFormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssetListingItemAdditionalAttributes build() {
            return new AssetListingItemAdditionalAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
