/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name map for assets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetTargetNameMap implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetTargetNameMap.Builder, AssetTargetNameMap> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(AssetTargetNameMap::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetName").getter(getter(AssetTargetNameMap::targetName)).setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD,
            TARGET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("assetId", ASSET_ID_FIELD);
                    put("targetName", TARGET_NAME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String assetId;

    private final String targetName;

    private AssetTargetNameMap(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.targetName = builder.targetName;
    }

    /**
     * <p>
     * The identifier of the inventory asset.
     * </p>
     * 
     * @return The identifier of the inventory asset.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The target name in the asset target name map.
     * </p>
     * 
     * @return The target name in the asset target name map.
     */
    public final String targetName() {
        return targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetTargetNameMap)) {
            return false;
        }
        AssetTargetNameMap other = (AssetTargetNameMap) obj;
        return Objects.equals(assetId(), other.assetId()) && Objects.equals(targetName(), other.targetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetTargetNameMap").add("AssetId", assetId()).add("TargetName", targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "targetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetTargetNameMap, T> g) {
        return obj -> g.apply((AssetTargetNameMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetTargetNameMap> {
        /**
         * <p>
         * The identifier of the inventory asset.
         * </p>
         * 
         * @param assetId
         *        The identifier of the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The target name in the asset target name map.
         * </p>
         * 
         * @param targetName
         *        The target name in the asset target name map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);
    }

    static final class BuilderImpl implements Builder {
        private String assetId;

        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetTargetNameMap model) {
            assetId(model.assetId);
            targetName(model.targetName);
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getTargetName() {
            return targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public AssetTargetNameMap build() {
            return new AssetTargetNameMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
