/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The asset type for the rule details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssetTypesForRule implements SdkPojo, Serializable,
        ToCopyableBuilder<AssetTypesForRule.Builder, AssetTypesForRule> {
    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectionMode").getter(getter(AssetTypesForRule::selectionModeAsString))
            .setter(setter(Builder::selectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()).build();

    private static final SdkField<List<String>> SPECIFIC_ASSET_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("specificAssetTypes")
            .getter(getter(AssetTypesForRule::specificAssetTypes))
            .setter(setter(Builder::specificAssetTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specificAssetTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_MODE_FIELD,
            SPECIFIC_ASSET_TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("selectionMode", SELECTION_MODE_FIELD);
                    put("specificAssetTypes", SPECIFIC_ASSET_TYPES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String selectionMode;

    private final List<String> specificAssetTypes;

    private AssetTypesForRule(BuilderImpl builder) {
        this.selectionMode = builder.selectionMode;
        this.specificAssetTypes = builder.specificAssetTypes;
    }

    /**
     * <p>
     * The selection mode for the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionMode}
     * will return {@link RuleScopeSelectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #selectionModeAsString}.
     * </p>
     * 
     * @return The selection mode for the rule.
     * @see RuleScopeSelectionMode
     */
    public final RuleScopeSelectionMode selectionMode() {
        return RuleScopeSelectionMode.fromValue(selectionMode);
    }

    /**
     * <p>
     * The selection mode for the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionMode}
     * will return {@link RuleScopeSelectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #selectionModeAsString}.
     * </p>
     * 
     * @return The selection mode for the rule.
     * @see RuleScopeSelectionMode
     */
    public final String selectionModeAsString() {
        return selectionMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the SpecificAssetTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSpecificAssetTypes() {
        return specificAssetTypes != null && !(specificAssetTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific asset types that are included in the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSpecificAssetTypes} method.
     * </p>
     * 
     * @return The specific asset types that are included in the rule.
     */
    public final List<String> specificAssetTypes() {
        return specificAssetTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSpecificAssetTypes() ? specificAssetTypes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetTypesForRule)) {
            return false;
        }
        AssetTypesForRule other = (AssetTypesForRule) obj;
        return Objects.equals(selectionModeAsString(), other.selectionModeAsString())
                && hasSpecificAssetTypes() == other.hasSpecificAssetTypes()
                && Objects.equals(specificAssetTypes(), other.specificAssetTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssetTypesForRule").add("SelectionMode", selectionModeAsString())
                .add("SpecificAssetTypes", hasSpecificAssetTypes() ? specificAssetTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selectionMode":
            return Optional.ofNullable(clazz.cast(selectionModeAsString()));
        case "specificAssetTypes":
            return Optional.ofNullable(clazz.cast(specificAssetTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetTypesForRule, T> g) {
        return obj -> g.apply((AssetTypesForRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssetTypesForRule> {
        /**
         * <p>
         * The selection mode for the rule.
         * </p>
         * 
         * @param selectionMode
         *        The selection mode for the rule.
         * @see RuleScopeSelectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleScopeSelectionMode
         */
        Builder selectionMode(String selectionMode);

        /**
         * <p>
         * The selection mode for the rule.
         * </p>
         * 
         * @param selectionMode
         *        The selection mode for the rule.
         * @see RuleScopeSelectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleScopeSelectionMode
         */
        Builder selectionMode(RuleScopeSelectionMode selectionMode);

        /**
         * <p>
         * The specific asset types that are included in the rule.
         * </p>
         * 
         * @param specificAssetTypes
         *        The specific asset types that are included in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specificAssetTypes(Collection<String> specificAssetTypes);

        /**
         * <p>
         * The specific asset types that are included in the rule.
         * </p>
         * 
         * @param specificAssetTypes
         *        The specific asset types that are included in the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specificAssetTypes(String... specificAssetTypes);
    }

    static final class BuilderImpl implements Builder {
        private String selectionMode;

        private List<String> specificAssetTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssetTypesForRule model) {
            selectionMode(model.selectionMode);
            specificAssetTypes(model.specificAssetTypes);
        }

        public final String getSelectionMode() {
            return selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public final Builder selectionMode(RuleScopeSelectionMode selectionMode) {
            this.selectionMode(selectionMode == null ? null : selectionMode.toString());
            return this;
        }

        public final Collection<String> getSpecificAssetTypes() {
            if (specificAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return specificAssetTypes;
        }

        public final void setSpecificAssetTypes(Collection<String> specificAssetTypes) {
            this.specificAssetTypes = RuleAssetTypeListCopier.copy(specificAssetTypes);
        }

        @Override
        public final Builder specificAssetTypes(Collection<String> specificAssetTypes) {
            this.specificAssetTypes = RuleAssetTypeListCopier.copy(specificAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specificAssetTypes(String... specificAssetTypes) {
            specificAssetTypes(Arrays.asList(specificAssetTypes));
            return this;
        }

        @Override
        public AssetTypesForRule build() {
            return new AssetTypesForRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
