/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Part of the provisioning properties of the environment blueprint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFormationProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFormationProperties.Builder, CloudFormationProperties> {
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateUrl").getter(getter(CloudFormationProperties::templateUrl)).setter(setter(Builder::templateUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("templateUrl", TEMPLATE_URL_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String templateUrl;

    private CloudFormationProperties(BuilderImpl builder) {
        this.templateUrl = builder.templateUrl;
    }

    /**
     * <p>
     * The template URL of the cloud formation provisioning properties of the environment blueprint.
     * </p>
     * 
     * @return The template URL of the cloud formation provisioning properties of the environment blueprint.
     */
    public final String templateUrl() {
        return templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationProperties)) {
            return false;
        }
        CloudFormationProperties other = (CloudFormationProperties) obj;
        return Objects.equals(templateUrl(), other.templateUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudFormationProperties").add("TemplateUrl", templateUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateUrl":
            return Optional.ofNullable(clazz.cast(templateUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationProperties, T> g) {
        return obj -> g.apply((CloudFormationProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFormationProperties> {
        /**
         * <p>
         * The template URL of the cloud formation provisioning properties of the environment blueprint.
         * </p>
         * 
         * @param templateUrl
         *        The template URL of the cloud formation provisioning properties of the environment blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUrl(String templateUrl);
    }

    static final class BuilderImpl implements Builder {
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationProperties model) {
            templateUrl(model.templateUrl);
        }

        public final String getTemplateUrl() {
            return templateUrl;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        @Override
        public CloudFormationProperties build() {
            return new CloudFormationProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
