/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConnectionPropertiesInput implements SdkPojo, Serializable,
        ToCopyableBuilder<ConnectionPropertiesInput.Builder, ConnectionPropertiesInput> {
    private static final SdkField<AthenaPropertiesInput> ATHENA_PROPERTIES_FIELD = SdkField
            .<AthenaPropertiesInput> builder(MarshallingType.SDK_POJO).memberName("athenaProperties")
            .getter(getter(ConnectionPropertiesInput::athenaProperties)).setter(setter(Builder::athenaProperties))
            .constructor(AthenaPropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build()).build();

    private static final SdkField<GluePropertiesInput> GLUE_PROPERTIES_FIELD = SdkField
            .<GluePropertiesInput> builder(MarshallingType.SDK_POJO).memberName("glueProperties")
            .getter(getter(ConnectionPropertiesInput::glueProperties)).setter(setter(Builder::glueProperties))
            .constructor(GluePropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueProperties").build()).build();

    private static final SdkField<HyperPodPropertiesInput> HYPER_POD_PROPERTIES_FIELD = SdkField
            .<HyperPodPropertiesInput> builder(MarshallingType.SDK_POJO).memberName("hyperPodProperties")
            .getter(getter(ConnectionPropertiesInput::hyperPodProperties)).setter(setter(Builder::hyperPodProperties))
            .constructor(HyperPodPropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperPodProperties").build())
            .build();

    private static final SdkField<IamPropertiesInput> IAM_PROPERTIES_FIELD = SdkField
            .<IamPropertiesInput> builder(MarshallingType.SDK_POJO).memberName("iamProperties")
            .getter(getter(ConnectionPropertiesInput::iamProperties)).setter(setter(Builder::iamProperties))
            .constructor(IamPropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamProperties").build()).build();

    private static final SdkField<RedshiftPropertiesInput> REDSHIFT_PROPERTIES_FIELD = SdkField
            .<RedshiftPropertiesInput> builder(MarshallingType.SDK_POJO).memberName("redshiftProperties")
            .getter(getter(ConnectionPropertiesInput::redshiftProperties)).setter(setter(Builder::redshiftProperties))
            .constructor(RedshiftPropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftProperties").build())
            .build();

    private static final SdkField<SparkEmrPropertiesInput> SPARK_EMR_PROPERTIES_FIELD = SdkField
            .<SparkEmrPropertiesInput> builder(MarshallingType.SDK_POJO).memberName("sparkEmrProperties")
            .getter(getter(ConnectionPropertiesInput::sparkEmrProperties)).setter(setter(Builder::sparkEmrProperties))
            .constructor(SparkEmrPropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkEmrProperties").build())
            .build();

    private static final SdkField<SparkGluePropertiesInput> SPARK_GLUE_PROPERTIES_FIELD = SdkField
            .<SparkGluePropertiesInput> builder(MarshallingType.SDK_POJO).memberName("sparkGlueProperties")
            .getter(getter(ConnectionPropertiesInput::sparkGlueProperties)).setter(setter(Builder::sparkGlueProperties))
            .constructor(SparkGluePropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkGlueProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD,
            GLUE_PROPERTIES_FIELD, HYPER_POD_PROPERTIES_FIELD, IAM_PROPERTIES_FIELD, REDSHIFT_PROPERTIES_FIELD,
            SPARK_EMR_PROPERTIES_FIELD, SPARK_GLUE_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("athenaProperties", ATHENA_PROPERTIES_FIELD);
                    put("glueProperties", GLUE_PROPERTIES_FIELD);
                    put("hyperPodProperties", HYPER_POD_PROPERTIES_FIELD);
                    put("iamProperties", IAM_PROPERTIES_FIELD);
                    put("redshiftProperties", REDSHIFT_PROPERTIES_FIELD);
                    put("sparkEmrProperties", SPARK_EMR_PROPERTIES_FIELD);
                    put("sparkGlueProperties", SPARK_GLUE_PROPERTIES_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final AthenaPropertiesInput athenaProperties;

    private final GluePropertiesInput glueProperties;

    private final HyperPodPropertiesInput hyperPodProperties;

    private final IamPropertiesInput iamProperties;

    private final RedshiftPropertiesInput redshiftProperties;

    private final SparkEmrPropertiesInput sparkEmrProperties;

    private final SparkGluePropertiesInput sparkGlueProperties;

    private final Type type;

    private ConnectionPropertiesInput(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.glueProperties = builder.glueProperties;
        this.hyperPodProperties = builder.hyperPodProperties;
        this.iamProperties = builder.iamProperties;
        this.redshiftProperties = builder.redshiftProperties;
        this.sparkEmrProperties = builder.sparkEmrProperties;
        this.sparkGlueProperties = builder.sparkGlueProperties;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Athena properties of a connection.
     * </p>
     * 
     * @return The Amazon Athena properties of a connection.
     */
    public final AthenaPropertiesInput athenaProperties() {
        return athenaProperties;
    }

    /**
     * <p>
     * The Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @return The Amazon Web Services Glue properties of a connection.
     */
    public final GluePropertiesInput glueProperties() {
        return glueProperties;
    }

    /**
     * <p>
     * The hyper pod properties of a connection.
     * </p>
     * 
     * @return The hyper pod properties of a connection.
     */
    public final HyperPodPropertiesInput hyperPodProperties() {
        return hyperPodProperties;
    }

    /**
     * <p>
     * The IAM properties of a connection.
     * </p>
     * 
     * @return The IAM properties of a connection.
     */
    public final IamPropertiesInput iamProperties() {
        return iamProperties;
    }

    /**
     * <p>
     * The Amazon Redshift properties of a connection.
     * </p>
     * 
     * @return The Amazon Redshift properties of a connection.
     */
    public final RedshiftPropertiesInput redshiftProperties() {
        return redshiftProperties;
    }

    /**
     * <p>
     * The Spark EMR properties of a connection.
     * </p>
     * 
     * @return The Spark EMR properties of a connection.
     */
    public final SparkEmrPropertiesInput sparkEmrProperties() {
        return sparkEmrProperties;
    }

    /**
     * <p>
     * The Spark Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @return The Spark Amazon Web Services Glue properties of a connection.
     */
    public final SparkGluePropertiesInput sparkGlueProperties() {
        return sparkGlueProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(athenaProperties());
        hashCode = 31 * hashCode + Objects.hashCode(glueProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hyperPodProperties());
        hashCode = 31 * hashCode + Objects.hashCode(iamProperties());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sparkEmrProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sparkGlueProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionPropertiesInput)) {
            return false;
        }
        ConnectionPropertiesInput other = (ConnectionPropertiesInput) obj;
        return Objects.equals(athenaProperties(), other.athenaProperties())
                && Objects.equals(glueProperties(), other.glueProperties())
                && Objects.equals(hyperPodProperties(), other.hyperPodProperties())
                && Objects.equals(iamProperties(), other.iamProperties())
                && Objects.equals(redshiftProperties(), other.redshiftProperties())
                && Objects.equals(sparkEmrProperties(), other.sparkEmrProperties())
                && Objects.equals(sparkGlueProperties(), other.sparkGlueProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConnectionPropertiesInput").add("AthenaProperties", athenaProperties())
                .add("GlueProperties", glueProperties()).add("HyperPodProperties", hyperPodProperties())
                .add("IamProperties", iamProperties()).add("RedshiftProperties", redshiftProperties())
                .add("SparkEmrProperties", sparkEmrProperties()).add("SparkGlueProperties", sparkGlueProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "athenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "glueProperties":
            return Optional.ofNullable(clazz.cast(glueProperties()));
        case "hyperPodProperties":
            return Optional.ofNullable(clazz.cast(hyperPodProperties()));
        case "iamProperties":
            return Optional.ofNullable(clazz.cast(iamProperties()));
        case "redshiftProperties":
            return Optional.ofNullable(clazz.cast(redshiftProperties()));
        case "sparkEmrProperties":
            return Optional.ofNullable(clazz.cast(sparkEmrProperties()));
        case "sparkGlueProperties":
            return Optional.ofNullable(clazz.cast(sparkGlueProperties()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection.
     */
    public static ConnectionPropertiesInput fromAthenaProperties(AthenaPropertiesInput athenaProperties) {
        return builder().athenaProperties(athenaProperties).build();
    }

    /**
     * Create an instance of this class with {@link #athenaProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Athena properties of a connection.
     * </p>
     * 
     * @param athenaProperties
     *        The Amazon Athena properties of a connection.
     */
    public static ConnectionPropertiesInput fromAthenaProperties(Consumer<AthenaPropertiesInput.Builder> athenaProperties) {
        AthenaPropertiesInput.Builder builder = AthenaPropertiesInput.builder();
        athenaProperties.accept(builder);
        return fromAthenaProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesInput fromGlueProperties(GluePropertiesInput glueProperties) {
        return builder().glueProperties(glueProperties).build();
    }

    /**
     * Create an instance of this class with {@link #glueProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param glueProperties
     *        The Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesInput fromGlueProperties(Consumer<GluePropertiesInput.Builder> glueProperties) {
        GluePropertiesInput.Builder builder = GluePropertiesInput.builder();
        glueProperties.accept(builder);
        return fromGlueProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #hyperPodProperties()} initialized to the given value.
     *
     * <p>
     * The hyper pod properties of a connection.
     * </p>
     * 
     * @param hyperPodProperties
     *        The hyper pod properties of a connection.
     */
    public static ConnectionPropertiesInput fromHyperPodProperties(HyperPodPropertiesInput hyperPodProperties) {
        return builder().hyperPodProperties(hyperPodProperties).build();
    }

    /**
     * Create an instance of this class with {@link #hyperPodProperties()} initialized to the given value.
     *
     * <p>
     * The hyper pod properties of a connection.
     * </p>
     * 
     * @param hyperPodProperties
     *        The hyper pod properties of a connection.
     */
    public static ConnectionPropertiesInput fromHyperPodProperties(Consumer<HyperPodPropertiesInput.Builder> hyperPodProperties) {
        HyperPodPropertiesInput.Builder builder = HyperPodPropertiesInput.builder();
        hyperPodProperties.accept(builder);
        return fromHyperPodProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection.
     */
    public static ConnectionPropertiesInput fromIamProperties(IamPropertiesInput iamProperties) {
        return builder().iamProperties(iamProperties).build();
    }

    /**
     * Create an instance of this class with {@link #iamProperties()} initialized to the given value.
     *
     * <p>
     * The IAM properties of a connection.
     * </p>
     * 
     * @param iamProperties
     *        The IAM properties of a connection.
     */
    public static ConnectionPropertiesInput fromIamProperties(Consumer<IamPropertiesInput.Builder> iamProperties) {
        IamPropertiesInput.Builder builder = IamPropertiesInput.builder();
        iamProperties.accept(builder);
        return fromIamProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection.
     */
    public static ConnectionPropertiesInput fromRedshiftProperties(RedshiftPropertiesInput redshiftProperties) {
        return builder().redshiftProperties(redshiftProperties).build();
    }

    /**
     * Create an instance of this class with {@link #redshiftProperties()} initialized to the given value.
     *
     * <p>
     * The Amazon Redshift properties of a connection.
     * </p>
     * 
     * @param redshiftProperties
     *        The Amazon Redshift properties of a connection.
     */
    public static ConnectionPropertiesInput fromRedshiftProperties(Consumer<RedshiftPropertiesInput.Builder> redshiftProperties) {
        RedshiftPropertiesInput.Builder builder = RedshiftPropertiesInput.builder();
        redshiftProperties.accept(builder);
        return fromRedshiftProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection.
     */
    public static ConnectionPropertiesInput fromSparkEmrProperties(SparkEmrPropertiesInput sparkEmrProperties) {
        return builder().sparkEmrProperties(sparkEmrProperties).build();
    }

    /**
     * Create an instance of this class with {@link #sparkEmrProperties()} initialized to the given value.
     *
     * <p>
     * The Spark EMR properties of a connection.
     * </p>
     * 
     * @param sparkEmrProperties
     *        The Spark EMR properties of a connection.
     */
    public static ConnectionPropertiesInput fromSparkEmrProperties(Consumer<SparkEmrPropertiesInput.Builder> sparkEmrProperties) {
        SparkEmrPropertiesInput.Builder builder = SparkEmrPropertiesInput.builder();
        sparkEmrProperties.accept(builder);
        return fromSparkEmrProperties(builder.build());
    }

    /**
     * Create an instance of this class with {@link #sparkGlueProperties()} initialized to the given value.
     *
     * <p>
     * The Spark Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param sparkGlueProperties
     *        The Spark Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesInput fromSparkGlueProperties(SparkGluePropertiesInput sparkGlueProperties) {
        return builder().sparkGlueProperties(sparkGlueProperties).build();
    }

    /**
     * Create an instance of this class with {@link #sparkGlueProperties()} initialized to the given value.
     *
     * <p>
     * The Spark Amazon Web Services Glue properties of a connection.
     * </p>
     * 
     * @param sparkGlueProperties
     *        The Spark Amazon Web Services Glue properties of a connection.
     */
    public static ConnectionPropertiesInput fromSparkGlueProperties(Consumer<SparkGluePropertiesInput.Builder> sparkGlueProperties) {
        SparkGluePropertiesInput.Builder builder = SparkGluePropertiesInput.builder();
        sparkGlueProperties.accept(builder);
        return fromSparkGlueProperties(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionPropertiesInput, T> g) {
        return obj -> g.apply((ConnectionPropertiesInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConnectionPropertiesInput> {
        /**
         * <p>
         * The Amazon Athena properties of a connection.
         * </p>
         * 
         * @param athenaProperties
         *        The Amazon Athena properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(AthenaPropertiesInput athenaProperties);

        /**
         * <p>
         * The Amazon Athena properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AthenaPropertiesInput.Builder} avoiding
         * the need to create one manually via {@link AthenaPropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AthenaPropertiesInput.Builder#build()} is called immediately and
         * its result is passed to {@link #athenaProperties(AthenaPropertiesInput)}.
         * 
         * @param athenaProperties
         *        a consumer that will call methods on {@link AthenaPropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #athenaProperties(AthenaPropertiesInput)
         */
        default Builder athenaProperties(Consumer<AthenaPropertiesInput.Builder> athenaProperties) {
            return athenaProperties(AthenaPropertiesInput.builder().applyMutation(athenaProperties).build());
        }

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection.
         * </p>
         * 
         * @param glueProperties
         *        The Amazon Web Services Glue properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueProperties(GluePropertiesInput glueProperties);

        /**
         * <p>
         * The Amazon Web Services Glue properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link GluePropertiesInput.Builder} avoiding the
         * need to create one manually via {@link GluePropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GluePropertiesInput.Builder#build()} is called immediately and
         * its result is passed to {@link #glueProperties(GluePropertiesInput)}.
         * 
         * @param glueProperties
         *        a consumer that will call methods on {@link GluePropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #glueProperties(GluePropertiesInput)
         */
        default Builder glueProperties(Consumer<GluePropertiesInput.Builder> glueProperties) {
            return glueProperties(GluePropertiesInput.builder().applyMutation(glueProperties).build());
        }

        /**
         * <p>
         * The hyper pod properties of a connection.
         * </p>
         * 
         * @param hyperPodProperties
         *        The hyper pod properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperPodProperties(HyperPodPropertiesInput hyperPodProperties);

        /**
         * <p>
         * The hyper pod properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link HyperPodPropertiesInput.Builder} avoiding
         * the need to create one manually via {@link HyperPodPropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HyperPodPropertiesInput.Builder#build()} is called immediately
         * and its result is passed to {@link #hyperPodProperties(HyperPodPropertiesInput)}.
         * 
         * @param hyperPodProperties
         *        a consumer that will call methods on {@link HyperPodPropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hyperPodProperties(HyperPodPropertiesInput)
         */
        default Builder hyperPodProperties(Consumer<HyperPodPropertiesInput.Builder> hyperPodProperties) {
            return hyperPodProperties(HyperPodPropertiesInput.builder().applyMutation(hyperPodProperties).build());
        }

        /**
         * <p>
         * The IAM properties of a connection.
         * </p>
         * 
         * @param iamProperties
         *        The IAM properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamProperties(IamPropertiesInput iamProperties);

        /**
         * <p>
         * The IAM properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamPropertiesInput.Builder} avoiding the
         * need to create one manually via {@link IamPropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamPropertiesInput.Builder#build()} is called immediately and its
         * result is passed to {@link #iamProperties(IamPropertiesInput)}.
         * 
         * @param iamProperties
         *        a consumer that will call methods on {@link IamPropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamProperties(IamPropertiesInput)
         */
        default Builder iamProperties(Consumer<IamPropertiesInput.Builder> iamProperties) {
            return iamProperties(IamPropertiesInput.builder().applyMutation(iamProperties).build());
        }

        /**
         * <p>
         * The Amazon Redshift properties of a connection.
         * </p>
         * 
         * @param redshiftProperties
         *        The Amazon Redshift properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftProperties(RedshiftPropertiesInput redshiftProperties);

        /**
         * <p>
         * The Amazon Redshift properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftPropertiesInput.Builder} avoiding
         * the need to create one manually via {@link RedshiftPropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftPropertiesInput.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftProperties(RedshiftPropertiesInput)}.
         * 
         * @param redshiftProperties
         *        a consumer that will call methods on {@link RedshiftPropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftProperties(RedshiftPropertiesInput)
         */
        default Builder redshiftProperties(Consumer<RedshiftPropertiesInput.Builder> redshiftProperties) {
            return redshiftProperties(RedshiftPropertiesInput.builder().applyMutation(redshiftProperties).build());
        }

        /**
         * <p>
         * The Spark EMR properties of a connection.
         * </p>
         * 
         * @param sparkEmrProperties
         *        The Spark EMR properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkEmrProperties(SparkEmrPropertiesInput sparkEmrProperties);

        /**
         * <p>
         * The Spark EMR properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkEmrPropertiesInput.Builder} avoiding
         * the need to create one manually via {@link SparkEmrPropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkEmrPropertiesInput.Builder#build()} is called immediately
         * and its result is passed to {@link #sparkEmrProperties(SparkEmrPropertiesInput)}.
         * 
         * @param sparkEmrProperties
         *        a consumer that will call methods on {@link SparkEmrPropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkEmrProperties(SparkEmrPropertiesInput)
         */
        default Builder sparkEmrProperties(Consumer<SparkEmrPropertiesInput.Builder> sparkEmrProperties) {
            return sparkEmrProperties(SparkEmrPropertiesInput.builder().applyMutation(sparkEmrProperties).build());
        }

        /**
         * <p>
         * The Spark Amazon Web Services Glue properties of a connection.
         * </p>
         * 
         * @param sparkGlueProperties
         *        The Spark Amazon Web Services Glue properties of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkGlueProperties(SparkGluePropertiesInput sparkGlueProperties);

        /**
         * <p>
         * The Spark Amazon Web Services Glue properties of a connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link SparkGluePropertiesInput.Builder}
         * avoiding the need to create one manually via {@link SparkGluePropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SparkGluePropertiesInput.Builder#build()} is called immediately
         * and its result is passed to {@link #sparkGlueProperties(SparkGluePropertiesInput)}.
         * 
         * @param sparkGlueProperties
         *        a consumer that will call methods on {@link SparkGluePropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparkGlueProperties(SparkGluePropertiesInput)
         */
        default Builder sparkGlueProperties(Consumer<SparkGluePropertiesInput.Builder> sparkGlueProperties) {
            return sparkGlueProperties(SparkGluePropertiesInput.builder().applyMutation(sparkGlueProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AthenaPropertiesInput athenaProperties;

        private GluePropertiesInput glueProperties;

        private HyperPodPropertiesInput hyperPodProperties;

        private IamPropertiesInput iamProperties;

        private RedshiftPropertiesInput redshiftProperties;

        private SparkEmrPropertiesInput sparkEmrProperties;

        private SparkGluePropertiesInput sparkGlueProperties;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionPropertiesInput model) {
            athenaProperties(model.athenaProperties);
            glueProperties(model.glueProperties);
            hyperPodProperties(model.hyperPodProperties);
            iamProperties(model.iamProperties);
            redshiftProperties(model.redshiftProperties);
            sparkEmrProperties(model.sparkEmrProperties);
            sparkGlueProperties(model.sparkGlueProperties);
        }

        public final AthenaPropertiesInput.Builder getAthenaProperties() {
            return athenaProperties != null ? athenaProperties.toBuilder() : null;
        }

        public final void setAthenaProperties(AthenaPropertiesInput.BuilderImpl athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties != null ? athenaProperties.build() : null;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
        }

        @Override
        public final Builder athenaProperties(AthenaPropertiesInput athenaProperties) {
            Object oldValue = this.athenaProperties;
            this.athenaProperties = athenaProperties;
            handleUnionValueChange(Type.ATHENA_PROPERTIES, oldValue, this.athenaProperties);
            return this;
        }

        public final GluePropertiesInput.Builder getGlueProperties() {
            return glueProperties != null ? glueProperties.toBuilder() : null;
        }

        public final void setGlueProperties(GluePropertiesInput.BuilderImpl glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties != null ? glueProperties.build() : null;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
        }

        @Override
        public final Builder glueProperties(GluePropertiesInput glueProperties) {
            Object oldValue = this.glueProperties;
            this.glueProperties = glueProperties;
            handleUnionValueChange(Type.GLUE_PROPERTIES, oldValue, this.glueProperties);
            return this;
        }

        public final HyperPodPropertiesInput.Builder getHyperPodProperties() {
            return hyperPodProperties != null ? hyperPodProperties.toBuilder() : null;
        }

        public final void setHyperPodProperties(HyperPodPropertiesInput.BuilderImpl hyperPodProperties) {
            Object oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties != null ? hyperPodProperties.build() : null;
            handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
        }

        @Override
        public final Builder hyperPodProperties(HyperPodPropertiesInput hyperPodProperties) {
            Object oldValue = this.hyperPodProperties;
            this.hyperPodProperties = hyperPodProperties;
            handleUnionValueChange(Type.HYPER_POD_PROPERTIES, oldValue, this.hyperPodProperties);
            return this;
        }

        public final IamPropertiesInput.Builder getIamProperties() {
            return iamProperties != null ? iamProperties.toBuilder() : null;
        }

        public final void setIamProperties(IamPropertiesInput.BuilderImpl iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties != null ? iamProperties.build() : null;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
        }

        @Override
        public final Builder iamProperties(IamPropertiesInput iamProperties) {
            Object oldValue = this.iamProperties;
            this.iamProperties = iamProperties;
            handleUnionValueChange(Type.IAM_PROPERTIES, oldValue, this.iamProperties);
            return this;
        }

        public final RedshiftPropertiesInput.Builder getRedshiftProperties() {
            return redshiftProperties != null ? redshiftProperties.toBuilder() : null;
        }

        public final void setRedshiftProperties(RedshiftPropertiesInput.BuilderImpl redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties != null ? redshiftProperties.build() : null;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
        }

        @Override
        public final Builder redshiftProperties(RedshiftPropertiesInput redshiftProperties) {
            Object oldValue = this.redshiftProperties;
            this.redshiftProperties = redshiftProperties;
            handleUnionValueChange(Type.REDSHIFT_PROPERTIES, oldValue, this.redshiftProperties);
            return this;
        }

        public final SparkEmrPropertiesInput.Builder getSparkEmrProperties() {
            return sparkEmrProperties != null ? sparkEmrProperties.toBuilder() : null;
        }

        public final void setSparkEmrProperties(SparkEmrPropertiesInput.BuilderImpl sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties != null ? sparkEmrProperties.build() : null;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
        }

        @Override
        public final Builder sparkEmrProperties(SparkEmrPropertiesInput sparkEmrProperties) {
            Object oldValue = this.sparkEmrProperties;
            this.sparkEmrProperties = sparkEmrProperties;
            handleUnionValueChange(Type.SPARK_EMR_PROPERTIES, oldValue, this.sparkEmrProperties);
            return this;
        }

        public final SparkGluePropertiesInput.Builder getSparkGlueProperties() {
            return sparkGlueProperties != null ? sparkGlueProperties.toBuilder() : null;
        }

        public final void setSparkGlueProperties(SparkGluePropertiesInput.BuilderImpl sparkGlueProperties) {
            Object oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties != null ? sparkGlueProperties.build() : null;
            handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
        }

        @Override
        public final Builder sparkGlueProperties(SparkGluePropertiesInput sparkGlueProperties) {
            Object oldValue = this.sparkGlueProperties;
            this.sparkGlueProperties = sparkGlueProperties;
            handleUnionValueChange(Type.SPARK_GLUE_PROPERTIES, oldValue, this.sparkGlueProperties);
            return this;
        }

        @Override
        public ConnectionPropertiesInput build() {
            return new ConnectionPropertiesInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConnectionPropertiesInput#type()
     */
    public enum Type {
        ATHENA_PROPERTIES,

        GLUE_PROPERTIES,

        HYPER_POD_PROPERTIES,

        IAM_PROPERTIES,

        REDSHIFT_PROPERTIES,

        SPARK_EMR_PROPERTIES,

        SPARK_GLUE_PROPERTIES,

        UNKNOWN_TO_SDK_VERSION
    }
}
