/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateConnectionRequest.Builder, CreateConnectionRequest> {
    private static final SdkField<AwsLocation> AWS_LOCATION_FIELD = SdkField.<AwsLocation> builder(MarshallingType.SDK_POJO)
            .memberName("awsLocation").getter(getter(CreateConnectionRequest::awsLocation)).setter(setter(Builder::awsLocation))
            .constructor(AwsLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLocation").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateConnectionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateConnectionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateConnectionRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentIdentifier").getter(getter(CreateConnectionRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateConnectionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConnectionPropertiesInput> PROPS_FIELD = SdkField
            .<ConnectionPropertiesInput> builder(MarshallingType.SDK_POJO).memberName("props")
            .getter(getter(CreateConnectionRequest::props)).setter(setter(Builder::props))
            .constructor(ConnectionPropertiesInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("props").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AWS_LOCATION_FIELD, CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD,
                    ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PROPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("awsLocation", AWS_LOCATION_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
                    put("name", NAME_FIELD);
                    put("props", PROPS_FIELD);
                }
            });

    private final AwsLocation awsLocation;

    private final String clientToken;

    private final String description;

    private final String domainIdentifier;

    private final String environmentIdentifier;

    private final String name;

    private final ConnectionPropertiesInput props;

    private CreateConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.awsLocation = builder.awsLocation;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.props = builder.props;
    }

    /**
     * <p>
     * The location where the connection is created.
     * </p>
     * 
     * @return The location where the connection is created.
     */
    public final AwsLocation awsLocation() {
        return awsLocation;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A connection description.
     * </p>
     * 
     * @return A connection description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where the connection is created.
     * </p>
     * 
     * @return The ID of the domain where the connection is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the environment where the connection is created.
     * </p>
     * 
     * @return The ID of the environment where the connection is created.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The connection name.
     * </p>
     * 
     * @return The connection name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The connection props.
     * </p>
     * 
     * @return The connection props.
     */
    public final ConnectionPropertiesInput props() {
        return props;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(props());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest) obj;
        return Objects.equals(awsLocation(), other.awsLocation()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(props(), other.props());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionRequest").add("AwsLocation", awsLocation()).add("ClientToken", clientToken())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DomainIdentifier", domainIdentifier()).add("EnvironmentIdentifier", environmentIdentifier())
                .add("Name", name()).add("Props", props()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsLocation":
            return Optional.ofNullable(clazz.cast(awsLocation()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "props":
            return Optional.ofNullable(clazz.cast(props()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionRequest, T> g) {
        return obj -> g.apply((CreateConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionRequest> {
        /**
         * <p>
         * The location where the connection is created.
         * </p>
         * 
         * @param awsLocation
         *        The location where the connection is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLocation(AwsLocation awsLocation);

        /**
         * <p>
         * The location where the connection is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsLocation.Builder} avoiding the need to
         * create one manually via {@link AwsLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #awsLocation(AwsLocation)}.
         * 
         * @param awsLocation
         *        a consumer that will call methods on {@link AwsLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLocation(AwsLocation)
         */
        default Builder awsLocation(Consumer<AwsLocation.Builder> awsLocation) {
            return awsLocation(AwsLocation.builder().applyMutation(awsLocation).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A connection description.
         * </p>
         * 
         * @param description
         *        A connection description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where the connection is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where the connection is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the environment where the connection is created.
         * </p>
         * 
         * @param environmentIdentifier
         *        The ID of the environment where the connection is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The connection name.
         * </p>
         * 
         * @param name
         *        The connection name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The connection props.
         * </p>
         * 
         * @param props
         *        The connection props.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder props(ConnectionPropertiesInput props);

        /**
         * <p>
         * The connection props.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPropertiesInput.Builder}
         * avoiding the need to create one manually via {@link ConnectionPropertiesInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPropertiesInput.Builder#build()} is called immediately
         * and its result is passed to {@link #props(ConnectionPropertiesInput)}.
         * 
         * @param props
         *        a consumer that will call methods on {@link ConnectionPropertiesInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #props(ConnectionPropertiesInput)
         */
        default Builder props(Consumer<ConnectionPropertiesInput.Builder> props) {
            return props(ConnectionPropertiesInput.builder().applyMutation(props).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private AwsLocation awsLocation;

        private String clientToken;

        private String description;

        private String domainIdentifier;

        private String environmentIdentifier;

        private String name;

        private ConnectionPropertiesInput props;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionRequest model) {
            super(model);
            awsLocation(model.awsLocation);
            clientToken(model.clientToken);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            environmentIdentifier(model.environmentIdentifier);
            name(model.name);
            props(model.props);
        }

        public final AwsLocation.Builder getAwsLocation() {
            return awsLocation != null ? awsLocation.toBuilder() : null;
        }

        public final void setAwsLocation(AwsLocation.BuilderImpl awsLocation) {
            this.awsLocation = awsLocation != null ? awsLocation.build() : null;
        }

        @Override
        public final Builder awsLocation(AwsLocation awsLocation) {
            this.awsLocation = awsLocation;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectionPropertiesInput.Builder getProps() {
            return props != null ? props.toBuilder() : null;
        }

        public final void setProps(ConnectionPropertiesInput.BuilderImpl props) {
            this.props = props != null ? props.build() : null;
        }

        @Override
        public final Builder props(ConnectionPropertiesInput props) {
            this.props = props;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionRequest build() {
            return new CreateConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
