/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateDataSourceResponse.Builder, CreateDataSourceResponse> {
    private static final SdkField<List<FormOutput>> ASSET_FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("assetFormsOutput")
            .getter(getter(CreateDataSourceResponse::assetFormsOutput))
            .setter(setter(Builder::assetFormsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetFormsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceConfigurationOutput> CONFIGURATION_FIELD = SdkField
            .<DataSourceConfigurationOutput> builder(MarshallingType.SDK_POJO).memberName("configuration")
            .getter(getter(CreateDataSourceResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(DataSourceConfigurationOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()).build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionId").getter(getter(CreateDataSourceResponse::connectionId))
            .setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(CreateDataSourceResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDataSourceResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateDataSourceResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("enableSetting").getter(getter(CreateDataSourceResponse::enableSettingAsString))
            .setter(setter(Builder::enableSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(CreateDataSourceResponse::environmentId))
            .setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<DataSourceErrorMessage> ERROR_MESSAGE_FIELD = SdkField
            .<DataSourceErrorMessage> builder(MarshallingType.SDK_POJO).memberName("errorMessage")
            .getter(getter(CreateDataSourceResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .constructor(DataSourceErrorMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateDataSourceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_RUN_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastRunAt")
            .getter(getter(CreateDataSourceResponse::lastRunAt))
            .setter(setter(Builder::lastRunAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DataSourceErrorMessage> LAST_RUN_ERROR_MESSAGE_FIELD = SdkField
            .<DataSourceErrorMessage> builder(MarshallingType.SDK_POJO).memberName("lastRunErrorMessage")
            .getter(getter(CreateDataSourceResponse::lastRunErrorMessage)).setter(setter(Builder::lastRunErrorMessage))
            .constructor(DataSourceErrorMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunErrorMessage").build())
            .build();

    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastRunStatus").getter(getter(CreateDataSourceResponse::lastRunStatusAsString))
            .setter(setter(Builder::lastRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunStatus").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDataSourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(CreateDataSourceResponse::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<Boolean> PUBLISH_ON_IMPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publishOnImport").getter(getter(CreateDataSourceResponse::publishOnImport))
            .setter(setter(Builder::publishOnImport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishOnImport").build()).build();

    private static final SdkField<RecommendationConfiguration> RECOMMENDATION_FIELD = SdkField
            .<RecommendationConfiguration> builder(MarshallingType.SDK_POJO).memberName("recommendation")
            .getter(getter(CreateDataSourceResponse::recommendation)).setter(setter(Builder::recommendation))
            .constructor(RecommendationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("schedule")
            .getter(getter(CreateDataSourceResponse::schedule)).setter(setter(Builder::schedule))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateDataSourceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateDataSourceResponse::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(CreateDataSourceResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FORMS_OUTPUT_FIELD,
            CONFIGURATION_FIELD, CONNECTION_ID_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, ENABLE_SETTING_FIELD,
            ENVIRONMENT_ID_FIELD, ERROR_MESSAGE_FIELD, ID_FIELD, LAST_RUN_AT_FIELD, LAST_RUN_ERROR_MESSAGE_FIELD,
            LAST_RUN_STATUS_FIELD, NAME_FIELD, PROJECT_ID_FIELD, PUBLISH_ON_IMPORT_FIELD, RECOMMENDATION_FIELD, SCHEDULE_FIELD,
            STATUS_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("assetFormsOutput", ASSET_FORMS_OUTPUT_FIELD);
                    put("configuration", CONFIGURATION_FIELD);
                    put("connectionId", CONNECTION_ID_FIELD);
                    put("createdAt", CREATED_AT_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("enableSetting", ENABLE_SETTING_FIELD);
                    put("environmentId", ENVIRONMENT_ID_FIELD);
                    put("errorMessage", ERROR_MESSAGE_FIELD);
                    put("id", ID_FIELD);
                    put("lastRunAt", LAST_RUN_AT_FIELD);
                    put("lastRunErrorMessage", LAST_RUN_ERROR_MESSAGE_FIELD);
                    put("lastRunStatus", LAST_RUN_STATUS_FIELD);
                    put("name", NAME_FIELD);
                    put("projectId", PROJECT_ID_FIELD);
                    put("publishOnImport", PUBLISH_ON_IMPORT_FIELD);
                    put("recommendation", RECOMMENDATION_FIELD);
                    put("schedule", SCHEDULE_FIELD);
                    put("status", STATUS_FIELD);
                    put("type", TYPE_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                }
            });

    private final List<FormOutput> assetFormsOutput;

    private final DataSourceConfigurationOutput configuration;

    private final String connectionId;

    private final Instant createdAt;

    private final String description;

    private final String domainId;

    private final String enableSetting;

    private final String environmentId;

    private final DataSourceErrorMessage errorMessage;

    private final String id;

    private final Instant lastRunAt;

    private final DataSourceErrorMessage lastRunErrorMessage;

    private final String lastRunStatus;

    private final String name;

    private final String projectId;

    private final Boolean publishOnImport;

    private final RecommendationConfiguration recommendation;

    private final ScheduleConfiguration schedule;

    private final String status;

    private final String type;

    private final Instant updatedAt;

    private CreateDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.assetFormsOutput = builder.assetFormsOutput;
        this.configuration = builder.configuration;
        this.connectionId = builder.connectionId;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.enableSetting = builder.enableSetting;
        this.environmentId = builder.environmentId;
        this.errorMessage = builder.errorMessage;
        this.id = builder.id;
        this.lastRunAt = builder.lastRunAt;
        this.lastRunErrorMessage = builder.lastRunErrorMessage;
        this.lastRunStatus = builder.lastRunStatus;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.publishOnImport = builder.publishOnImport;
        this.recommendation = builder.recommendation;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetFormsOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetFormsOutput() {
        return assetFormsOutput != null && !(assetFormsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata forms attached to the assets that this data source creates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetFormsOutput} method.
     * </p>
     * 
     * @return The metadata forms attached to the assets that this data source creates.
     */
    public final List<FormOutput> assetFormsOutput() {
        return assetFormsOutput;
    }

    /**
     * <p>
     * Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or
     * <code>redshiftRunConfiguration</code>.
     * </p>
     * 
     * @return Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code>
     *         or <code>redshiftRunConfiguration</code>.
     */
    public final DataSourceConfigurationOutput configuration() {
        return configuration;
    }

    /**
     * <p>
     * The ID of the connection.
     * </p>
     * 
     * @return The ID of the connection.
     */
    public final String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The timestamp of when the data source was created.
     * </p>
     * 
     * @return The timestamp of when the data source was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the data source.
     * </p>
     * 
     * @return The description of the data source.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which the data source is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which the data source is created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Specifies whether the data source is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return Specifies whether the data source is enabled.
     * @see EnableSetting
     */
    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(enableSetting);
    }

    /**
     * <p>
     * Specifies whether the data source is enabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #enableSetting}
     * will return {@link EnableSetting#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #enableSettingAsString}.
     * </p>
     * 
     * @return Specifies whether the data source is enabled.
     * @see EnableSetting
     */
    public final String enableSettingAsString() {
        return enableSetting;
    }

    /**
     * <p>
     * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     * </p>
     * 
     * @return The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * 
     * @return Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public final DataSourceErrorMessage errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The unique identifier of the data source.
     * </p>
     * 
     * @return The unique identifier of the data source.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The timestamp that specifies when the data source was last run.
     * </p>
     * 
     * @return The timestamp that specifies when the data source was last run.
     */
    public final Instant lastRunAt() {
        return lastRunAt;
    }

    /**
     * <p>
     * Specifies the error message that is returned if the operation cannot be successfully completed.
     * </p>
     * 
     * @return Specifies the error message that is returned if the operation cannot be successfully completed.
     */
    public final DataSourceErrorMessage lastRunErrorMessage() {
        return lastRunErrorMessage;
    }

    /**
     * <p>
     * The status of the last run of this data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastRunStatus}
     * will return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastRunStatusAsString}.
     * </p>
     * 
     * @return The status of the last run of this data source.
     * @see DataSourceRunStatus
     */
    public final DataSourceRunStatus lastRunStatus() {
        return DataSourceRunStatus.fromValue(lastRunStatus);
    }

    /**
     * <p>
     * The status of the last run of this data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastRunStatus}
     * will return {@link DataSourceRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastRunStatusAsString}.
     * </p>
     * 
     * @return The status of the last run of this data source.
     * @see DataSourceRunStatus
     */
    public final String lastRunStatusAsString() {
        return lastRunStatus;
    }

    /**
     * <p>
     * The name of the data source.
     * </p>
     * 
     * @return The name of the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone project to which the data source is added.
     * </p>
     * 
     * @return The ID of the Amazon DataZone project to which the data source is added.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * Specifies whether the assets that this data source creates in the inventory are to be also automatically
     * published to the catalog.
     * </p>
     * 
     * @return Specifies whether the assets that this data source creates in the inventory are to be also automatically
     *         published to the catalog.
     */
    public final Boolean publishOnImport() {
        return publishOnImport;
    }

    /**
     * <p>
     * Specifies whether the business name generation is to be enabled for this data source.
     * </p>
     * 
     * @return Specifies whether the business name generation is to be enabled for this data source.
     */
    public final RecommendationConfiguration recommendation() {
        return recommendation;
    }

    /**
     * <p>
     * The schedule of the data source runs.
     * </p>
     * 
     * @return The schedule of the data source runs.
     */
    public final ScheduleConfiguration schedule() {
        return schedule;
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceStatus
     */
    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the data source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DataSourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the data source.
     * @see DataSourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the data source.
     * </p>
     * 
     * @return The type of the data source.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The timestamp of when the data source was updated.
     * </p>
     * 
     * @return The timestamp of when the data source was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetFormsOutput() ? assetFormsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(publishOnImport());
        hashCode = 31 * hashCode + Objects.hashCode(recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceResponse)) {
            return false;
        }
        CreateDataSourceResponse other = (CreateDataSourceResponse) obj;
        return hasAssetFormsOutput() == other.hasAssetFormsOutput()
                && Objects.equals(assetFormsOutput(), other.assetFormsOutput())
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(connectionId(), other.connectionId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(domainId(), other.domainId())
                && Objects.equals(enableSettingAsString(), other.enableSettingAsString())
                && Objects.equals(environmentId(), other.environmentId()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(id(), other.id()) && Objects.equals(lastRunAt(), other.lastRunAt())
                && Objects.equals(lastRunErrorMessage(), other.lastRunErrorMessage())
                && Objects.equals(lastRunStatusAsString(), other.lastRunStatusAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(projectId(), other.projectId()) && Objects.equals(publishOnImport(), other.publishOnImport())
                && Objects.equals(recommendation(), other.recommendation()) && Objects.equals(schedule(), other.schedule())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(type(), other.type())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceResponse")
                .add("AssetFormsOutput", hasAssetFormsOutput() ? assetFormsOutput() : null).add("Configuration", configuration())
                .add("ConnectionId", connectionId()).add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EnableSetting", enableSettingAsString()).add("EnvironmentId", environmentId())
                .add("ErrorMessage", errorMessage()).add("Id", id()).add("LastRunAt", lastRunAt())
                .add("LastRunErrorMessage", lastRunErrorMessage()).add("LastRunStatus", lastRunStatusAsString())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("ProjectId", projectId())
                .add("PublishOnImport", publishOnImport()).add("Recommendation", recommendation())
                .add("Schedule", schedule() == null ? null : "*** Sensitive Data Redacted ***").add("Status", statusAsString())
                .add("Type", type()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetFormsOutput":
            return Optional.ofNullable(clazz.cast(assetFormsOutput()));
        case "configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "enableSetting":
            return Optional.ofNullable(clazz.cast(enableSettingAsString()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastRunAt":
            return Optional.ofNullable(clazz.cast(lastRunAt()));
        case "lastRunErrorMessage":
            return Optional.ofNullable(clazz.cast(lastRunErrorMessage()));
        case "lastRunStatus":
            return Optional.ofNullable(clazz.cast(lastRunStatusAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "publishOnImport":
            return Optional.ofNullable(clazz.cast(publishOnImport()));
        case "recommendation":
            return Optional.ofNullable(clazz.cast(recommendation()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceResponse, T> g) {
        return obj -> g.apply((CreateDataSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceResponse> {
        /**
         * <p>
         * The metadata forms attached to the assets that this data source creates.
         * </p>
         * 
         * @param assetFormsOutput
         *        The metadata forms attached to the assets that this data source creates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetFormsOutput(Collection<FormOutput> assetFormsOutput);

        /**
         * <p>
         * The metadata forms attached to the assets that this data source creates.
         * </p>
         * 
         * @param assetFormsOutput
         *        The metadata forms attached to the assets that this data source creates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetFormsOutput(FormOutput... assetFormsOutput);

        /**
         * <p>
         * The metadata forms attached to the assets that this data source creates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #assetFormsOutput(List<FormOutput>)}.
         * 
         * @param assetFormsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetFormsOutput(java.util.Collection<FormOutput>)
         */
        Builder assetFormsOutput(Consumer<FormOutput.Builder>... assetFormsOutput);

        /**
         * <p>
         * Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or
         * <code>redshiftRunConfiguration</code>.
         * </p>
         * 
         * @param configuration
         *        Specifies the configuration of the data source. It can be set to either
         *        <code>glueRunConfiguration</code> or <code>redshiftRunConfiguration</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(DataSourceConfigurationOutput configuration);

        /**
         * <p>
         * Specifies the configuration of the data source. It can be set to either <code>glueRunConfiguration</code> or
         * <code>redshiftRunConfiguration</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceConfigurationOutput.Builder}
         * avoiding the need to create one manually via {@link DataSourceConfigurationOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceConfigurationOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(DataSourceConfigurationOutput)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link DataSourceConfigurationOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(DataSourceConfigurationOutput)
         */
        default Builder configuration(Consumer<DataSourceConfigurationOutput.Builder> configuration) {
            return configuration(DataSourceConfigurationOutput.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The ID of the connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The timestamp of when the data source was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the data source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the data source.
         * </p>
         * 
         * @param description
         *        The description of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which the data source is created.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which the data source is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Specifies whether the data source is enabled.
         * </p>
         * 
         * @param enableSetting
         *        Specifies whether the data source is enabled.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(String enableSetting);

        /**
         * <p>
         * Specifies whether the data source is enabled.
         * </p>
         * 
         * @param enableSetting
         *        Specifies whether the data source is enabled.
         * @see EnableSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableSetting
         */
        Builder enableSetting(EnableSetting enableSetting);

        /**
         * <p>
         * The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
         * </p>
         * 
         * @param environmentId
         *        The unique identifier of the Amazon DataZone environment to which the data source publishes assets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param errorMessage
         *        Specifies the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(DataSourceErrorMessage errorMessage);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceErrorMessage.Builder} avoiding
         * the need to create one manually via {@link DataSourceErrorMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceErrorMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #errorMessage(DataSourceErrorMessage)}.
         * 
         * @param errorMessage
         *        a consumer that will call methods on {@link DataSourceErrorMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorMessage(DataSourceErrorMessage)
         */
        default Builder errorMessage(Consumer<DataSourceErrorMessage.Builder> errorMessage) {
            return errorMessage(DataSourceErrorMessage.builder().applyMutation(errorMessage).build());
        }

        /**
         * <p>
         * The unique identifier of the data source.
         * </p>
         * 
         * @param id
         *        The unique identifier of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The timestamp that specifies when the data source was last run.
         * </p>
         * 
         * @param lastRunAt
         *        The timestamp that specifies when the data source was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunAt(Instant lastRunAt);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * 
         * @param lastRunErrorMessage
         *        Specifies the error message that is returned if the operation cannot be successfully completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRunErrorMessage(DataSourceErrorMessage lastRunErrorMessage);

        /**
         * <p>
         * Specifies the error message that is returned if the operation cannot be successfully completed.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataSourceErrorMessage.Builder} avoiding
         * the need to create one manually via {@link DataSourceErrorMessage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceErrorMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #lastRunErrorMessage(DataSourceErrorMessage)}.
         * 
         * @param lastRunErrorMessage
         *        a consumer that will call methods on {@link DataSourceErrorMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRunErrorMessage(DataSourceErrorMessage)
         */
        default Builder lastRunErrorMessage(Consumer<DataSourceErrorMessage.Builder> lastRunErrorMessage) {
            return lastRunErrorMessage(DataSourceErrorMessage.builder().applyMutation(lastRunErrorMessage).build());
        }

        /**
         * <p>
         * The status of the last run of this data source.
         * </p>
         * 
         * @param lastRunStatus
         *        The status of the last run of this data source.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder lastRunStatus(String lastRunStatus);

        /**
         * <p>
         * The status of the last run of this data source.
         * </p>
         * 
         * @param lastRunStatus
         *        The status of the last run of this data source.
         * @see DataSourceRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceRunStatus
         */
        Builder lastRunStatus(DataSourceRunStatus lastRunStatus);

        /**
         * <p>
         * The name of the data source.
         * </p>
         * 
         * @param name
         *        The name of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Amazon DataZone project to which the data source is added.
         * </p>
         * 
         * @param projectId
         *        The ID of the Amazon DataZone project to which the data source is added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * Specifies whether the assets that this data source creates in the inventory are to be also automatically
         * published to the catalog.
         * </p>
         * 
         * @param publishOnImport
         *        Specifies whether the assets that this data source creates in the inventory are to be also
         *        automatically published to the catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishOnImport(Boolean publishOnImport);

        /**
         * <p>
         * Specifies whether the business name generation is to be enabled for this data source.
         * </p>
         * 
         * @param recommendation
         *        Specifies whether the business name generation is to be enabled for this data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendation(RecommendationConfiguration recommendation);

        /**
         * <p>
         * Specifies whether the business name generation is to be enabled for this data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecommendationConfiguration.Builder}
         * avoiding the need to create one manually via {@link RecommendationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendation(RecommendationConfiguration)}.
         * 
         * @param recommendation
         *        a consumer that will call methods on {@link RecommendationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendation(RecommendationConfiguration)
         */
        default Builder recommendation(Consumer<RecommendationConfiguration.Builder> recommendation) {
            return recommendation(RecommendationConfiguration.builder().applyMutation(recommendation).build());
        }

        /**
         * <p>
         * The schedule of the data source runs.
         * </p>
         * 
         * @param schedule
         *        The schedule of the data source runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(ScheduleConfiguration schedule);

        /**
         * <p>
         * The schedule of the data source runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(ScheduleConfiguration)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(ScheduleConfiguration)
         */
        default Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return schedule(ScheduleConfiguration.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the data source.
         * </p>
         * 
         * @param status
         *        The status of the data source.
         * @see DataSourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceStatus
         */
        Builder status(DataSourceStatus status);

        /**
         * <p>
         * The type of the data source.
         * </p>
         * 
         * @param type
         *        The type of the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The timestamp of when the data source was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the data source was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private List<FormOutput> assetFormsOutput = DefaultSdkAutoConstructList.getInstance();

        private DataSourceConfigurationOutput configuration;

        private String connectionId;

        private Instant createdAt;

        private String description;

        private String domainId;

        private String enableSetting;

        private String environmentId;

        private DataSourceErrorMessage errorMessage;

        private String id;

        private Instant lastRunAt;

        private DataSourceErrorMessage lastRunErrorMessage;

        private String lastRunStatus;

        private String name;

        private String projectId;

        private Boolean publishOnImport;

        private RecommendationConfiguration recommendation;

        private ScheduleConfiguration schedule;

        private String status;

        private String type;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceResponse model) {
            super(model);
            assetFormsOutput(model.assetFormsOutput);
            configuration(model.configuration);
            connectionId(model.connectionId);
            createdAt(model.createdAt);
            description(model.description);
            domainId(model.domainId);
            enableSetting(model.enableSetting);
            environmentId(model.environmentId);
            errorMessage(model.errorMessage);
            id(model.id);
            lastRunAt(model.lastRunAt);
            lastRunErrorMessage(model.lastRunErrorMessage);
            lastRunStatus(model.lastRunStatus);
            name(model.name);
            projectId(model.projectId);
            publishOnImport(model.publishOnImport);
            recommendation(model.recommendation);
            schedule(model.schedule);
            status(model.status);
            type(model.type);
            updatedAt(model.updatedAt);
        }

        public final List<FormOutput.Builder> getAssetFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.assetFormsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetFormsOutput(Collection<FormOutput.BuilderImpl> assetFormsOutput) {
            this.assetFormsOutput = FormOutputListCopier.copyFromBuilder(assetFormsOutput);
        }

        @Override
        public final Builder assetFormsOutput(Collection<FormOutput> assetFormsOutput) {
            this.assetFormsOutput = FormOutputListCopier.copy(assetFormsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsOutput(FormOutput... assetFormsOutput) {
            assetFormsOutput(Arrays.asList(assetFormsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsOutput(Consumer<FormOutput.Builder>... assetFormsOutput) {
            assetFormsOutput(Stream.of(assetFormsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DataSourceConfigurationOutput.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfigurationOutput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfigurationOutput configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnableSetting() {
            return enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final DataSourceErrorMessage.Builder getErrorMessage() {
            return errorMessage != null ? errorMessage.toBuilder() : null;
        }

        public final void setErrorMessage(DataSourceErrorMessage.BuilderImpl errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage.build() : null;
        }

        @Override
        public final Builder errorMessage(DataSourceErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastRunAt() {
            return lastRunAt;
        }

        public final void setLastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
        }

        @Override
        public final Builder lastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
            return this;
        }

        public final DataSourceErrorMessage.Builder getLastRunErrorMessage() {
            return lastRunErrorMessage != null ? lastRunErrorMessage.toBuilder() : null;
        }

        public final void setLastRunErrorMessage(DataSourceErrorMessage.BuilderImpl lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage != null ? lastRunErrorMessage.build() : null;
        }

        @Override
        public final Builder lastRunErrorMessage(DataSourceErrorMessage lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage;
            return this;
        }

        public final String getLastRunStatus() {
            return lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        @Override
        public final Builder lastRunStatus(DataSourceRunStatus lastRunStatus) {
            this.lastRunStatus(lastRunStatus == null ? null : lastRunStatus.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final Boolean getPublishOnImport() {
            return publishOnImport;
        }

        public final void setPublishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
        }

        @Override
        public final Builder publishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        public final RecommendationConfiguration.Builder getRecommendation() {
            return recommendation != null ? recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationConfiguration.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationConfiguration recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CreateDataSourceResponse build() {
            return new CreateDataSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
