/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateDomainResponse.Builder, CreateDomainResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateDomainResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateDomainResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainExecutionRole").getter(getter(CreateDomainResponse::domainExecutionRole))
            .setter(setter(Builder::domainExecutionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainExecutionRole").build())
            .build();

    private static final SdkField<String> DOMAIN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainVersion").getter(getter(CreateDomainResponse::domainVersionAsString))
            .setter(setter(Builder::domainVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVersion").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateDomainResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(CreateDomainResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateDomainResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PORTAL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalUrl").getter(getter(CreateDomainResponse::portalUrl)).setter(setter(Builder::portalUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalUrl").build()).build();

    private static final SdkField<String> ROOT_DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootDomainUnitId").getter(getter(CreateDomainResponse::rootDomainUnitId))
            .setter(setter(Builder::rootDomainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootDomainUnitId").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceRole").getter(getter(CreateDomainResponse::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()).build();

    private static final SdkField<SingleSignOn> SINGLE_SIGN_ON_FIELD = SdkField.<SingleSignOn> builder(MarshallingType.SDK_POJO)
            .memberName("singleSignOn").getter(getter(CreateDomainResponse::singleSignOn)).setter(setter(Builder::singleSignOn))
            .constructor(SingleSignOn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("singleSignOn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateDomainResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDomainResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD,
            DOMAIN_EXECUTION_ROLE_FIELD, DOMAIN_VERSION_FIELD, ID_FIELD, KMS_KEY_IDENTIFIER_FIELD, NAME_FIELD, PORTAL_URL_FIELD,
            ROOT_DOMAIN_UNIT_ID_FIELD, SERVICE_ROLE_FIELD, SINGLE_SIGN_ON_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("arn", ARN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainExecutionRole", DOMAIN_EXECUTION_ROLE_FIELD);
                    put("domainVersion", DOMAIN_VERSION_FIELD);
                    put("id", ID_FIELD);
                    put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
                    put("name", NAME_FIELD);
                    put("portalUrl", PORTAL_URL_FIELD);
                    put("rootDomainUnitId", ROOT_DOMAIN_UNIT_ID_FIELD);
                    put("serviceRole", SERVICE_ROLE_FIELD);
                    put("singleSignOn", SINGLE_SIGN_ON_FIELD);
                    put("status", STATUS_FIELD);
                    put("tags", TAGS_FIELD);
                }
            });

    private final String arn;

    private final String description;

    private final String domainExecutionRole;

    private final String domainVersion;

    private final String id;

    private final String kmsKeyIdentifier;

    private final String name;

    private final String portalUrl;

    private final String rootDomainUnitId;

    private final String serviceRole;

    private final SingleSignOn singleSignOn;

    private final String status;

    private final Map<String, String> tags;

    private CreateDomainResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.description = builder.description;
        this.domainExecutionRole = builder.domainExecutionRole;
        this.domainVersion = builder.domainVersion;
        this.id = builder.id;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.name = builder.name;
        this.portalUrl = builder.portalUrl;
        this.rootDomainUnitId = builder.rootDomainUnitId;
        this.serviceRole = builder.serviceRole;
        this.singleSignOn = builder.singleSignOn;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the Amazon DataZone domain.
     * </p>
     * 
     * @return The ARN of the Amazon DataZone domain.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The description of the Amazon DataZone domain.
     * </p>
     * 
     * @return The description of the Amazon DataZone domain.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The domain execution role that is created when an Amazon DataZone domain is created. The domain execution role is
     * created in the Amazon Web Services account that houses the Amazon DataZone domain.
     * </p>
     * 
     * @return The domain execution role that is created when an Amazon DataZone domain is created. The domain execution
     *         role is created in the Amazon Web Services account that houses the Amazon DataZone domain.
     */
    public final String domainExecutionRole() {
        return domainExecutionRole;
    }

    /**
     * <p>
     * The version of the domain that is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainVersion}
     * will return {@link DomainVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainVersionAsString}.
     * </p>
     * 
     * @return The version of the domain that is created.
     * @see DomainVersion
     */
    public final DomainVersion domainVersion() {
        return DomainVersion.fromValue(domainVersion);
    }

    /**
     * <p>
     * The version of the domain that is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainVersion}
     * will return {@link DomainVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainVersionAsString}.
     * </p>
     * 
     * @return The version of the domain that is created.
     * @see DomainVersion
     */
    public final String domainVersionAsString() {
        return domainVersion;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the Amazon
     * DataZone domain, metadata, and reporting data.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the
     *         Amazon DataZone domain, metadata, and reporting data.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * The name of the Amazon DataZone domain.
     * </p>
     * 
     * @return The name of the Amazon DataZone domain.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The URL of the data portal for this Amazon DataZone domain.
     * </p>
     * 
     * @return The URL of the data portal for this Amazon DataZone domain.
     */
    public final String portalUrl() {
        return portalUrl;
    }

    /**
     * <p>
     * The ID of the root domain unit.
     * </p>
     * 
     * @return The ID of the root domain unit.
     */
    public final String rootDomainUnitId() {
        return rootDomainUnitId;
    }

    /**
     * <p>
     * Te service role of the domain that is created.
     * </p>
     * 
     * @return Te service role of the domain that is created.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The single-sign on configuration of the Amazon DataZone domain.
     * </p>
     * 
     * @return The single-sign on configuration of the Amazon DataZone domain.
     */
    public final SingleSignOn singleSignOn() {
        return singleSignOn;
    }

    /**
     * <p>
     * The status of the Amazon DataZone domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon DataZone domain.
     * @see DomainStatus
     */
    public final DomainStatus status() {
        return DomainStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon DataZone domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DomainStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon DataZone domain.
     * @see DomainStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags specified for the Amazon DataZone domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags specified for the Amazon DataZone domain.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainExecutionRole());
        hashCode = 31 * hashCode + Objects.hashCode(domainVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(portalUrl());
        hashCode = 31 * hashCode + Objects.hashCode(rootDomainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(singleSignOn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainResponse)) {
            return false;
        }
        CreateDomainResponse other = (CreateDomainResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(description(), other.description())
                && Objects.equals(domainExecutionRole(), other.domainExecutionRole())
                && Objects.equals(domainVersionAsString(), other.domainVersionAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(portalUrl(), other.portalUrl()) && Objects.equals(rootDomainUnitId(), other.rootDomainUnitId())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(singleSignOn(), other.singleSignOn())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDomainResponse").add("Arn", arn()).add("Description", description())
                .add("DomainExecutionRole", domainExecutionRole()).add("DomainVersion", domainVersionAsString()).add("Id", id())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).add("Name", name()).add("PortalUrl", portalUrl())
                .add("RootDomainUnitId", rootDomainUnitId()).add("ServiceRole", serviceRole())
                .add("SingleSignOn", singleSignOn()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainExecutionRole":
            return Optional.ofNullable(clazz.cast(domainExecutionRole()));
        case "domainVersion":
            return Optional.ofNullable(clazz.cast(domainVersionAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "portalUrl":
            return Optional.ofNullable(clazz.cast(portalUrl()));
        case "rootDomainUnitId":
            return Optional.ofNullable(clazz.cast(rootDomainUnitId()));
        case "serviceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "singleSignOn":
            return Optional.ofNullable(clazz.cast(singleSignOn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainResponse, T> g) {
        return obj -> g.apply((CreateDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainResponse> {
        /**
         * <p>
         * The ARN of the Amazon DataZone domain.
         * </p>
         * 
         * @param arn
         *        The ARN of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The description of the Amazon DataZone domain.
         * </p>
         * 
         * @param description
         *        The description of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The domain execution role that is created when an Amazon DataZone domain is created. The domain execution
         * role is created in the Amazon Web Services account that houses the Amazon DataZone domain.
         * </p>
         * 
         * @param domainExecutionRole
         *        The domain execution role that is created when an Amazon DataZone domain is created. The domain
         *        execution role is created in the Amazon Web Services account that houses the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainExecutionRole(String domainExecutionRole);

        /**
         * <p>
         * The version of the domain that is created.
         * </p>
         * 
         * @param domainVersion
         *        The version of the domain that is created.
         * @see DomainVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainVersion
         */
        Builder domainVersion(String domainVersion);

        /**
         * <p>
         * The version of the domain that is created.
         * </p>
         * 
         * @param domainVersion
         *        The version of the domain that is created.
         * @see DomainVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainVersion
         */
        Builder domainVersion(DomainVersion domainVersion);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain.
         * </p>
         * 
         * @param id
         *        The identifier of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the Amazon
         * DataZone domain, metadata, and reporting data.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The identifier of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt the
         *        Amazon DataZone domain, metadata, and reporting data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * The name of the Amazon DataZone domain.
         * </p>
         * 
         * @param name
         *        The name of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The URL of the data portal for this Amazon DataZone domain.
         * </p>
         * 
         * @param portalUrl
         *        The URL of the data portal for this Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalUrl(String portalUrl);

        /**
         * <p>
         * The ID of the root domain unit.
         * </p>
         * 
         * @param rootDomainUnitId
         *        The ID of the root domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDomainUnitId(String rootDomainUnitId);

        /**
         * <p>
         * Te service role of the domain that is created.
         * </p>
         * 
         * @param serviceRole
         *        Te service role of the domain that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The single-sign on configuration of the Amazon DataZone domain.
         * </p>
         * 
         * @param singleSignOn
         *        The single-sign on configuration of the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleSignOn(SingleSignOn singleSignOn);

        /**
         * <p>
         * The single-sign on configuration of the Amazon DataZone domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link SingleSignOn.Builder} avoiding the need
         * to create one manually via {@link SingleSignOn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SingleSignOn.Builder#build()} is called immediately and its
         * result is passed to {@link #singleSignOn(SingleSignOn)}.
         * 
         * @param singleSignOn
         *        a consumer that will call methods on {@link SingleSignOn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleSignOn(SingleSignOn)
         */
        default Builder singleSignOn(Consumer<SingleSignOn.Builder> singleSignOn) {
            return singleSignOn(SingleSignOn.builder().applyMutation(singleSignOn).build());
        }

        /**
         * <p>
         * The status of the Amazon DataZone domain.
         * </p>
         * 
         * @param status
         *        The status of the Amazon DataZone domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon DataZone domain.
         * </p>
         * 
         * @param status
         *        The status of the Amazon DataZone domain.
         * @see DomainStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainStatus
         */
        Builder status(DomainStatus status);

        /**
         * <p>
         * The tags specified for the Amazon DataZone domain.
         * </p>
         * 
         * @param tags
         *        The tags specified for the Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String arn;

        private String description;

        private String domainExecutionRole;

        private String domainVersion;

        private String id;

        private String kmsKeyIdentifier;

        private String name;

        private String portalUrl;

        private String rootDomainUnitId;

        private String serviceRole;

        private SingleSignOn singleSignOn;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainResponse model) {
            super(model);
            arn(model.arn);
            description(model.description);
            domainExecutionRole(model.domainExecutionRole);
            domainVersion(model.domainVersion);
            id(model.id);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            name(model.name);
            portalUrl(model.portalUrl);
            rootDomainUnitId(model.rootDomainUnitId);
            serviceRole(model.serviceRole);
            singleSignOn(model.singleSignOn);
            status(model.status);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainExecutionRole() {
            return domainExecutionRole;
        }

        public final void setDomainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
        }

        @Override
        public final Builder domainExecutionRole(String domainExecutionRole) {
            this.domainExecutionRole = domainExecutionRole;
            return this;
        }

        public final String getDomainVersion() {
            return domainVersion;
        }

        public final void setDomainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
        }

        @Override
        public final Builder domainVersion(String domainVersion) {
            this.domainVersion = domainVersion;
            return this;
        }

        @Override
        public final Builder domainVersion(DomainVersion domainVersion) {
            this.domainVersion(domainVersion == null ? null : domainVersion.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPortalUrl() {
            return portalUrl;
        }

        public final void setPortalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
        }

        @Override
        public final Builder portalUrl(String portalUrl) {
            this.portalUrl = portalUrl;
            return this;
        }

        public final String getRootDomainUnitId() {
            return rootDomainUnitId;
        }

        public final void setRootDomainUnitId(String rootDomainUnitId) {
            this.rootDomainUnitId = rootDomainUnitId;
        }

        @Override
        public final Builder rootDomainUnitId(String rootDomainUnitId) {
            this.rootDomainUnitId = rootDomainUnitId;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final SingleSignOn.Builder getSingleSignOn() {
            return singleSignOn != null ? singleSignOn.toBuilder() : null;
        }

        public final void setSingleSignOn(SingleSignOn.BuilderImpl singleSignOn) {
            this.singleSignOn = singleSignOn != null ? singleSignOn.build() : null;
        }

        @Override
        public final Builder singleSignOn(SingleSignOn singleSignOn) {
            this.singleSignOn = singleSignOn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public CreateDomainResponse build() {
            return new CreateDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
