/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateEnvironmentRequest.Builder, CreateEnvironmentRequest> {
    private static final SdkField<Integer> DEPLOYMENT_ORDER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("deploymentOrder").getter(getter(CreateEnvironmentRequest::deploymentOrder))
            .setter(setter(Builder::deploymentOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOrder").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateEnvironmentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateEnvironmentRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountIdentifier")
            .getter(getter(CreateEnvironmentRequest::environmentAccountIdentifier))
            .setter(setter(Builder::environmentAccountIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountIdentifier")
                    .build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountRegion").getter(getter(CreateEnvironmentRequest::environmentAccountRegion))
            .setter(setter(Builder::environmentAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountRegion").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintIdentifier")
            .getter(getter(CreateEnvironmentRequest::environmentBlueprintIdentifier))
            .setter(setter(Builder::environmentBlueprintIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintIdentifier")
                    .build()).build();

    private static final SdkField<String> ENVIRONMENT_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentConfigurationId")
            .getter(getter(CreateEnvironmentRequest::environmentConfigurationId))
            .setter(setter(Builder::environmentConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurationId").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_PROFILE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("environmentProfileIdentifier")
            .getter(getter(CreateEnvironmentRequest::environmentProfileIdentifier))
            .setter(setter(Builder::environmentProfileIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentProfileIdentifier")
                    .build()).build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(CreateEnvironmentRequest::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateEnvironmentRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectIdentifier").getter(getter(CreateEnvironmentRequest::projectIdentifier))
            .setter(setter(Builder::projectIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()).build();

    private static final SdkField<List<EnvironmentParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(CreateEnvironmentRequest::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ORDER_FIELD,
            DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_ACCOUNT_IDENTIFIER_FIELD, ENVIRONMENT_ACCOUNT_REGION_FIELD,
            ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD, ENVIRONMENT_CONFIGURATION_ID_FIELD, ENVIRONMENT_PROFILE_IDENTIFIER_FIELD,
            GLOSSARY_TERMS_FIELD, NAME_FIELD, PROJECT_IDENTIFIER_FIELD, USER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("deploymentOrder", DEPLOYMENT_ORDER_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("environmentAccountIdentifier", ENVIRONMENT_ACCOUNT_IDENTIFIER_FIELD);
                    put("environmentAccountRegion", ENVIRONMENT_ACCOUNT_REGION_FIELD);
                    put("environmentBlueprintIdentifier", ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD);
                    put("environmentConfigurationId", ENVIRONMENT_CONFIGURATION_ID_FIELD);
                    put("environmentProfileIdentifier", ENVIRONMENT_PROFILE_IDENTIFIER_FIELD);
                    put("glossaryTerms", GLOSSARY_TERMS_FIELD);
                    put("name", NAME_FIELD);
                    put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
                    put("userParameters", USER_PARAMETERS_FIELD);
                }
            });

    private final Integer deploymentOrder;

    private final String description;

    private final String domainIdentifier;

    private final String environmentAccountIdentifier;

    private final String environmentAccountRegion;

    private final String environmentBlueprintIdentifier;

    private final String environmentConfigurationId;

    private final String environmentProfileIdentifier;

    private final List<String> glossaryTerms;

    private final String name;

    private final String projectIdentifier;

    private final List<EnvironmentParameter> userParameters;

    private CreateEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentOrder = builder.deploymentOrder;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentAccountIdentifier = builder.environmentAccountIdentifier;
        this.environmentAccountRegion = builder.environmentAccountRegion;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.environmentConfigurationId = builder.environmentConfigurationId;
        this.environmentProfileIdentifier = builder.environmentProfileIdentifier;
        this.glossaryTerms = builder.glossaryTerms;
        this.name = builder.name;
        this.projectIdentifier = builder.projectIdentifier;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The deployment order of the environment.
     * </p>
     * 
     * @return The deployment order of the environment.
     */
    public final Integer deploymentOrder() {
        return deploymentOrder;
    }

    /**
     * <p>
     * The description of the Amazon DataZone environment.
     * </p>
     * 
     * @return The description of the Amazon DataZone environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone domain in which the environment is created.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone domain in which the environment is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The ID of the account in which the environment is being created.
     * </p>
     * 
     * @return The ID of the account in which the environment is being created.
     */
    public final String environmentAccountIdentifier() {
        return environmentAccountIdentifier;
    }

    /**
     * <p>
     * The region of the account in which the environment is being created.
     * </p>
     * 
     * @return The region of the account in which the environment is being created.
     */
    public final String environmentAccountRegion() {
        return environmentAccountRegion;
    }

    /**
     * <p>
     * The ID of the blueprint with which the environment is being created.
     * </p>
     * 
     * @return The ID of the blueprint with which the environment is being created.
     */
    public final String environmentBlueprintIdentifier() {
        return environmentBlueprintIdentifier;
    }

    /**
     * <p>
     * The configuration ID of the environment.
     * </p>
     * 
     * @return The configuration ID of the environment.
     */
    public final String environmentConfigurationId() {
        return environmentConfigurationId;
    }

    /**
     * <p>
     * The identifier of the environment profile that is used to create this Amazon DataZone environment.
     * </p>
     * 
     * @return The identifier of the environment profile that is used to create this Amazon DataZone environment.
     */
    public final String environmentProfileIdentifier() {
        return environmentProfileIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The glossary terms that can be used in this Amazon DataZone environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The glossary terms that can be used in this Amazon DataZone environment.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The name of the Amazon DataZone environment.
     * </p>
     * 
     * @return The name of the Amazon DataZone environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The identifier of the Amazon DataZone project in which this environment is created.
     * </p>
     * 
     * @return The identifier of the Amazon DataZone project in which this environment is created.
     */
    public final String projectIdentifier() {
        return projectIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of this Amazon DataZone environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of this Amazon DataZone environment.
     */
    public final List<EnvironmentParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentOrder());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(environmentConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentRequest)) {
            return false;
        }
        CreateEnvironmentRequest other = (CreateEnvironmentRequest) obj;
        return Objects.equals(deploymentOrder(), other.deploymentOrder()) && Objects.equals(description(), other.description())
                && Objects.equals(domainIdentifier(), other.domainIdentifier())
                && Objects.equals(environmentAccountIdentifier(), other.environmentAccountIdentifier())
                && Objects.equals(environmentAccountRegion(), other.environmentAccountRegion())
                && Objects.equals(environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier())
                && Objects.equals(environmentConfigurationId(), other.environmentConfigurationId())
                && Objects.equals(environmentProfileIdentifier(), other.environmentProfileIdentifier())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(name(), other.name()) && Objects.equals(projectIdentifier(), other.projectIdentifier())
                && hasUserParameters() == other.hasUserParameters() && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentRequest").add("DeploymentOrder", deploymentOrder())
                .add("Description", description()).add("DomainIdentifier", domainIdentifier())
                .add("EnvironmentAccountIdentifier", environmentAccountIdentifier())
                .add("EnvironmentAccountRegion", environmentAccountRegion())
                .add("EnvironmentBlueprintIdentifier", environmentBlueprintIdentifier())
                .add("EnvironmentConfigurationId", environmentConfigurationId())
                .add("EnvironmentProfileIdentifier", environmentProfileIdentifier())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Name", name())
                .add("ProjectIdentifier", projectIdentifier())
                .add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentOrder":
            return Optional.ofNullable(clazz.cast(deploymentOrder()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "environmentAccountIdentifier":
            return Optional.ofNullable(clazz.cast(environmentAccountIdentifier()));
        case "environmentAccountRegion":
            return Optional.ofNullable(clazz.cast(environmentAccountRegion()));
        case "environmentBlueprintIdentifier":
            return Optional.ofNullable(clazz.cast(environmentBlueprintIdentifier()));
        case "environmentConfigurationId":
            return Optional.ofNullable(clazz.cast(environmentConfigurationId()));
        case "environmentProfileIdentifier":
            return Optional.ofNullable(clazz.cast(environmentProfileIdentifier()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectIdentifier":
            return Optional.ofNullable(clazz.cast(projectIdentifier()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEnvironmentRequest> {
        /**
         * <p>
         * The deployment order of the environment.
         * </p>
         * 
         * @param deploymentOrder
         *        The deployment order of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentOrder(Integer deploymentOrder);

        /**
         * <p>
         * The description of the Amazon DataZone environment.
         * </p>
         * 
         * @param description
         *        The description of the Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the Amazon DataZone domain in which the environment is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The identifier of the Amazon DataZone domain in which the environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The ID of the account in which the environment is being created.
         * </p>
         * 
         * @param environmentAccountIdentifier
         *        The ID of the account in which the environment is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountIdentifier(String environmentAccountIdentifier);

        /**
         * <p>
         * The region of the account in which the environment is being created.
         * </p>
         * 
         * @param environmentAccountRegion
         *        The region of the account in which the environment is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountRegion(String environmentAccountRegion);

        /**
         * <p>
         * The ID of the blueprint with which the environment is being created.
         * </p>
         * 
         * @param environmentBlueprintIdentifier
         *        The ID of the blueprint with which the environment is being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier);

        /**
         * <p>
         * The configuration ID of the environment.
         * </p>
         * 
         * @param environmentConfigurationId
         *        The configuration ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentConfigurationId(String environmentConfigurationId);

        /**
         * <p>
         * The identifier of the environment profile that is used to create this Amazon DataZone environment.
         * </p>
         * 
         * @param environmentProfileIdentifier
         *        The identifier of the environment profile that is used to create this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentProfileIdentifier(String environmentProfileIdentifier);

        /**
         * <p>
         * The glossary terms that can be used in this Amazon DataZone environment.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms that can be used in this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The glossary terms that can be used in this Amazon DataZone environment.
         * </p>
         * 
         * @param glossaryTerms
         *        The glossary terms that can be used in this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The name of the Amazon DataZone environment.
         * </p>
         * 
         * @param name
         *        The name of the Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The identifier of the Amazon DataZone project in which this environment is created.
         * </p>
         * 
         * @param projectIdentifier
         *        The identifier of the Amazon DataZone project in which this environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectIdentifier(String projectIdentifier);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<EnvironmentParameter> userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(EnvironmentParameter... userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #userParameters(List<EnvironmentParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<EnvironmentParameter>)
         */
        Builder userParameters(Consumer<EnvironmentParameter.Builder>... userParameters);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private Integer deploymentOrder;

        private String description;

        private String domainIdentifier;

        private String environmentAccountIdentifier;

        private String environmentAccountRegion;

        private String environmentBlueprintIdentifier;

        private String environmentConfigurationId;

        private String environmentProfileIdentifier;

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String projectIdentifier;

        private List<EnvironmentParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentRequest model) {
            super(model);
            deploymentOrder(model.deploymentOrder);
            description(model.description);
            domainIdentifier(model.domainIdentifier);
            environmentAccountIdentifier(model.environmentAccountIdentifier);
            environmentAccountRegion(model.environmentAccountRegion);
            environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            environmentConfigurationId(model.environmentConfigurationId);
            environmentProfileIdentifier(model.environmentProfileIdentifier);
            glossaryTerms(model.glossaryTerms);
            name(model.name);
            projectIdentifier(model.projectIdentifier);
            userParameters(model.userParameters);
        }

        public final Integer getDeploymentOrder() {
            return deploymentOrder;
        }

        public final void setDeploymentOrder(Integer deploymentOrder) {
            this.deploymentOrder = deploymentOrder;
        }

        @Override
        public final Builder deploymentOrder(Integer deploymentOrder) {
            this.deploymentOrder = deploymentOrder;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentAccountIdentifier() {
            return environmentAccountIdentifier;
        }

        public final void setEnvironmentAccountIdentifier(String environmentAccountIdentifier) {
            this.environmentAccountIdentifier = environmentAccountIdentifier;
        }

        @Override
        public final Builder environmentAccountIdentifier(String environmentAccountIdentifier) {
            this.environmentAccountIdentifier = environmentAccountIdentifier;
            return this;
        }

        public final String getEnvironmentAccountRegion() {
            return environmentAccountRegion;
        }

        public final void setEnvironmentAccountRegion(String environmentAccountRegion) {
            this.environmentAccountRegion = environmentAccountRegion;
        }

        @Override
        public final Builder environmentAccountRegion(String environmentAccountRegion) {
            this.environmentAccountRegion = environmentAccountRegion;
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final String getEnvironmentConfigurationId() {
            return environmentConfigurationId;
        }

        public final void setEnvironmentConfigurationId(String environmentConfigurationId) {
            this.environmentConfigurationId = environmentConfigurationId;
        }

        @Override
        public final Builder environmentConfigurationId(String environmentConfigurationId) {
            this.environmentConfigurationId = environmentConfigurationId;
            return this;
        }

        public final String getEnvironmentProfileIdentifier() {
            return environmentProfileIdentifier;
        }

        public final void setEnvironmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
        }

        @Override
        public final Builder environmentProfileIdentifier(String environmentProfileIdentifier) {
            this.environmentProfileIdentifier = environmentProfileIdentifier;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectIdentifier() {
            return projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getUserParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<EnvironmentParameter.BuilderImpl> userParameters) {
            this.userParameters = EnvironmentParametersListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<EnvironmentParameter> userParameters) {
            this.userParameters = EnvironmentParametersListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(EnvironmentParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<EnvironmentParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters).map(c -> EnvironmentParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEnvironmentRequest build() {
            return new CreateEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
