/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFormTypeResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateFormTypeResponse.Builder, CreateFormTypeResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFormTypeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateFormTypeResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFormTypeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ORIGIN_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originDomainId").getter(getter(CreateFormTypeResponse::originDomainId))
            .setter(setter(Builder::originDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originDomainId").build()).build();

    private static final SdkField<String> ORIGIN_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originProjectId").getter(getter(CreateFormTypeResponse::originProjectId))
            .setter(setter(Builder::originProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originProjectId").build()).build();

    private static final SdkField<String> OWNING_PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("owningProjectId").getter(getter(CreateFormTypeResponse::owningProjectId))
            .setter(setter(Builder::owningProjectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectId").build()).build();

    private static final SdkField<String> REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revision").getter(getter(CreateFormTypeResponse::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DESCRIPTION_FIELD, DOMAIN_ID_FIELD, NAME_FIELD, ORIGIN_DOMAIN_ID_FIELD, ORIGIN_PROJECT_ID_FIELD,
                    OWNING_PROJECT_ID_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("description", DESCRIPTION_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("name", NAME_FIELD);
                    put("originDomainId", ORIGIN_DOMAIN_ID_FIELD);
                    put("originProjectId", ORIGIN_PROJECT_ID_FIELD);
                    put("owningProjectId", OWNING_PROJECT_ID_FIELD);
                    put("revision", REVISION_FIELD);
                }
            });

    private final String description;

    private final String domainId;

    private final String name;

    private final String originDomainId;

    private final String originProjectId;

    private final String owningProjectId;

    private final String revision;

    private CreateFormTypeResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.name = builder.name;
        this.originDomainId = builder.originDomainId;
        this.originProjectId = builder.originProjectId;
        this.owningProjectId = builder.owningProjectId;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * The description of this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The description of this Amazon DataZone metadata form type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this metadata form type is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this metadata form type is created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The name of this Amazon DataZone metadata form type.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this metadata form type was originally created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this metadata form type was originally created.
     */
    public final String originDomainId() {
        return originDomainId;
    }

    /**
     * <p>
     * The ID of the project in which this Amazon DataZone metadata form type was originally created.
     * </p>
     * 
     * @return The ID of the project in which this Amazon DataZone metadata form type was originally created.
     */
    public final String originProjectId() {
        return originProjectId;
    }

    /**
     * <p>
     * The ID of the project that owns this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The ID of the project that owns this Amazon DataZone metadata form type.
     */
    public final String owningProjectId() {
        return owningProjectId;
    }

    /**
     * <p>
     * The revision of this Amazon DataZone metadata form type.
     * </p>
     * 
     * @return The revision of this Amazon DataZone metadata form type.
     */
    public final String revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(originDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(originProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(owningProjectId());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFormTypeResponse)) {
            return false;
        }
        CreateFormTypeResponse other = (CreateFormTypeResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(name(), other.name()) && Objects.equals(originDomainId(), other.originDomainId())
                && Objects.equals(originProjectId(), other.originProjectId())
                && Objects.equals(owningProjectId(), other.owningProjectId()) && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFormTypeResponse")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("OriginDomainId", originDomainId())
                .add("OriginProjectId", originProjectId()).add("OwningProjectId", owningProjectId()).add("Revision", revision())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "originDomainId":
            return Optional.ofNullable(clazz.cast(originDomainId()));
        case "originProjectId":
            return Optional.ofNullable(clazz.cast(originProjectId()));
        case "owningProjectId":
            return Optional.ofNullable(clazz.cast(owningProjectId()));
        case "revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateFormTypeResponse, T> g) {
        return obj -> g.apply((CreateFormTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFormTypeResponse> {
        /**
         * <p>
         * The description of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param description
         *        The description of this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this metadata form type is created.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which this metadata form type is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param name
         *        The name of this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this metadata form type was originally created.
         * </p>
         * 
         * @param originDomainId
         *        The ID of the Amazon DataZone domain in which this metadata form type was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originDomainId(String originDomainId);

        /**
         * <p>
         * The ID of the project in which this Amazon DataZone metadata form type was originally created.
         * </p>
         * 
         * @param originProjectId
         *        The ID of the project in which this Amazon DataZone metadata form type was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originProjectId(String originProjectId);

        /**
         * <p>
         * The ID of the project that owns this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param owningProjectId
         *        The ID of the project that owns this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owningProjectId(String owningProjectId);

        /**
         * <p>
         * The revision of this Amazon DataZone metadata form type.
         * </p>
         * 
         * @param revision
         *        The revision of this Amazon DataZone metadata form type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(String revision);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String description;

        private String domainId;

        private String name;

        private String originDomainId;

        private String originProjectId;

        private String owningProjectId;

        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFormTypeResponse model) {
            super(model);
            description(model.description);
            domainId(model.domainId);
            name(model.name);
            originDomainId(model.originDomainId);
            originProjectId(model.originProjectId);
            owningProjectId(model.owningProjectId);
            revision(model.revision);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOriginDomainId() {
            return originDomainId;
        }

        public final void setOriginDomainId(String originDomainId) {
            this.originDomainId = originDomainId;
        }

        @Override
        public final Builder originDomainId(String originDomainId) {
            this.originDomainId = originDomainId;
            return this;
        }

        public final String getOriginProjectId() {
            return originProjectId;
        }

        public final void setOriginProjectId(String originProjectId) {
            this.originProjectId = originProjectId;
        }

        @Override
        public final Builder originProjectId(String originProjectId) {
            this.originProjectId = originProjectId;
            return this;
        }

        public final String getOwningProjectId() {
            return owningProjectId;
        }

        public final void setOwningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
        }

        @Override
        public final Builder owningProjectId(String owningProjectId) {
            this.owningProjectId = owningProjectId;
            return this;
        }

        public final String getRevision() {
            return revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public CreateFormTypeResponse build() {
            return new CreateFormTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
