/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGlossaryTermResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateGlossaryTermResponse.Builder, CreateGlossaryTermResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateGlossaryTermResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> GLOSSARY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glossaryId").getter(getter(CreateGlossaryTermResponse::glossaryId)).setter(setter(Builder::glossaryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateGlossaryTermResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> LONG_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("longDescription").getter(getter(CreateGlossaryTermResponse::longDescription))
            .setter(setter(Builder::longDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longDescription").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGlossaryTermResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortDescription").getter(getter(CreateGlossaryTermResponse::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGlossaryTermResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TermRelations> TERM_RELATIONS_FIELD = SdkField
            .<TermRelations> builder(MarshallingType.SDK_POJO).memberName("termRelations")
            .getter(getter(CreateGlossaryTermResponse::termRelations)).setter(setter(Builder::termRelations))
            .constructor(TermRelations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termRelations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            GLOSSARY_ID_FIELD, ID_FIELD, LONG_DESCRIPTION_FIELD, NAME_FIELD, SHORT_DESCRIPTION_FIELD, STATUS_FIELD,
            TERM_RELATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainId", DOMAIN_ID_FIELD);
                    put("glossaryId", GLOSSARY_ID_FIELD);
                    put("id", ID_FIELD);
                    put("longDescription", LONG_DESCRIPTION_FIELD);
                    put("name", NAME_FIELD);
                    put("shortDescription", SHORT_DESCRIPTION_FIELD);
                    put("status", STATUS_FIELD);
                    put("termRelations", TERM_RELATIONS_FIELD);
                }
            });

    private final String domainId;

    private final String glossaryId;

    private final String id;

    private final String longDescription;

    private final String name;

    private final String shortDescription;

    private final String status;

    private final TermRelations termRelations;

    private CreateGlossaryTermResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.glossaryId = builder.glossaryId;
        this.id = builder.id;
        this.longDescription = builder.longDescription;
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
        this.status = builder.status;
        this.termRelations = builder.termRelations;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain in which this business glossary term is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain in which this business glossary term is created.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the business glossary in which this term is created.
     * </p>
     * 
     * @return The ID of the business glossary in which this term is created.
     */
    public final String glossaryId() {
        return glossaryId;
    }

    /**
     * <p>
     * The ID of this business glossary term.
     * </p>
     * 
     * @return The ID of this business glossary term.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The long description of this business glossary term.
     * </p>
     * 
     * @return The long description of this business glossary term.
     */
    public final String longDescription() {
        return longDescription;
    }

    /**
     * <p>
     * The name of this business glossary term.
     * </p>
     * 
     * @return The name of this business glossary term.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The short description of this business glossary term.
     * </p>
     * 
     * @return The short description of this business glossary term.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    /**
     * <p>
     * The status of this business glossary term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryTermStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary term.
     * @see GlossaryTermStatus
     */
    public final GlossaryTermStatus status() {
        return GlossaryTermStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this business glossary term.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GlossaryTermStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this business glossary term.
     * @see GlossaryTermStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The term relations of this business glossary term.
     * </p>
     * 
     * @return The term relations of this business glossary term.
     */
    public final TermRelations termRelations() {
        return termRelations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(glossaryId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(longDescription());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termRelations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlossaryTermResponse)) {
            return false;
        }
        CreateGlossaryTermResponse other = (CreateGlossaryTermResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(glossaryId(), other.glossaryId())
                && Objects.equals(id(), other.id()) && Objects.equals(longDescription(), other.longDescription())
                && Objects.equals(name(), other.name()) && Objects.equals(shortDescription(), other.shortDescription())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(termRelations(), other.termRelations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGlossaryTermResponse").add("DomainId", domainId()).add("GlossaryId", glossaryId())
                .add("Id", id()).add("LongDescription", longDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShortDescription", shortDescription() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("TermRelations", termRelations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "glossaryId":
            return Optional.ofNullable(clazz.cast(glossaryId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "longDescription":
            return Optional.ofNullable(clazz.cast(longDescription()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "shortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "termRelations":
            return Optional.ofNullable(clazz.cast(termRelations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGlossaryTermResponse, T> g) {
        return obj -> g.apply((CreateGlossaryTermResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGlossaryTermResponse> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain in which this business glossary term is created.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain in which this business glossary term is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the business glossary in which this term is created.
         * </p>
         * 
         * @param glossaryId
         *        The ID of the business glossary in which this term is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryId(String glossaryId);

        /**
         * <p>
         * The ID of this business glossary term.
         * </p>
         * 
         * @param id
         *        The ID of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The long description of this business glossary term.
         * </p>
         * 
         * @param longDescription
         *        The long description of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longDescription(String longDescription);

        /**
         * <p>
         * The name of this business glossary term.
         * </p>
         * 
         * @param name
         *        The name of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The short description of this business glossary term.
         * </p>
         * 
         * @param shortDescription
         *        The short description of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);

        /**
         * <p>
         * The status of this business glossary term.
         * </p>
         * 
         * @param status
         *        The status of this business glossary term.
         * @see GlossaryTermStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryTermStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this business glossary term.
         * </p>
         * 
         * @param status
         *        The status of this business glossary term.
         * @see GlossaryTermStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlossaryTermStatus
         */
        Builder status(GlossaryTermStatus status);

        /**
         * <p>
         * The term relations of this business glossary term.
         * </p>
         * 
         * @param termRelations
         *        The term relations of this business glossary term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termRelations(TermRelations termRelations);

        /**
         * <p>
         * The term relations of this business glossary term.
         * </p>
         * This is a convenience method that creates an instance of the {@link TermRelations.Builder} avoiding the need
         * to create one manually via {@link TermRelations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TermRelations.Builder#build()} is called immediately and its
         * result is passed to {@link #termRelations(TermRelations)}.
         * 
         * @param termRelations
         *        a consumer that will call methods on {@link TermRelations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termRelations(TermRelations)
         */
        default Builder termRelations(Consumer<TermRelations.Builder> termRelations) {
            return termRelations(TermRelations.builder().applyMutation(termRelations).build());
        }
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String domainId;

        private String glossaryId;

        private String id;

        private String longDescription;

        private String name;

        private String shortDescription;

        private String status;

        private TermRelations termRelations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlossaryTermResponse model) {
            super(model);
            domainId(model.domainId);
            glossaryId(model.glossaryId);
            id(model.id);
            longDescription(model.longDescription);
            name(model.name);
            shortDescription(model.shortDescription);
            status(model.status);
            termRelations(model.termRelations);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getGlossaryId() {
            return glossaryId;
        }

        public final void setGlossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
        }

        @Override
        public final Builder glossaryId(String glossaryId) {
            this.glossaryId = glossaryId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLongDescription() {
            return longDescription;
        }

        public final void setLongDescription(String longDescription) {
            this.longDescription = longDescription;
        }

        @Override
        public final Builder longDescription(String longDescription) {
            this.longDescription = longDescription;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GlossaryTermStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TermRelations.Builder getTermRelations() {
            return termRelations != null ? termRelations.toBuilder() : null;
        }

        public final void setTermRelations(TermRelations.BuilderImpl termRelations) {
            this.termRelations = termRelations != null ? termRelations.build() : null;
        }

        @Override
        public final Builder termRelations(TermRelations termRelations) {
            this.termRelations = termRelations;
            return this;
        }

        @Override
        public CreateGlossaryTermResponse build() {
            return new CreateGlossaryTermResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
