/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateListingChangeSetResponse extends DataZoneResponse implements
        ToCopyableBuilder<CreateListingChangeSetResponse.Builder, CreateListingChangeSetResponse> {
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingId").getter(getter(CreateListingChangeSetResponse::listingId)).setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()).build();

    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingRevision").getter(getter(CreateListingChangeSetResponse::listingRevision))
            .setter(setter(Builder::listingRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateListingChangeSetResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTING_ID_FIELD,
            LISTING_REVISION_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("listingId", LISTING_ID_FIELD);
                    put("listingRevision", LISTING_REVISION_FIELD);
                    put("status", STATUS_FIELD);
                }
            });

    private final String listingId;

    private final String listingRevision;

    private final String status;

    private CreateListingChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the listing (a record of an asset at a given time).
     * </p>
     * 
     * @return The ID of the listing (a record of an asset at a given time).
     */
    public final String listingId() {
        return listingId;
    }

    /**
     * <p>
     * The revision of a listing.
     * </p>
     * 
     * @return The revision of a listing.
     */
    public final String listingRevision() {
        return listingRevision;
    }

    /**
     * <p>
     * Specifies the status of the listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the listing.
     * @see ListingStatus
     */
    public final ListingStatus status() {
        return ListingStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the status of the listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the status of the listing.
     * @see ListingStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        hashCode = 31 * hashCode + Objects.hashCode(listingRevision());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListingChangeSetResponse)) {
            return false;
        }
        CreateListingChangeSetResponse other = (CreateListingChangeSetResponse) obj;
        return Objects.equals(listingId(), other.listingId()) && Objects.equals(listingRevision(), other.listingRevision())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateListingChangeSetResponse").add("ListingId", listingId())
                .add("ListingRevision", listingRevision()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "listingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        case "listingRevision":
            return Optional.ofNullable(clazz.cast(listingRevision()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateListingChangeSetResponse, T> g) {
        return obj -> g.apply((CreateListingChangeSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateListingChangeSetResponse> {
        /**
         * <p>
         * The ID of the listing (a record of an asset at a given time).
         * </p>
         * 
         * @param listingId
         *        The ID of the listing (a record of an asset at a given time).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);

        /**
         * <p>
         * The revision of a listing.
         * </p>
         * 
         * @param listingRevision
         *        The revision of a listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingRevision(String listingRevision);

        /**
         * <p>
         * Specifies the status of the listing.
         * </p>
         * 
         * @param status
         *        Specifies the status of the listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the status of the listing.
         * </p>
         * 
         * @param status
         *        Specifies the status of the listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(ListingStatus status);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String listingId;

        private String listingRevision;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListingChangeSetResponse model) {
            super(model);
            listingId(model.listingId);
            listingRevision(model.listingRevision);
            status(model.status);
        }

        public final String getListingId() {
            return listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CreateListingChangeSetResponse build() {
            return new CreateListingChangeSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
