/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRuleRequest extends DataZoneRequest implements
        ToCopyableBuilder<CreateRuleRequest.Builder, CreateRuleRequest> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(CreateRuleRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateRuleRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateRuleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<RuleDetail> DETAIL_FIELD = SdkField.<RuleDetail> builder(MarshallingType.SDK_POJO)
            .memberName("detail").getter(getter(CreateRuleRequest::detail)).setter(setter(Builder::detail))
            .constructor(RuleDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()).build();

    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainIdentifier").getter(getter(CreateRuleRequest::domainIdentifier))
            .setter(setter(Builder::domainIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRuleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RuleScope> SCOPE_FIELD = SdkField.<RuleScope> builder(MarshallingType.SDK_POJO)
            .memberName("scope").getter(getter(CreateRuleRequest::scope)).setter(setter(Builder::scope))
            .constructor(RuleScope::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final SdkField<RuleTarget> TARGET_FIELD = SdkField.<RuleTarget> builder(MarshallingType.SDK_POJO)
            .memberName("target").getter(getter(CreateRuleRequest::target)).setter(setter(Builder::target))
            .constructor(RuleTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DETAIL_FIELD, DOMAIN_IDENTIFIER_FIELD, NAME_FIELD, SCOPE_FIELD, TARGET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("action", ACTION_FIELD);
                    put("clientToken", CLIENT_TOKEN_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("detail", DETAIL_FIELD);
                    put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
                    put("name", NAME_FIELD);
                    put("scope", SCOPE_FIELD);
                    put("target", TARGET_FIELD);
                }
            });

    private final String action;

    private final String clientToken;

    private final String description;

    private final RuleDetail detail;

    private final String domainIdentifier;

    private final String name;

    private final RuleScope scope;

    private final RuleTarget target;

    private CreateRuleRequest(BuilderImpl builder) {
        super(builder);
        this.action = builder.action;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.detail = builder.detail;
        this.domainIdentifier = builder.domainIdentifier;
        this.name = builder.name;
        this.scope = builder.scope;
        this.target = builder.target;
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final RuleAction action() {
        return RuleAction.fromValue(action);
    }

    /**
     * <p>
     * The action of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link RuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action of the rule.
     * @see RuleAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The description of the rule.
     * </p>
     * 
     * @return The description of the rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The detail of the rule.
     * </p>
     * 
     * @return The detail of the rule.
     */
    public final RuleDetail detail() {
        return detail;
    }

    /**
     * <p>
     * The ID of the domain where the rule is created.
     * </p>
     * 
     * @return The ID of the domain where the rule is created.
     */
    public final String domainIdentifier() {
        return domainIdentifier;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The scope of the rule.
     * </p>
     * 
     * @return The scope of the rule.
     */
    public final RuleScope scope() {
        return scope;
    }

    /**
     * <p>
     * The target of the rule.
     * </p>
     * 
     * @return The target of the rule.
     */
    public final RuleTarget target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRuleRequest)) {
            return false;
        }
        CreateRuleRequest other = (CreateRuleRequest) obj;
        return Objects.equals(actionAsString(), other.actionAsString()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(description(), other.description()) && Objects.equals(detail(), other.detail())
                && Objects.equals(domainIdentifier(), other.domainIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(scope(), other.scope()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRuleRequest").add("Action", actionAsString()).add("ClientToken", clientToken())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Detail", detail())
                .add("DomainIdentifier", domainIdentifier())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Scope", scope())
                .add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "domainIdentifier":
            return Optional.ofNullable(clazz.cast(domainIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scope()));
        case "target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRuleRequest, T> g) {
        return obj -> g.apply((CreateRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRuleRequest> {
        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action of the rule.
         * </p>
         * 
         * @param action
         *        The action of the rule.
         * @see RuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleAction
         */
        Builder action(RuleAction action);

        /**
         * <p>
         * A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that is provided to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The description of the rule.
         * </p>
         * 
         * @param description
         *        The description of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The detail of the rule.
         * </p>
         * 
         * @param detail
         *        The detail of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(RuleDetail detail);

        /**
         * <p>
         * The detail of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleDetail.Builder} avoiding the need to
         * create one manually via {@link RuleDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #detail(RuleDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link RuleDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(RuleDetail)
         */
        default Builder detail(Consumer<RuleDetail.Builder> detail) {
            return detail(RuleDetail.builder().applyMutation(detail).build());
        }

        /**
         * <p>
         * The ID of the domain where the rule is created.
         * </p>
         * 
         * @param domainIdentifier
         *        The ID of the domain where the rule is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainIdentifier(String domainIdentifier);

        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param name
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The scope of the rule.
         * </p>
         * 
         * @param scope
         *        The scope of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(RuleScope scope);

        /**
         * <p>
         * The scope of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleScope.Builder} avoiding the need to
         * create one manually via {@link RuleScope#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleScope.Builder#build()} is called immediately and its result
         * is passed to {@link #scope(RuleScope)}.
         * 
         * @param scope
         *        a consumer that will call methods on {@link RuleScope.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scope(RuleScope)
         */
        default Builder scope(Consumer<RuleScope.Builder> scope) {
            return scope(RuleScope.builder().applyMutation(scope).build());
        }

        /**
         * <p>
         * The target of the rule.
         * </p>
         * 
         * @param target
         *        The target of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(RuleTarget target);

        /**
         * <p>
         * The target of the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleTarget.Builder} avoiding the need to
         * create one manually via {@link RuleTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #target(RuleTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link RuleTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(RuleTarget)
         */
        default Builder target(Consumer<RuleTarget.Builder> target) {
            return target(RuleTarget.builder().applyMutation(target).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataZoneRequest.BuilderImpl implements Builder {
        private String action;

        private String clientToken;

        private String description;

        private RuleDetail detail;

        private String domainIdentifier;

        private String name;

        private RuleScope scope;

        private RuleTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRuleRequest model) {
            super(model);
            action(model.action);
            clientToken(model.clientToken);
            description(model.description);
            detail(model.detail);
            domainIdentifier(model.domainIdentifier);
            name(model.name);
            scope(model.scope);
            target(model.target);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(RuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuleDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(RuleDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(RuleDetail detail) {
            this.detail = detail;
            return this;
        }

        public final String getDomainIdentifier() {
            return domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RuleScope.Builder getScope() {
            return scope != null ? scope.toBuilder() : null;
        }

        public final void setScope(RuleScope.BuilderImpl scope) {
            this.scope = scope != null ? scope.build() : null;
        }

        @Override
        public final Builder scope(RuleScope scope) {
            this.scope = scope;
            return this;
        }

        public final RuleTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(RuleTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(RuleTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRuleRequest build() {
            return new CreateRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
