/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The additional attributes of the asset of the data product.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataProductListingItemAdditionalAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DataProductListingItemAdditionalAttributes.Builder, DataProductListingItemAdditionalAttributes> {
    private static final SdkField<String> FORMS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("forms")
            .getter(getter(DataProductListingItemAdditionalAttributes::forms)).setter(setter(Builder::forms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("forms", FORMS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String forms;

    private DataProductListingItemAdditionalAttributes(BuilderImpl builder) {
        this.forms = builder.forms;
    }

    /**
     * <p>
     * The metadata forms of the asset of the data product.
     * </p>
     * 
     * @return The metadata forms of the asset of the data product.
     */
    public final String forms() {
        return forms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(forms());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataProductListingItemAdditionalAttributes)) {
            return false;
        }
        DataProductListingItemAdditionalAttributes other = (DataProductListingItemAdditionalAttributes) obj;
        return Objects.equals(forms(), other.forms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataProductListingItemAdditionalAttributes").add("Forms", forms()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "forms":
            return Optional.ofNullable(clazz.cast(forms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataProductListingItemAdditionalAttributes, T> g) {
        return obj -> g.apply((DataProductListingItemAdditionalAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataProductListingItemAdditionalAttributes> {
        /**
         * <p>
         * The metadata forms of the asset of the data product.
         * </p>
         * 
         * @param forms
         *        The metadata forms of the asset of the data product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forms(String forms);
    }

    static final class BuilderImpl implements Builder {
        private String forms;

        private BuilderImpl() {
        }

        private BuilderImpl(DataProductListingItemAdditionalAttributes model) {
            forms(model.forms);
        }

        public final String getForms() {
            return forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        @Override
        public DataProductListingItemAdditionalAttributes build() {
            return new DataProductListingItemAdditionalAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
