/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of a glossary term attached to the inventory asset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetailedGlossaryTerm implements SdkPojo, Serializable,
        ToCopyableBuilder<DetailedGlossaryTerm.Builder, DetailedGlossaryTerm> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DetailedGlossaryTerm::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SHORT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shortDescription").getter(getter(DetailedGlossaryTerm::shortDescription))
            .setter(setter(Builder::shortDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SHORT_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("name", NAME_FIELD);
                    put("shortDescription", SHORT_DESCRIPTION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String shortDescription;

    private DetailedGlossaryTerm(BuilderImpl builder) {
        this.name = builder.name;
        this.shortDescription = builder.shortDescription;
    }

    /**
     * <p>
     * The name of a glossary term attached to the inventory asset.
     * </p>
     * 
     * @return The name of a glossary term attached to the inventory asset.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The shoft description of a glossary term attached to the inventory asset.
     * </p>
     * 
     * @return The shoft description of a glossary term attached to the inventory asset.
     */
    public final String shortDescription() {
        return shortDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetailedGlossaryTerm)) {
            return false;
        }
        DetailedGlossaryTerm other = (DetailedGlossaryTerm) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(shortDescription(), other.shortDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetailedGlossaryTerm").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShortDescription", shortDescription() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "shortDescription":
            return Optional.ofNullable(clazz.cast(shortDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetailedGlossaryTerm, T> g) {
        return obj -> g.apply((DetailedGlossaryTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetailedGlossaryTerm> {
        /**
         * <p>
         * The name of a glossary term attached to the inventory asset.
         * </p>
         * 
         * @param name
         *        The name of a glossary term attached to the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The shoft description of a glossary term attached to the inventory asset.
         * </p>
         * 
         * @param shortDescription
         *        The shoft description of a glossary term attached to the inventory asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortDescription(String shortDescription);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String shortDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DetailedGlossaryTerm model) {
            name(model.name);
            shortDescription(model.shortDescription);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortDescription() {
            return shortDescription;
        }

        public final void setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
        }

        @Override
        public final Builder shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        @Override
        public DetailedGlossaryTerm build() {
            return new DetailedGlossaryTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
