/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The target for the domain unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainUnitTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainUnitTarget.Builder, DomainUnitTarget> {
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainUnitId").getter(getter(DomainUnitTarget::domainUnitId)).setter(setter(Builder::domainUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILD_DOMAIN_UNITS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildDomainUnits").getter(getter(DomainUnitTarget::includeChildDomainUnits))
            .setter(setter(Builder::includeChildDomainUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeChildDomainUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_UNIT_ID_FIELD,
            INCLUDE_CHILD_DOMAIN_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
                    put("includeChildDomainUnits", INCLUDE_CHILD_DOMAIN_UNITS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String domainUnitId;

    private final Boolean includeChildDomainUnits;

    private DomainUnitTarget(BuilderImpl builder) {
        this.domainUnitId = builder.domainUnitId;
        this.includeChildDomainUnits = builder.includeChildDomainUnits;
    }

    /**
     * <p>
     * The ID of the domain unit.
     * </p>
     * 
     * @return The ID of the domain unit.
     */
    public final String domainUnitId() {
        return domainUnitId;
    }

    /**
     * <p>
     * Specifies whether to apply a rule to the child domain units.
     * </p>
     * 
     * @return Specifies whether to apply a rule to the child domain units.
     */
    public final Boolean includeChildDomainUnits() {
        return includeChildDomainUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildDomainUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainUnitTarget)) {
            return false;
        }
        DomainUnitTarget other = (DomainUnitTarget) obj;
        return Objects.equals(domainUnitId(), other.domainUnitId())
                && Objects.equals(includeChildDomainUnits(), other.includeChildDomainUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainUnitTarget").add("DomainUnitId", domainUnitId())
                .add("IncludeChildDomainUnits", includeChildDomainUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainUnitId":
            return Optional.ofNullable(clazz.cast(domainUnitId()));
        case "includeChildDomainUnits":
            return Optional.ofNullable(clazz.cast(includeChildDomainUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DomainUnitTarget, T> g) {
        return obj -> g.apply((DomainUnitTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainUnitTarget> {
        /**
         * <p>
         * The ID of the domain unit.
         * </p>
         * 
         * @param domainUnitId
         *        The ID of the domain unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainUnitId(String domainUnitId);

        /**
         * <p>
         * Specifies whether to apply a rule to the child domain units.
         * </p>
         * 
         * @param includeChildDomainUnits
         *        Specifies whether to apply a rule to the child domain units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildDomainUnits(Boolean includeChildDomainUnits);
    }

    static final class BuilderImpl implements Builder {
        private String domainUnitId;

        private Boolean includeChildDomainUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainUnitTarget model) {
            domainUnitId(model.domainUnitId);
            includeChildDomainUnits(model.includeChildDomainUnits);
        }

        public final String getDomainUnitId() {
            return domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final Boolean getIncludeChildDomainUnits() {
            return includeChildDomainUnits;
        }

        public final void setIncludeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
        }

        @Override
        public final Builder includeChildDomainUnits(Boolean includeChildDomainUnits) {
            this.includeChildDomainUnits = includeChildDomainUnits;
            return this;
        }

        @Override
        public DomainUnitTarget build() {
            return new DomainUnitTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
