/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of an environment blueprint summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentBlueprintSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentBlueprintSummary.Builder, EnvironmentBlueprintSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(EnvironmentBlueprintSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(EnvironmentBlueprintSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EnvironmentBlueprintSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentBlueprintSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(EnvironmentBlueprintSummary::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField
            .<ProvisioningProperties> builder(MarshallingType.SDK_POJO).memberName("provisioningProperties")
            .getter(getter(EnvironmentBlueprintSummary::provisioningProperties)).setter(setter(Builder::provisioningProperties))
            .constructor(ProvisioningProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build())
            .build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(EnvironmentBlueprintSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD, PROVIDER_FIELD, PROVISIONING_PROPERTIES_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("id", ID_FIELD);
                    put("name", NAME_FIELD);
                    put("provider", PROVIDER_FIELD);
                    put("provisioningProperties", PROVISIONING_PROPERTIES_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String description;

    private final String id;

    private final String name;

    private final String provider;

    private final ProvisioningProperties provisioningProperties;

    private final Instant updatedAt;

    private EnvironmentBlueprintSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
        this.provider = builder.provider;
        this.provisioningProperties = builder.provisioningProperties;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The timestamp of when an environment blueprint was created.
     * </p>
     * 
     * @return The timestamp of when an environment blueprint was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of a blueprint.
     * </p>
     * 
     * @return The description of a blueprint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the blueprint.
     * </p>
     * 
     * @return The identifier of the blueprint.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the blueprint.
     * </p>
     * 
     * @return The name of the blueprint.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The provider of the blueprint.
     * </p>
     * 
     * @return The provider of the blueprint.
     */
    public final String provider() {
        return provider;
    }

    /**
     * <p>
     * The provisioning properties of the blueprint.
     * </p>
     * 
     * @return The provisioning properties of the blueprint.
     */
    public final ProvisioningProperties provisioningProperties() {
        return provisioningProperties;
    }

    /**
     * <p>
     * The timestamp of when the blueprint was enabled.
     * </p>
     * 
     * @return The timestamp of when the blueprint was enabled.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentBlueprintSummary)) {
            return false;
        }
        EnvironmentBlueprintSummary other = (EnvironmentBlueprintSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(provider(), other.provider())
                && Objects.equals(provisioningProperties(), other.provisioningProperties())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentBlueprintSummary").add("CreatedAt", createdAt())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Id", id())
                .add("Name", name()).add("Provider", provider()).add("ProvisioningProperties", provisioningProperties())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "provisioningProperties":
            return Optional.ofNullable(clazz.cast(provisioningProperties()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentBlueprintSummary, T> g) {
        return obj -> g.apply((EnvironmentBlueprintSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentBlueprintSummary> {
        /**
         * <p>
         * The timestamp of when an environment blueprint was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when an environment blueprint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of a blueprint.
         * </p>
         * 
         * @param description
         *        The description of a blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the blueprint.
         * </p>
         * 
         * @param id
         *        The identifier of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the blueprint.
         * </p>
         * 
         * @param name
         *        The name of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The provider of the blueprint.
         * </p>
         * 
         * @param provider
         *        The provider of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The provisioning properties of the blueprint.
         * </p>
         * 
         * @param provisioningProperties
         *        The provisioning properties of the blueprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningProperties(ProvisioningProperties provisioningProperties);

        /**
         * <p>
         * The provisioning properties of the blueprint.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningProperties.Builder} avoiding
         * the need to create one manually via {@link ProvisioningProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningProperties(ProvisioningProperties)}.
         * 
         * @param provisioningProperties
         *        a consumer that will call methods on {@link ProvisioningProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningProperties(ProvisioningProperties)
         */
        default Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return provisioningProperties(ProvisioningProperties.builder().applyMutation(provisioningProperties).build());
        }

        /**
         * <p>
         * The timestamp of when the blueprint was enabled.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the blueprint was enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String description;

        private String id;

        private String name;

        private String provider;

        private ProvisioningProperties provisioningProperties;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentBlueprintSummary model) {
            createdAt(model.createdAt);
            description(model.description);
            id(model.id);
            name(model.name);
            provider(model.provider);
            provisioningProperties(model.provisioningProperties);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return provisioningProperties != null ? provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EnvironmentBlueprintSummary build() {
            return new EnvironmentBlueprintSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
