/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the environment configuration parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentConfigurationParametersDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentConfigurationParametersDetails.Builder, EnvironmentConfigurationParametersDetails> {
    private static final SdkField<List<EnvironmentConfigurationParameter>> PARAMETER_OVERRIDES_FIELD = SdkField
            .<List<EnvironmentConfigurationParameter>> builder(MarshallingType.LIST)
            .memberName("parameterOverrides")
            .getter(getter(EnvironmentConfigurationParametersDetails::parameterOverrides))
            .setter(setter(Builder::parameterOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentConfigurationParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentConfigurationParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EnvironmentConfigurationParameter>> RESOLVED_PARAMETERS_FIELD = SdkField
            .<List<EnvironmentConfigurationParameter>> builder(MarshallingType.LIST)
            .memberName("resolvedParameters")
            .getter(getter(EnvironmentConfigurationParametersDetails::resolvedParameters))
            .setter(setter(Builder::resolvedParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolvedParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentConfigurationParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentConfigurationParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SSM_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssmPath").getter(getter(EnvironmentConfigurationParametersDetails::ssmPath))
            .setter(setter(Builder::ssmPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_OVERRIDES_FIELD,
            RESOLVED_PARAMETERS_FIELD, SSM_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("parameterOverrides", PARAMETER_OVERRIDES_FIELD);
                    put("resolvedParameters", RESOLVED_PARAMETERS_FIELD);
                    put("ssmPath", SSM_PATH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<EnvironmentConfigurationParameter> parameterOverrides;

    private final List<EnvironmentConfigurationParameter> resolvedParameters;

    private final String ssmPath;

    private EnvironmentConfigurationParametersDetails(BuilderImpl builder) {
        this.parameterOverrides = builder.parameterOverrides;
        this.resolvedParameters = builder.resolvedParameters;
        this.ssmPath = builder.ssmPath;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterOverrides property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterOverrides() {
        return parameterOverrides != null && !(parameterOverrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter overrides.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterOverrides} method.
     * </p>
     * 
     * @return The parameter overrides.
     */
    public final List<EnvironmentConfigurationParameter> parameterOverrides() {
        return parameterOverrides;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResolvedParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResolvedParameters() {
        return resolvedParameters != null && !(resolvedParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resolved environment configuration parameters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResolvedParameters} method.
     * </p>
     * 
     * @return The resolved environment configuration parameters.
     */
    public final List<EnvironmentConfigurationParameter> resolvedParameters() {
        return resolvedParameters;
    }

    /**
     * <p>
     * Ssm path environment configuration parameters.
     * </p>
     * 
     * @return Ssm path environment configuration parameters.
     */
    public final String ssmPath() {
        return ssmPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterOverrides() ? parameterOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResolvedParameters() ? resolvedParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ssmPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigurationParametersDetails)) {
            return false;
        }
        EnvironmentConfigurationParametersDetails other = (EnvironmentConfigurationParametersDetails) obj;
        return hasParameterOverrides() == other.hasParameterOverrides()
                && Objects.equals(parameterOverrides(), other.parameterOverrides())
                && hasResolvedParameters() == other.hasResolvedParameters()
                && Objects.equals(resolvedParameters(), other.resolvedParameters()) && Objects.equals(ssmPath(), other.ssmPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentConfigurationParametersDetails")
                .add("ParameterOverrides", hasParameterOverrides() ? parameterOverrides() : null)
                .add("ResolvedParameters", hasResolvedParameters() ? resolvedParameters() : null).add("SsmPath", ssmPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parameterOverrides":
            return Optional.ofNullable(clazz.cast(parameterOverrides()));
        case "resolvedParameters":
            return Optional.ofNullable(clazz.cast(resolvedParameters()));
        case "ssmPath":
            return Optional.ofNullable(clazz.cast(ssmPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigurationParametersDetails, T> g) {
        return obj -> g.apply((EnvironmentConfigurationParametersDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentConfigurationParametersDetails> {
        /**
         * <p>
         * The parameter overrides.
         * </p>
         * 
         * @param parameterOverrides
         *        The parameter overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(Collection<EnvironmentConfigurationParameter> parameterOverrides);

        /**
         * <p>
         * The parameter overrides.
         * </p>
         * 
         * @param parameterOverrides
         *        The parameter overrides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterOverrides(EnvironmentConfigurationParameter... parameterOverrides);

        /**
         * <p>
         * The parameter overrides.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #parameterOverrides(List<EnvironmentConfigurationParameter>)}.
         * 
         * @param parameterOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterOverrides(java.util.Collection<EnvironmentConfigurationParameter>)
         */
        Builder parameterOverrides(Consumer<EnvironmentConfigurationParameter.Builder>... parameterOverrides);

        /**
         * <p>
         * The resolved environment configuration parameters.
         * </p>
         * 
         * @param resolvedParameters
         *        The resolved environment configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedParameters(Collection<EnvironmentConfigurationParameter> resolvedParameters);

        /**
         * <p>
         * The resolved environment configuration parameters.
         * </p>
         * 
         * @param resolvedParameters
         *        The resolved environment configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolvedParameters(EnvironmentConfigurationParameter... resolvedParameters);

        /**
         * <p>
         * The resolved environment configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #resolvedParameters(List<EnvironmentConfigurationParameter>)}.
         * 
         * @param resolvedParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolvedParameters(java.util.Collection<EnvironmentConfigurationParameter>)
         */
        Builder resolvedParameters(Consumer<EnvironmentConfigurationParameter.Builder>... resolvedParameters);

        /**
         * <p>
         * Ssm path environment configuration parameters.
         * </p>
         * 
         * @param ssmPath
         *        Ssm path environment configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmPath(String ssmPath);
    }

    static final class BuilderImpl implements Builder {
        private List<EnvironmentConfigurationParameter> parameterOverrides = DefaultSdkAutoConstructList.getInstance();

        private List<EnvironmentConfigurationParameter> resolvedParameters = DefaultSdkAutoConstructList.getInstance();

        private String ssmPath;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigurationParametersDetails model) {
            parameterOverrides(model.parameterOverrides);
            resolvedParameters(model.resolvedParameters);
            ssmPath(model.ssmPath);
        }

        public final List<EnvironmentConfigurationParameter.Builder> getParameterOverrides() {
            List<EnvironmentConfigurationParameter.Builder> result = EnvironmentConfigurationParametersListCopier
                    .copyToBuilder(this.parameterOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterOverrides(Collection<EnvironmentConfigurationParameter.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = EnvironmentConfigurationParametersListCopier.copyFromBuilder(parameterOverrides);
        }

        @Override
        public final Builder parameterOverrides(Collection<EnvironmentConfigurationParameter> parameterOverrides) {
            this.parameterOverrides = EnvironmentConfigurationParametersListCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(EnvironmentConfigurationParameter... parameterOverrides) {
            parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<EnvironmentConfigurationParameter.Builder>... parameterOverrides) {
            parameterOverrides(Stream.of(parameterOverrides)
                    .map(c -> EnvironmentConfigurationParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EnvironmentConfigurationParameter.Builder> getResolvedParameters() {
            List<EnvironmentConfigurationParameter.Builder> result = EnvironmentConfigurationParametersListCopier
                    .copyToBuilder(this.resolvedParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResolvedParameters(Collection<EnvironmentConfigurationParameter.BuilderImpl> resolvedParameters) {
            this.resolvedParameters = EnvironmentConfigurationParametersListCopier.copyFromBuilder(resolvedParameters);
        }

        @Override
        public final Builder resolvedParameters(Collection<EnvironmentConfigurationParameter> resolvedParameters) {
            this.resolvedParameters = EnvironmentConfigurationParametersListCopier.copy(resolvedParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedParameters(EnvironmentConfigurationParameter... resolvedParameters) {
            resolvedParameters(Arrays.asList(resolvedParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolvedParameters(Consumer<EnvironmentConfigurationParameter.Builder>... resolvedParameters) {
            resolvedParameters(Stream.of(resolvedParameters)
                    .map(c -> EnvironmentConfigurationParameter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSsmPath() {
            return ssmPath;
        }

        public final void setSsmPath(String ssmPath) {
            this.ssmPath = ssmPath;
        }

        @Override
        public final Builder ssmPath(String ssmPath) {
            this.ssmPath = ssmPath;
            return this;
        }

        @Override
        public EnvironmentConfigurationParametersDetails build() {
            return new EnvironmentConfigurationParametersDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
