/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The environment deployment details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentDeploymentDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentDeploymentDetails.Builder, EnvironmentDeploymentDetails> {
    private static final SdkField<Map<String, List<EnvironmentError>>> ENVIRONMENT_FAILURE_REASONS_FIELD = SdkField
            .<Map<String, List<EnvironmentError>>> builder(MarshallingType.MAP)
            .memberName("environmentFailureReasons")
            .getter(getter(EnvironmentDeploymentDetails::environmentFailureReasons))
            .setter(setter(Builder::environmentFailureReasons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentFailureReasons").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<EnvironmentError>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<EnvironmentError> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(EnvironmentError::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> OVERALL_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("overallDeploymentStatus").getter(getter(EnvironmentDeploymentDetails::overallDeploymentStatusAsString))
            .setter(setter(Builder::overallDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overallDeploymentStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENVIRONMENT_FAILURE_REASONS_FIELD, OVERALL_DEPLOYMENT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("environmentFailureReasons", ENVIRONMENT_FAILURE_REASONS_FIELD);
                    put("overallDeploymentStatus", OVERALL_DEPLOYMENT_STATUS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, List<EnvironmentError>> environmentFailureReasons;

    private final String overallDeploymentStatus;

    private EnvironmentDeploymentDetails(BuilderImpl builder) {
        this.environmentFailureReasons = builder.environmentFailureReasons;
        this.overallDeploymentStatus = builder.overallDeploymentStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentFailureReasons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentFailureReasons() {
        return environmentFailureReasons != null && !(environmentFailureReasons instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Environment failure reasons.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentFailureReasons} method.
     * </p>
     * 
     * @return Environment failure reasons.
     */
    public final Map<String, List<EnvironmentError>> environmentFailureReasons() {
        return environmentFailureReasons;
    }

    /**
     * <p>
     * The overall deployment status of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overallDeploymentStatus} will return {@link OverallDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #overallDeploymentStatusAsString}.
     * </p>
     * 
     * @return The overall deployment status of the environment.
     * @see OverallDeploymentStatus
     */
    public final OverallDeploymentStatus overallDeploymentStatus() {
        return OverallDeploymentStatus.fromValue(overallDeploymentStatus);
    }

    /**
     * <p>
     * The overall deployment status of the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #overallDeploymentStatus} will return {@link OverallDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #overallDeploymentStatusAsString}.
     * </p>
     * 
     * @return The overall deployment status of the environment.
     * @see OverallDeploymentStatus
     */
    public final String overallDeploymentStatusAsString() {
        return overallDeploymentStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentFailureReasons() ? environmentFailureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overallDeploymentStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentDeploymentDetails)) {
            return false;
        }
        EnvironmentDeploymentDetails other = (EnvironmentDeploymentDetails) obj;
        return hasEnvironmentFailureReasons() == other.hasEnvironmentFailureReasons()
                && Objects.equals(environmentFailureReasons(), other.environmentFailureReasons())
                && Objects.equals(overallDeploymentStatusAsString(), other.overallDeploymentStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentDeploymentDetails")
                .add("EnvironmentFailureReasons", hasEnvironmentFailureReasons() ? environmentFailureReasons() : null)
                .add("OverallDeploymentStatus", overallDeploymentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentFailureReasons":
            return Optional.ofNullable(clazz.cast(environmentFailureReasons()));
        case "overallDeploymentStatus":
            return Optional.ofNullable(clazz.cast(overallDeploymentStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentDeploymentDetails, T> g) {
        return obj -> g.apply((EnvironmentDeploymentDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentDeploymentDetails> {
        /**
         * <p>
         * Environment failure reasons.
         * </p>
         * 
         * @param environmentFailureReasons
         *        Environment failure reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentFailureReasons(Map<String, ? extends Collection<EnvironmentError>> environmentFailureReasons);

        /**
         * <p>
         * The overall deployment status of the environment.
         * </p>
         * 
         * @param overallDeploymentStatus
         *        The overall deployment status of the environment.
         * @see OverallDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverallDeploymentStatus
         */
        Builder overallDeploymentStatus(String overallDeploymentStatus);

        /**
         * <p>
         * The overall deployment status of the environment.
         * </p>
         * 
         * @param overallDeploymentStatus
         *        The overall deployment status of the environment.
         * @see OverallDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverallDeploymentStatus
         */
        Builder overallDeploymentStatus(OverallDeploymentStatus overallDeploymentStatus);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<EnvironmentError>> environmentFailureReasons = DefaultSdkAutoConstructMap.getInstance();

        private String overallDeploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentDeploymentDetails model) {
            environmentFailureReasons(model.environmentFailureReasons);
            overallDeploymentStatus(model.overallDeploymentStatus);
        }

        public final Map<String, List<EnvironmentError.Builder>> getEnvironmentFailureReasons() {
            Map<String, List<EnvironmentError.Builder>> result = EnvironmentFailureReasonsCopier
                    .copyToBuilder(this.environmentFailureReasons);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFailureReasons(
                Map<String, ? extends Collection<EnvironmentError.BuilderImpl>> environmentFailureReasons) {
            this.environmentFailureReasons = EnvironmentFailureReasonsCopier.copyFromBuilder(environmentFailureReasons);
        }

        @Override
        public final Builder environmentFailureReasons(
                Map<String, ? extends Collection<EnvironmentError>> environmentFailureReasons) {
            this.environmentFailureReasons = EnvironmentFailureReasonsCopier.copy(environmentFailureReasons);
            return this;
        }

        public final String getOverallDeploymentStatus() {
            return overallDeploymentStatus;
        }

        public final void setOverallDeploymentStatus(String overallDeploymentStatus) {
            this.overallDeploymentStatus = overallDeploymentStatus;
        }

        @Override
        public final Builder overallDeploymentStatus(String overallDeploymentStatus) {
            this.overallDeploymentStatus = overallDeploymentStatus;
            return this;
        }

        @Override
        public final Builder overallDeploymentStatus(OverallDeploymentStatus overallDeploymentStatus) {
            this.overallDeploymentStatus(overallDeploymentStatus == null ? null : overallDeploymentStatus.toString());
            return this;
        }

        @Override
        public EnvironmentDeploymentDetails build() {
            return new EnvironmentDeploymentDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
