/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEnvironmentResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetEnvironmentResponse.Builder, GetEnvironmentResponse> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountId").getter(getter(GetEnvironmentResponse::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()).build();

    private static final SdkField<String> AWS_ACCOUNT_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsAccountRegion").getter(getter(GetEnvironmentResponse::awsAccountRegion))
            .setter(setter(Builder::awsAccountRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountRegion").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetEnvironmentResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetEnvironmentResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<DeploymentProperties> DEPLOYMENT_PROPERTIES_FIELD = SdkField
            .<DeploymentProperties> builder(MarshallingType.SDK_POJO).memberName("deploymentProperties")
            .getter(getter(GetEnvironmentResponse::deploymentProperties)).setter(setter(Builder::deploymentProperties))
            .constructor(DeploymentProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentProperties").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetEnvironmentResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetEnvironmentResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<List<ConfigurableEnvironmentAction>> ENVIRONMENT_ACTIONS_FIELD = SdkField
            .<List<ConfigurableEnvironmentAction>> builder(MarshallingType.LIST)
            .memberName("environmentActions")
            .getter(getter(GetEnvironmentResponse::environmentActions))
            .setter(setter(Builder::environmentActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurableEnvironmentAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurableEnvironmentAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentBlueprintId").getter(getter(GetEnvironmentResponse::environmentBlueprintId))
            .setter(setter(Builder::environmentBlueprintId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentProfileId").getter(getter(GetEnvironmentResponse::environmentProfileId))
            .setter(setter(Builder::environmentProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentProfileId").build())
            .build();

    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("glossaryTerms")
            .getter(getter(GetEnvironmentResponse::glossaryTerms))
            .setter(setter(Builder::glossaryTerms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetEnvironmentResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Deployment> LAST_DEPLOYMENT_FIELD = SdkField.<Deployment> builder(MarshallingType.SDK_POJO)
            .memberName("lastDeployment").getter(getter(GetEnvironmentResponse::lastDeployment))
            .setter(setter(Builder::lastDeployment)).constructor(Deployment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeployment").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetEnvironmentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("projectId").getter(getter(GetEnvironmentResponse::projectId)).setter(setter(Builder::projectId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()).build();

    private static final SdkField<String> PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("provider").getter(getter(GetEnvironmentResponse::provider)).setter(setter(Builder::provider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();

    private static final SdkField<List<Resource>> PROVISIONED_RESOURCES_FIELD = SdkField
            .<List<Resource>> builder(MarshallingType.LIST)
            .memberName("provisionedResources")
            .getter(getter(GetEnvironmentResponse::provisionedResources))
            .setter(setter(Builder::provisionedResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField
            .<ProvisioningProperties> builder(MarshallingType.SDK_POJO).memberName("provisioningProperties")
            .getter(getter(GetEnvironmentResponse::provisioningProperties)).setter(setter(Builder::provisioningProperties))
            .constructor(ProvisioningProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEnvironmentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetEnvironmentResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField
            .<List<CustomParameter>> builder(MarshallingType.LIST)
            .memberName("userParameters")
            .getter(getter(GetEnvironmentResponse::userParameters))
            .setter(setter(Builder::userParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            AWS_ACCOUNT_REGION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DEPLOYMENT_PROPERTIES_FIELD, DESCRIPTION_FIELD,
            DOMAIN_ID_FIELD, ENVIRONMENT_ACTIONS_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, ENVIRONMENT_PROFILE_ID_FIELD,
            GLOSSARY_TERMS_FIELD, ID_FIELD, LAST_DEPLOYMENT_FIELD, NAME_FIELD, PROJECT_ID_FIELD, PROVIDER_FIELD,
            PROVISIONED_RESOURCES_FIELD, PROVISIONING_PROPERTIES_FIELD, STATUS_FIELD, UPDATED_AT_FIELD, USER_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
                    put("awsAccountRegion", AWS_ACCOUNT_REGION_FIELD);
                    put("createdAt", CREATED_AT_FIELD);
                    put("createdBy", CREATED_BY_FIELD);
                    put("deploymentProperties", DEPLOYMENT_PROPERTIES_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("environmentActions", ENVIRONMENT_ACTIONS_FIELD);
                    put("environmentBlueprintId", ENVIRONMENT_BLUEPRINT_ID_FIELD);
                    put("environmentProfileId", ENVIRONMENT_PROFILE_ID_FIELD);
                    put("glossaryTerms", GLOSSARY_TERMS_FIELD);
                    put("id", ID_FIELD);
                    put("lastDeployment", LAST_DEPLOYMENT_FIELD);
                    put("name", NAME_FIELD);
                    put("projectId", PROJECT_ID_FIELD);
                    put("provider", PROVIDER_FIELD);
                    put("provisionedResources", PROVISIONED_RESOURCES_FIELD);
                    put("provisioningProperties", PROVISIONING_PROPERTIES_FIELD);
                    put("status", STATUS_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("userParameters", USER_PARAMETERS_FIELD);
                }
            });

    private final String awsAccountId;

    private final String awsAccountRegion;

    private final Instant createdAt;

    private final String createdBy;

    private final DeploymentProperties deploymentProperties;

    private final String description;

    private final String domainId;

    private final List<ConfigurableEnvironmentAction> environmentActions;

    private final String environmentBlueprintId;

    private final String environmentProfileId;

    private final List<String> glossaryTerms;

    private final String id;

    private final Deployment lastDeployment;

    private final String name;

    private final String projectId;

    private final String provider;

    private final List<Resource> provisionedResources;

    private final ProvisioningProperties provisioningProperties;

    private final String status;

    private final Instant updatedAt;

    private final List<CustomParameter> userParameters;

    private GetEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.awsAccountRegion = builder.awsAccountRegion;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.deploymentProperties = builder.deploymentProperties;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.environmentActions = builder.environmentActions;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.environmentProfileId = builder.environmentProfileId;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.lastDeployment = builder.lastDeployment;
        this.name = builder.name;
        this.projectId = builder.projectId;
        this.provider = builder.provider;
        this.provisionedResources = builder.provisionedResources;
        this.provisioningProperties = builder.provisioningProperties;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.userParameters = builder.userParameters;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account where the environment exists.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account where the environment exists.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services region where the environment exists.
     * </p>
     * 
     * @return The Amazon Web Services region where the environment exists.
     */
    public final String awsAccountRegion() {
        return awsAccountRegion;
    }

    /**
     * <p>
     * The timestamp of when the environment was created.
     * </p>
     * 
     * @return The timestamp of when the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon DataZone user who created the environment.
     * </p>
     * 
     * @return The Amazon DataZone user who created the environment.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The deployment properties of the environment.
     * </p>
     * 
     * @return The deployment properties of the environment.
     */
    public final DeploymentProperties deploymentProperties() {
        return deploymentProperties;
    }

    /**
     * <p>
     * The description of the environment.
     * </p>
     * 
     * @return The description of the environment.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain where the environment exists.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain where the environment exists.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentActions() {
        return environmentActions != null && !(environmentActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions of the environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentActions} method.
     * </p>
     * 
     * @return The actions of the environment.
     */
    public final List<ConfigurableEnvironmentAction> environmentActions() {
        return environmentActions;
    }

    /**
     * <p>
     * The blueprint with which the environment is created.
     * </p>
     * 
     * @return The blueprint with which the environment is created.
     */
    public final String environmentBlueprintId() {
        return environmentBlueprintId;
    }

    /**
     * <p>
     * The ID of the environment profile with which the environment is created.
     * </p>
     * 
     * @return The ID of the environment profile with which the environment is created.
     */
    public final String environmentProfileId() {
        return environmentProfileId;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlossaryTerms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlossaryTerms() {
        return glossaryTerms != null && !(glossaryTerms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The business glossary terms that can be used in this environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlossaryTerms} method.
     * </p>
     * 
     * @return The business glossary terms that can be used in this environment.
     */
    public final List<String> glossaryTerms() {
        return glossaryTerms;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The details of the last deployment of the environment.
     * </p>
     * 
     * @return The details of the last deployment of the environment.
     */
    public final Deployment lastDeployment() {
        return lastDeployment;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone project in which this environment is created.
     * </p>
     * 
     * @return The ID of the Amazon DataZone project in which this environment is created.
     */
    public final String projectId() {
        return projectId;
    }

    /**
     * <p>
     * The provider of this Amazon DataZone environment.
     * </p>
     * 
     * @return The provider of this Amazon DataZone environment.
     */
    public final String provider() {
        return provider;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProvisionedResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProvisionedResources() {
        return provisionedResources != null && !(provisionedResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The provisioned resources of this Amazon DataZone environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProvisionedResources} method.
     * </p>
     * 
     * @return The provisioned resources of this Amazon DataZone environment.
     */
    public final List<Resource> provisionedResources() {
        return provisionedResources;
    }

    /**
     * <p>
     * The provisioning properties of this Amazon DataZone environment.
     * </p>
     * 
     * @return The provisioning properties of this Amazon DataZone environment.
     */
    public final ProvisioningProperties provisioningProperties() {
        return provisioningProperties;
    }

    /**
     * <p>
     * The status of this Amazon DataZone environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this Amazon DataZone environment.
     * @see EnvironmentStatus
     */
    public final EnvironmentStatus status() {
        return EnvironmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this Amazon DataZone environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this Amazon DataZone environment.
     * @see EnvironmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of when this environment was updated.
     * </p>
     * 
     * @return The timestamp of when this environment was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserParameters() {
        return userParameters != null && !(userParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user parameters of this Amazon DataZone environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserParameters} method.
     * </p>
     * 
     * @return The user parameters of this Amazon DataZone environment.
     */
    public final List<CustomParameter> userParameters() {
        return userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountRegion());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentProperties());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentActions() ? environmentActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlossaryTerms() ? glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(projectId());
        hashCode = 31 * hashCode + Objects.hashCode(provider());
        hashCode = 31 * hashCode + Objects.hashCode(hasProvisionedResources() ? provisionedResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserParameters() ? userParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentResponse)) {
            return false;
        }
        GetEnvironmentResponse other = (GetEnvironmentResponse) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(awsAccountRegion(), other.awsAccountRegion()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(deploymentProperties(), other.deploymentProperties())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && hasEnvironmentActions() == other.hasEnvironmentActions()
                && Objects.equals(environmentActions(), other.environmentActions())
                && Objects.equals(environmentBlueprintId(), other.environmentBlueprintId())
                && Objects.equals(environmentProfileId(), other.environmentProfileId())
                && hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(glossaryTerms(), other.glossaryTerms())
                && Objects.equals(id(), other.id()) && Objects.equals(lastDeployment(), other.lastDeployment())
                && Objects.equals(name(), other.name()) && Objects.equals(projectId(), other.projectId())
                && Objects.equals(provider(), other.provider()) && hasProvisionedResources() == other.hasProvisionedResources()
                && Objects.equals(provisionedResources(), other.provisionedResources())
                && Objects.equals(provisioningProperties(), other.provisioningProperties())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt())
                && hasUserParameters() == other.hasUserParameters() && Objects.equals(userParameters(), other.userParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEnvironmentResponse").add("AwsAccountId", awsAccountId())
                .add("AwsAccountRegion", awsAccountRegion()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("DeploymentProperties", deploymentProperties())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("DomainId", domainId())
                .add("EnvironmentActions", hasEnvironmentActions() ? environmentActions() : null)
                .add("EnvironmentBlueprintId", environmentBlueprintId()).add("EnvironmentProfileId", environmentProfileId())
                .add("GlossaryTerms", hasGlossaryTerms() ? glossaryTerms() : null).add("Id", id())
                .add("LastDeployment", lastDeployment()).add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProjectId", projectId()).add("Provider", provider())
                .add("ProvisionedResources", hasProvisionedResources() ? provisionedResources() : null)
                .add("ProvisioningProperties", provisioningProperties()).add("Status", statusAsString())
                .add("UpdatedAt", updatedAt()).add("UserParameters", hasUserParameters() ? userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "awsAccountRegion":
            return Optional.ofNullable(clazz.cast(awsAccountRegion()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "deploymentProperties":
            return Optional.ofNullable(clazz.cast(deploymentProperties()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "environmentActions":
            return Optional.ofNullable(clazz.cast(environmentActions()));
        case "environmentBlueprintId":
            return Optional.ofNullable(clazz.cast(environmentBlueprintId()));
        case "environmentProfileId":
            return Optional.ofNullable(clazz.cast(environmentProfileId()));
        case "glossaryTerms":
            return Optional.ofNullable(clazz.cast(glossaryTerms()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastDeployment":
            return Optional.ofNullable(clazz.cast(lastDeployment()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "projectId":
            return Optional.ofNullable(clazz.cast(projectId()));
        case "provider":
            return Optional.ofNullable(clazz.cast(provider()));
        case "provisionedResources":
            return Optional.ofNullable(clazz.cast(provisionedResources()));
        case "provisioningProperties":
            return Optional.ofNullable(clazz.cast(provisioningProperties()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "userParameters":
            return Optional.ofNullable(clazz.cast(userParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentResponse, T> g) {
        return obj -> g.apply((GetEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEnvironmentResponse> {
        /**
         * <p>
         * The ID of the Amazon Web Services account where the environment exists.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account where the environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The Amazon Web Services region where the environment exists.
         * </p>
         * 
         * @param awsAccountRegion
         *        The Amazon Web Services region where the environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountRegion(String awsAccountRegion);

        /**
         * <p>
         * The timestamp of when the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon DataZone user who created the environment.
         * </p>
         * 
         * @param createdBy
         *        The Amazon DataZone user who created the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The deployment properties of the environment.
         * </p>
         * 
         * @param deploymentProperties
         *        The deployment properties of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentProperties(DeploymentProperties deploymentProperties);

        /**
         * <p>
         * The deployment properties of the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentProperties.Builder} avoiding
         * the need to create one manually via {@link DeploymentProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #deploymentProperties(DeploymentProperties)}.
         * 
         * @param deploymentProperties
         *        a consumer that will call methods on {@link DeploymentProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentProperties(DeploymentProperties)
         */
        default Builder deploymentProperties(Consumer<DeploymentProperties.Builder> deploymentProperties) {
            return deploymentProperties(DeploymentProperties.builder().applyMutation(deploymentProperties).build());
        }

        /**
         * <p>
         * The description of the environment.
         * </p>
         * 
         * @param description
         *        The description of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the Amazon DataZone domain where the environment exists.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain where the environment exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The actions of the environment.
         * </p>
         * 
         * @param environmentActions
         *        The actions of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentActions(Collection<ConfigurableEnvironmentAction> environmentActions);

        /**
         * <p>
         * The actions of the environment.
         * </p>
         * 
         * @param environmentActions
         *        The actions of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentActions(ConfigurableEnvironmentAction... environmentActions);

        /**
         * <p>
         * The actions of the environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #environmentActions(List<ConfigurableEnvironmentAction>)}.
         * 
         * @param environmentActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.ConfigurableEnvironmentAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentActions(java.util.Collection<ConfigurableEnvironmentAction>)
         */
        Builder environmentActions(Consumer<ConfigurableEnvironmentAction.Builder>... environmentActions);

        /**
         * <p>
         * The blueprint with which the environment is created.
         * </p>
         * 
         * @param environmentBlueprintId
         *        The blueprint with which the environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentBlueprintId(String environmentBlueprintId);

        /**
         * <p>
         * The ID of the environment profile with which the environment is created.
         * </p>
         * 
         * @param environmentProfileId
         *        The ID of the environment profile with which the environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentProfileId(String environmentProfileId);

        /**
         * <p>
         * The business glossary terms that can be used in this environment.
         * </p>
         * 
         * @param glossaryTerms
         *        The business glossary terms that can be used in this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(Collection<String> glossaryTerms);

        /**
         * <p>
         * The business glossary terms that can be used in this environment.
         * </p>
         * 
         * @param glossaryTerms
         *        The business glossary terms that can be used in this environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glossaryTerms(String... glossaryTerms);

        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param id
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The details of the last deployment of the environment.
         * </p>
         * 
         * @param lastDeployment
         *        The details of the last deployment of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeployment(Deployment lastDeployment);

        /**
         * <p>
         * The details of the last deployment of the environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link Deployment.Builder} avoiding the need to
         * create one manually via {@link Deployment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Deployment.Builder#build()} is called immediately and its result
         * is passed to {@link #lastDeployment(Deployment)}.
         * 
         * @param lastDeployment
         *        a consumer that will call methods on {@link Deployment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastDeployment(Deployment)
         */
        default Builder lastDeployment(Consumer<Deployment.Builder> lastDeployment) {
            return lastDeployment(Deployment.builder().applyMutation(lastDeployment).build());
        }

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the Amazon DataZone project in which this environment is created.
         * </p>
         * 
         * @param projectId
         *        The ID of the Amazon DataZone project in which this environment is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectId(String projectId);

        /**
         * <p>
         * The provider of this Amazon DataZone environment.
         * </p>
         * 
         * @param provider
         *        The provider of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provider(String provider);

        /**
         * <p>
         * The provisioned resources of this Amazon DataZone environment.
         * </p>
         * 
         * @param provisionedResources
         *        The provisioned resources of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedResources(Collection<Resource> provisionedResources);

        /**
         * <p>
         * The provisioned resources of this Amazon DataZone environment.
         * </p>
         * 
         * @param provisionedResources
         *        The provisioned resources of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedResources(Resource... provisionedResources);

        /**
         * <p>
         * The provisioned resources of this Amazon DataZone environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.Resource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.Resource.Builder#build()} is called immediately and its
         * result is passed to {@link #provisionedResources(List<Resource>)}.
         * 
         * @param provisionedResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedResources(java.util.Collection<Resource>)
         */
        Builder provisionedResources(Consumer<Resource.Builder>... provisionedResources);

        /**
         * <p>
         * The provisioning properties of this Amazon DataZone environment.
         * </p>
         * 
         * @param provisioningProperties
         *        The provisioning properties of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningProperties(ProvisioningProperties provisioningProperties);

        /**
         * <p>
         * The provisioning properties of this Amazon DataZone environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisioningProperties.Builder} avoiding
         * the need to create one manually via {@link ProvisioningProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisioningProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #provisioningProperties(ProvisioningProperties)}.
         * 
         * @param provisioningProperties
         *        a consumer that will call methods on {@link ProvisioningProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisioningProperties(ProvisioningProperties)
         */
        default Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return provisioningProperties(ProvisioningProperties.builder().applyMutation(provisioningProperties).build());
        }

        /**
         * <p>
         * The status of this Amazon DataZone environment.
         * </p>
         * 
         * @param status
         *        The status of this Amazon DataZone environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this Amazon DataZone environment.
         * </p>
         * 
         * @param status
         *        The status of this Amazon DataZone environment.
         * @see EnvironmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentStatus
         */
        Builder status(EnvironmentStatus status);

        /**
         * <p>
         * The timestamp of when this environment was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when this environment was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(Collection<CustomParameter> userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment.
         * </p>
         * 
         * @param userParameters
         *        The user parameters of this Amazon DataZone environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userParameters(CustomParameter... userParameters);

        /**
         * <p>
         * The user parameters of this Amazon DataZone environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.datazone.model.CustomParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #userParameters(List<CustomParameter>)}.
         * 
         * @param userParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.CustomParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userParameters(java.util.Collection<CustomParameter>)
         */
        Builder userParameters(Consumer<CustomParameter.Builder>... userParameters);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String awsAccountId;

        private String awsAccountRegion;

        private Instant createdAt;

        private String createdBy;

        private DeploymentProperties deploymentProperties;

        private String description;

        private String domainId;

        private List<ConfigurableEnvironmentAction> environmentActions = DefaultSdkAutoConstructList.getInstance();

        private String environmentBlueprintId;

        private String environmentProfileId;

        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private Deployment lastDeployment;

        private String name;

        private String projectId;

        private String provider;

        private List<Resource> provisionedResources = DefaultSdkAutoConstructList.getInstance();

        private ProvisioningProperties provisioningProperties;

        private String status;

        private Instant updatedAt;

        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentResponse model) {
            super(model);
            awsAccountId(model.awsAccountId);
            awsAccountRegion(model.awsAccountRegion);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            deploymentProperties(model.deploymentProperties);
            description(model.description);
            domainId(model.domainId);
            environmentActions(model.environmentActions);
            environmentBlueprintId(model.environmentBlueprintId);
            environmentProfileId(model.environmentProfileId);
            glossaryTerms(model.glossaryTerms);
            id(model.id);
            lastDeployment(model.lastDeployment);
            name(model.name);
            projectId(model.projectId);
            provider(model.provider);
            provisionedResources(model.provisionedResources);
            provisioningProperties(model.provisioningProperties);
            status(model.status);
            updatedAt(model.updatedAt);
            userParameters(model.userParameters);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsAccountRegion() {
            return awsAccountRegion;
        }

        public final void setAwsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
        }

        @Override
        public final Builder awsAccountRegion(String awsAccountRegion) {
            this.awsAccountRegion = awsAccountRegion;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final DeploymentProperties.Builder getDeploymentProperties() {
            return deploymentProperties != null ? deploymentProperties.toBuilder() : null;
        }

        public final void setDeploymentProperties(DeploymentProperties.BuilderImpl deploymentProperties) {
            this.deploymentProperties = deploymentProperties != null ? deploymentProperties.build() : null;
        }

        @Override
        public final Builder deploymentProperties(DeploymentProperties deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<ConfigurableEnvironmentAction.Builder> getEnvironmentActions() {
            List<ConfigurableEnvironmentAction.Builder> result = EnvironmentActionListCopier
                    .copyToBuilder(this.environmentActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentActions(Collection<ConfigurableEnvironmentAction.BuilderImpl> environmentActions) {
            this.environmentActions = EnvironmentActionListCopier.copyFromBuilder(environmentActions);
        }

        @Override
        public final Builder environmentActions(Collection<ConfigurableEnvironmentAction> environmentActions) {
            this.environmentActions = EnvironmentActionListCopier.copy(environmentActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentActions(ConfigurableEnvironmentAction... environmentActions) {
            environmentActions(Arrays.asList(environmentActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentActions(Consumer<ConfigurableEnvironmentAction.Builder>... environmentActions) {
            environmentActions(Stream.of(environmentActions)
                    .map(c -> ConfigurableEnvironmentAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getEnvironmentProfileId() {
            return environmentProfileId;
        }

        public final void setEnvironmentProfileId(String environmentProfileId) {
            this.environmentProfileId = environmentProfileId;
        }

        @Override
        public final Builder environmentProfileId(String environmentProfileId) {
            this.environmentProfileId = environmentProfileId;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String... glossaryTerms) {
            glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Deployment.Builder getLastDeployment() {
            return lastDeployment != null ? lastDeployment.toBuilder() : null;
        }

        public final void setLastDeployment(Deployment.BuilderImpl lastDeployment) {
            this.lastDeployment = lastDeployment != null ? lastDeployment.build() : null;
        }

        @Override
        public final Builder lastDeployment(Deployment lastDeployment) {
            this.lastDeployment = lastDeployment;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectId() {
            return projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getProvider() {
            return provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<Resource.Builder> getProvisionedResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.provisionedResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisionedResources(Collection<Resource.BuilderImpl> provisionedResources) {
            this.provisionedResources = ResourceListCopier.copyFromBuilder(provisionedResources);
        }

        @Override
        public final Builder provisionedResources(Collection<Resource> provisionedResources) {
            this.provisionedResources = ResourceListCopier.copy(provisionedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(Resource... provisionedResources) {
            provisionedResources(Arrays.asList(provisionedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedResources(Consumer<Resource.Builder>... provisionedResources) {
            provisionedResources(Stream.of(provisionedResources).map(c -> Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return provisioningProperties != null ? provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter... userParameters) {
            userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder>... userParameters) {
            userParameters(Stream.of(userParameters).map(c -> CustomParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEnvironmentResponse build() {
            return new GetEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
