/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIamPortalLoginUrlResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetIamPortalLoginUrlResponse.Builder, GetIamPortalLoginUrlResponse> {
    private static final SdkField<String> AUTH_CODE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authCodeUrl").getter(getter(GetIamPortalLoginUrlResponse::authCodeUrl))
            .setter(setter(Builder::authCodeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authCodeUrl").build()).build();

    private static final SdkField<String> USER_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userProfileId").getter(getter(GetIamPortalLoginUrlResponse::userProfileId))
            .setter(setter(Builder::userProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CODE_URL_FIELD,
            USER_PROFILE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("authCodeUrl", AUTH_CODE_URL_FIELD);
                    put("userProfileId", USER_PROFILE_ID_FIELD);
                }
            });

    private final String authCodeUrl;

    private final String userProfileId;

    private GetIamPortalLoginUrlResponse(BuilderImpl builder) {
        super(builder);
        this.authCodeUrl = builder.authCodeUrl;
        this.userProfileId = builder.userProfileId;
    }

    /**
     * <p>
     * The data portal URL of the specified Amazon DataZone domain.
     * </p>
     * 
     * @return The data portal URL of the specified Amazon DataZone domain.
     */
    public final String authCodeUrl() {
        return authCodeUrl;
    }

    /**
     * <p>
     * The ID of the user profile.
     * </p>
     * 
     * @return The ID of the user profile.
     */
    public final String userProfileId() {
        return userProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(userProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIamPortalLoginUrlResponse)) {
            return false;
        }
        GetIamPortalLoginUrlResponse other = (GetIamPortalLoginUrlResponse) obj;
        return Objects.equals(authCodeUrl(), other.authCodeUrl()) && Objects.equals(userProfileId(), other.userProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIamPortalLoginUrlResponse").add("AuthCodeUrl", authCodeUrl())
                .add("UserProfileId", userProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authCodeUrl":
            return Optional.ofNullable(clazz.cast(authCodeUrl()));
        case "userProfileId":
            return Optional.ofNullable(clazz.cast(userProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetIamPortalLoginUrlResponse, T> g) {
        return obj -> g.apply((GetIamPortalLoginUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIamPortalLoginUrlResponse> {
        /**
         * <p>
         * The data portal URL of the specified Amazon DataZone domain.
         * </p>
         * 
         * @param authCodeUrl
         *        The data portal URL of the specified Amazon DataZone domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authCodeUrl(String authCodeUrl);

        /**
         * <p>
         * The ID of the user profile.
         * </p>
         * 
         * @param userProfileId
         *        The ID of the user profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfileId(String userProfileId);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String authCodeUrl;

        private String userProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIamPortalLoginUrlResponse model) {
            super(model);
            authCodeUrl(model.authCodeUrl);
            userProfileId(model.userProfileId);
        }

        public final String getAuthCodeUrl() {
            return authCodeUrl;
        }

        public final void setAuthCodeUrl(String authCodeUrl) {
            this.authCodeUrl = authCodeUrl;
        }

        @Override
        public final Builder authCodeUrl(String authCodeUrl) {
            this.authCodeUrl = authCodeUrl;
            return this;
        }

        public final String getUserProfileId() {
            return userProfileId;
        }

        public final void setUserProfileId(String userProfileId) {
            this.userProfileId = userProfileId;
        }

        @Override
        public final Builder userProfileId(String userProfileId) {
            this.userProfileId = userProfileId;
            return this;
        }

        @Override
        public GetIamPortalLoginUrlResponse build() {
            return new GetIamPortalLoginUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
