/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLineageNodeResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetLineageNodeResponse.Builder, GetLineageNodeResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetLineageNodeResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetLineageNodeResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetLineageNodeResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetLineageNodeResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<List<LineageNodeReference>> DOWNSTREAM_NODES_FIELD = SdkField
            .<List<LineageNodeReference>> builder(MarshallingType.LIST)
            .memberName("downstreamNodes")
            .getter(getter(GetLineageNodeResponse::downstreamNodes))
            .setter(setter(Builder::downstreamNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downstreamNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineageNodeReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineageNodeReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> EVENT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("eventTimestamp").getter(getter(GetLineageNodeResponse::eventTimestamp))
            .setter(setter(Builder::eventTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()).build();

    private static final SdkField<List<FormOutput>> FORMS_OUTPUT_FIELD = SdkField
            .<List<FormOutput>> builder(MarshallingType.LIST)
            .memberName("formsOutput")
            .getter(getter(GetLineageNodeResponse::formsOutput))
            .setter(setter(Builder::formsOutput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsOutput").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FormOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(FormOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetLineageNodeResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetLineageNodeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceIdentifier").getter(getter(GetLineageNodeResponse::sourceIdentifier))
            .setter(setter(Builder::sourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIdentifier").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(GetLineageNodeResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeRevision").getter(getter(GetLineageNodeResponse::typeRevision))
            .setter(setter(Builder::typeRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetLineageNodeResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetLineageNodeResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<List<LineageNodeReference>> UPSTREAM_NODES_FIELD = SdkField
            .<List<LineageNodeReference>> builder(MarshallingType.LIST)
            .memberName("upstreamNodes")
            .getter(getter(GetLineageNodeResponse::upstreamNodes))
            .setter(setter(Builder::upstreamNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LineageNodeReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(LineageNodeReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOWNSTREAM_NODES_FIELD, EVENT_TIMESTAMP_FIELD,
            FORMS_OUTPUT_FIELD, ID_FIELD, NAME_FIELD, SOURCE_IDENTIFIER_FIELD, TYPE_NAME_FIELD, TYPE_REVISION_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD, UPSTREAM_NODES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("createdAt", CREATED_AT_FIELD);
                    put("createdBy", CREATED_BY_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("domainId", DOMAIN_ID_FIELD);
                    put("downstreamNodes", DOWNSTREAM_NODES_FIELD);
                    put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
                    put("formsOutput", FORMS_OUTPUT_FIELD);
                    put("id", ID_FIELD);
                    put("name", NAME_FIELD);
                    put("sourceIdentifier", SOURCE_IDENTIFIER_FIELD);
                    put("typeName", TYPE_NAME_FIELD);
                    put("typeRevision", TYPE_REVISION_FIELD);
                    put("updatedAt", UPDATED_AT_FIELD);
                    put("updatedBy", UPDATED_BY_FIELD);
                    put("upstreamNodes", UPSTREAM_NODES_FIELD);
                }
            });

    private final Instant createdAt;

    private final String createdBy;

    private final String description;

    private final String domainId;

    private final List<LineageNodeReference> downstreamNodes;

    private final Instant eventTimestamp;

    private final List<FormOutput> formsOutput;

    private final String id;

    private final String name;

    private final String sourceIdentifier;

    private final String typeName;

    private final String typeRevision;

    private final Instant updatedAt;

    private final String updatedBy;

    private final List<LineageNodeReference> upstreamNodes;

    private GetLineageNodeResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.downstreamNodes = builder.downstreamNodes;
        this.eventTimestamp = builder.eventTimestamp;
        this.formsOutput = builder.formsOutput;
        this.id = builder.id;
        this.name = builder.name;
        this.sourceIdentifier = builder.sourceIdentifier;
        this.typeName = builder.typeName;
        this.typeRevision = builder.typeRevision;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.upstreamNodes = builder.upstreamNodes;
    }

    /**
     * <p>
     * The timestamp at which the data lineage node was created.
     * </p>
     * 
     * @return The timestamp at which the data lineage node was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user who created the data lineage node.
     * </p>
     * 
     * @return The user who created the data lineage node.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The description of the data lineage node.
     * </p>
     * 
     * @return The description of the data lineage node.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the domain where you're getting the data lineage node.
     * </p>
     * 
     * @return The ID of the domain where you're getting the data lineage node.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DownstreamNodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDownstreamNodes() {
        return downstreamNodes != null && !(downstreamNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The downsteam nodes of the specified data lineage node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDownstreamNodes} method.
     * </p>
     * 
     * @return The downsteam nodes of the specified data lineage node.
     */
    public final List<LineageNodeReference> downstreamNodes() {
        return downstreamNodes;
    }

    /**
     * <p>
     * The timestamp of the event described in the data lineage node.
     * </p>
     * 
     * @return The timestamp of the event described in the data lineage node.
     */
    public final Instant eventTimestamp() {
        return eventTimestamp;
    }

    /**
     * For responses, this returns true if the service returned a value for the FormsOutput property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormsOutput() {
        return formsOutput != null && !(formsOutput instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata of the specified data lineage node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormsOutput} method.
     * </p>
     * 
     * @return The metadata of the specified data lineage node.
     */
    public final List<FormOutput> formsOutput() {
        return formsOutput;
    }

    /**
     * <p>
     * The ID of the data lineage node.
     * </p>
     * 
     * @return The ID of the data lineage node.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the data lineage node.
     * </p>
     * 
     * @return The name of the data lineage node.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The source identifier of the data lineage node.
     * </p>
     * 
     * @return The source identifier of the data lineage node.
     */
    public final String sourceIdentifier() {
        return sourceIdentifier;
    }

    /**
     * <p>
     * The name of the type of the specified data lineage node.
     * </p>
     * 
     * @return The name of the type of the specified data lineage node.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The revision type of the specified data lineage node.
     * </p>
     * 
     * @return The revision type of the specified data lineage node.
     */
    public final String typeRevision() {
        return typeRevision;
    }

    /**
     * <p>
     * The timestamp at which the data lineage node was updated.
     * </p>
     * 
     * @return The timestamp at which the data lineage node was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user who updated the data lineage node.
     * </p>
     * 
     * @return The user who updated the data lineage node.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpstreamNodes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUpstreamNodes() {
        return upstreamNodes != null && !(upstreamNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The upstream nodes of the specified data lineage node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpstreamNodes} method.
     * </p>
     * 
     * @return The upstream nodes of the specified data lineage node.
     */
    public final List<LineageNodeReference> upstreamNodes() {
        return upstreamNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDownstreamNodes() ? downstreamNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormsOutput() ? formsOutput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeRevision());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(hasUpstreamNodes() ? upstreamNodes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLineageNodeResponse)) {
            return false;
        }
        GetLineageNodeResponse other = (GetLineageNodeResponse) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(description(), other.description()) && Objects.equals(domainId(), other.domainId())
                && hasDownstreamNodes() == other.hasDownstreamNodes()
                && Objects.equals(downstreamNodes(), other.downstreamNodes())
                && Objects.equals(eventTimestamp(), other.eventTimestamp()) && hasFormsOutput() == other.hasFormsOutput()
                && Objects.equals(formsOutput(), other.formsOutput()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(sourceIdentifier(), other.sourceIdentifier())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(typeRevision(), other.typeRevision())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && hasUpstreamNodes() == other.hasUpstreamNodes() && Objects.equals(upstreamNodes(), other.upstreamNodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLineageNodeResponse").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("Description", description()).add("DomainId", domainId())
                .add("DownstreamNodes", hasDownstreamNodes() ? downstreamNodes() : null).add("EventTimestamp", eventTimestamp())
                .add("FormsOutput", hasFormsOutput() ? formsOutput() : null).add("Id", id()).add("Name", name())
                .add("SourceIdentifier", sourceIdentifier()).add("TypeName", typeName()).add("TypeRevision", typeRevision())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy())
                .add("UpstreamNodes", hasUpstreamNodes() ? upstreamNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "downstreamNodes":
            return Optional.ofNullable(clazz.cast(downstreamNodes()));
        case "eventTimestamp":
            return Optional.ofNullable(clazz.cast(eventTimestamp()));
        case "formsOutput":
            return Optional.ofNullable(clazz.cast(formsOutput()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceIdentifier":
            return Optional.ofNullable(clazz.cast(sourceIdentifier()));
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "typeRevision":
            return Optional.ofNullable(clazz.cast(typeRevision()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "upstreamNodes":
            return Optional.ofNullable(clazz.cast(upstreamNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetLineageNodeResponse, T> g) {
        return obj -> g.apply((GetLineageNodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLineageNodeResponse> {
        /**
         * <p>
         * The timestamp at which the data lineage node was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp at which the data lineage node was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user who created the data lineage node.
         * </p>
         * 
         * @param createdBy
         *        The user who created the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The description of the data lineage node.
         * </p>
         * 
         * @param description
         *        The description of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the domain where you're getting the data lineage node.
         * </p>
         * 
         * @param domainId
         *        The ID of the domain where you're getting the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The downsteam nodes of the specified data lineage node.
         * </p>
         * 
         * @param downstreamNodes
         *        The downsteam nodes of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downstreamNodes(Collection<LineageNodeReference> downstreamNodes);

        /**
         * <p>
         * The downsteam nodes of the specified data lineage node.
         * </p>
         * 
         * @param downstreamNodes
         *        The downsteam nodes of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downstreamNodes(LineageNodeReference... downstreamNodes);

        /**
         * <p>
         * The downsteam nodes of the specified data lineage node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference.Builder#build()} is called
         * immediately and its result is passed to {@link #downstreamNodes(List<LineageNodeReference>)}.
         * 
         * @param downstreamNodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downstreamNodes(java.util.Collection<LineageNodeReference>)
         */
        Builder downstreamNodes(Consumer<LineageNodeReference.Builder>... downstreamNodes);

        /**
         * <p>
         * The timestamp of the event described in the data lineage node.
         * </p>
         * 
         * @param eventTimestamp
         *        The timestamp of the event described in the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTimestamp(Instant eventTimestamp);

        /**
         * <p>
         * The metadata of the specified data lineage node.
         * </p>
         * 
         * @param formsOutput
         *        The metadata of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(Collection<FormOutput> formsOutput);

        /**
         * <p>
         * The metadata of the specified data lineage node.
         * </p>
         * 
         * @param formsOutput
         *        The metadata of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formsOutput(FormOutput... formsOutput);

        /**
         * <p>
         * The metadata of the specified data lineage node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.datazone.model.FormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #formsOutput(List<FormOutput>)}.
         * 
         * @param formsOutput
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.FormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #formsOutput(java.util.Collection<FormOutput>)
         */
        Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput);

        /**
         * <p>
         * The ID of the data lineage node.
         * </p>
         * 
         * @param id
         *        The ID of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the data lineage node.
         * </p>
         * 
         * @param name
         *        The name of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The source identifier of the data lineage node.
         * </p>
         * 
         * @param sourceIdentifier
         *        The source identifier of the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdentifier(String sourceIdentifier);

        /**
         * <p>
         * The name of the type of the specified data lineage node.
         * </p>
         * 
         * @param typeName
         *        The name of the type of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The revision type of the specified data lineage node.
         * </p>
         * 
         * @param typeRevision
         *        The revision type of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeRevision(String typeRevision);

        /**
         * <p>
         * The timestamp at which the data lineage node was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp at which the data lineage node was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user who updated the data lineage node.
         * </p>
         * 
         * @param updatedBy
         *        The user who updated the data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The upstream nodes of the specified data lineage node.
         * </p>
         * 
         * @param upstreamNodes
         *        The upstream nodes of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamNodes(Collection<LineageNodeReference> upstreamNodes);

        /**
         * <p>
         * The upstream nodes of the specified data lineage node.
         * </p>
         * 
         * @param upstreamNodes
         *        The upstream nodes of the specified data lineage node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamNodes(LineageNodeReference... upstreamNodes);

        /**
         * <p>
         * The upstream nodes of the specified data lineage node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference.Builder#build()} is called
         * immediately and its result is passed to {@link #upstreamNodes(List<LineageNodeReference>)}.
         * 
         * @param upstreamNodes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.LineageNodeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upstreamNodes(java.util.Collection<LineageNodeReference>)
         */
        Builder upstreamNodes(Consumer<LineageNodeReference.Builder>... upstreamNodes);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private String description;

        private String domainId;

        private List<LineageNodeReference> downstreamNodes = DefaultSdkAutoConstructList.getInstance();

        private Instant eventTimestamp;

        private List<FormOutput> formsOutput = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String name;

        private String sourceIdentifier;

        private String typeName;

        private String typeRevision;

        private Instant updatedAt;

        private String updatedBy;

        private List<LineageNodeReference> upstreamNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLineageNodeResponse model) {
            super(model);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            description(model.description);
            domainId(model.domainId);
            downstreamNodes(model.downstreamNodes);
            eventTimestamp(model.eventTimestamp);
            formsOutput(model.formsOutput);
            id(model.id);
            name(model.name);
            sourceIdentifier(model.sourceIdentifier);
            typeName(model.typeName);
            typeRevision(model.typeRevision);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            upstreamNodes(model.upstreamNodes);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final List<LineageNodeReference.Builder> getDownstreamNodes() {
            List<LineageNodeReference.Builder> result = LineageNodeReferenceListCopier.copyToBuilder(this.downstreamNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDownstreamNodes(Collection<LineageNodeReference.BuilderImpl> downstreamNodes) {
            this.downstreamNodes = LineageNodeReferenceListCopier.copyFromBuilder(downstreamNodes);
        }

        @Override
        public final Builder downstreamNodes(Collection<LineageNodeReference> downstreamNodes) {
            this.downstreamNodes = LineageNodeReferenceListCopier.copy(downstreamNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder downstreamNodes(LineageNodeReference... downstreamNodes) {
            downstreamNodes(Arrays.asList(downstreamNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder downstreamNodes(Consumer<LineageNodeReference.Builder>... downstreamNodes) {
            downstreamNodes(Stream.of(downstreamNodes).map(c -> LineageNodeReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getEventTimestamp() {
            return eventTimestamp;
        }

        public final void setEventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(Instant eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final List<FormOutput.Builder> getFormsOutput() {
            List<FormOutput.Builder> result = FormOutputListCopier.copyToBuilder(this.formsOutput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsOutput(Collection<FormOutput.BuilderImpl> formsOutput) {
            this.formsOutput = FormOutputListCopier.copyFromBuilder(formsOutput);
        }

        @Override
        public final Builder formsOutput(Collection<FormOutput> formsOutput) {
            this.formsOutput = FormOutputListCopier.copy(formsOutput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(FormOutput... formsOutput) {
            formsOutput(Arrays.asList(formsOutput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsOutput(Consumer<FormOutput.Builder>... formsOutput) {
            formsOutput(Stream.of(formsOutput).map(c -> FormOutput.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceIdentifier() {
            return sourceIdentifier;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeRevision() {
            return typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final List<LineageNodeReference.Builder> getUpstreamNodes() {
            List<LineageNodeReference.Builder> result = LineageNodeReferenceListCopier.copyToBuilder(this.upstreamNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpstreamNodes(Collection<LineageNodeReference.BuilderImpl> upstreamNodes) {
            this.upstreamNodes = LineageNodeReferenceListCopier.copyFromBuilder(upstreamNodes);
        }

        @Override
        public final Builder upstreamNodes(Collection<LineageNodeReference> upstreamNodes) {
            this.upstreamNodes = LineageNodeReferenceListCopier.copy(upstreamNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreamNodes(LineageNodeReference... upstreamNodes) {
            upstreamNodes(Arrays.asList(upstreamNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder upstreamNodes(Consumer<LineageNodeReference.Builder>... upstreamNodes) {
            upstreamNodes(Stream.of(upstreamNodes).map(c -> LineageNodeReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetLineageNodeResponse build() {
            return new GetLineageNodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
