/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTimeSeriesDataPointResponse extends DataZoneResponse implements
        ToCopyableBuilder<GetTimeSeriesDataPointResponse.Builder, GetTimeSeriesDataPointResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(GetTimeSeriesDataPointResponse::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(GetTimeSeriesDataPointResponse::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityType").getter(getter(GetTimeSeriesDataPointResponse::entityTypeAsString))
            .setter(setter(Builder::entityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();

    private static final SdkField<TimeSeriesDataPointFormOutput> FORM_FIELD = SdkField
            .<TimeSeriesDataPointFormOutput> builder(MarshallingType.SDK_POJO).memberName("form")
            .getter(getter(GetTimeSeriesDataPointResponse::form)).setter(setter(Builder::form))
            .constructor(TimeSeriesDataPointFormOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("form").build()).build();

    private static final SdkField<String> FORM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formName").getter(getter(GetTimeSeriesDataPointResponse::formName)).setter(setter(Builder::formName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, FORM_FIELD, FORM_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domainId", DOMAIN_ID_FIELD);
                    put("entityId", ENTITY_ID_FIELD);
                    put("entityType", ENTITY_TYPE_FIELD);
                    put("form", FORM_FIELD);
                    put("formName", FORM_NAME_FIELD);
                }
            });

    private final String domainId;

    private final String entityId;

    private final String entityType;

    private final TimeSeriesDataPointFormOutput form;

    private final String formName;

    private GetTimeSeriesDataPointResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.form = builder.form;
        this.formName = builder.formName;
    }

    /**
     * <p>
     * The ID of the Amazon DataZone domain that houses the asset data point that you want to get.
     * </p>
     * 
     * @return The ID of the Amazon DataZone domain that houses the asset data point that you want to get.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The ID of the asset for which you want to get the data point.
     * </p>
     * 
     * @return The ID of the asset for which you want to get the data point.
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The type of the asset for which you want to get the data point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to get the data point.
     * @see TimeSeriesEntityType
     */
    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(entityType);
    }

    /**
     * <p>
     * The type of the asset for which you want to get the data point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #entityType} will
     * return {@link TimeSeriesEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #entityTypeAsString}.
     * </p>
     * 
     * @return The type of the asset for which you want to get the data point.
     * @see TimeSeriesEntityType
     */
    public final String entityTypeAsString() {
        return entityType;
    }

    /**
     * <p>
     * The time series form that houses the data point that you want to get.
     * </p>
     * 
     * @return The time series form that houses the data point that you want to get.
     */
    public final TimeSeriesDataPointFormOutput form() {
        return form;
    }

    /**
     * <p>
     * The name of the time series form that houses the data point that you want to get.
     * </p>
     * 
     * @return The name of the time series form that houses the data point that you want to get.
     */
    public final String formName() {
        return formName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(form());
        hashCode = 31 * hashCode + Objects.hashCode(formName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesDataPointResponse)) {
            return false;
        }
        GetTimeSeriesDataPointResponse other = (GetTimeSeriesDataPointResponse) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(form(), other.form())
                && Objects.equals(formName(), other.formName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTimeSeriesDataPointResponse").add("DomainId", domainId()).add("EntityId", entityId())
                .add("EntityType", entityTypeAsString()).add("Form", form()).add("FormName", formName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "entityType":
            return Optional.ofNullable(clazz.cast(entityTypeAsString()));
        case "form":
            return Optional.ofNullable(clazz.cast(form()));
        case "formName":
            return Optional.ofNullable(clazz.cast(formName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesDataPointResponse, T> g) {
        return obj -> g.apply((GetTimeSeriesDataPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataZoneResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTimeSeriesDataPointResponse> {
        /**
         * <p>
         * The ID of the Amazon DataZone domain that houses the asset data point that you want to get.
         * </p>
         * 
         * @param domainId
         *        The ID of the Amazon DataZone domain that houses the asset data point that you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The ID of the asset for which you want to get the data point.
         * </p>
         * 
         * @param entityId
         *        The ID of the asset for which you want to get the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The type of the asset for which you want to get the data point.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to get the data point.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(String entityType);

        /**
         * <p>
         * The type of the asset for which you want to get the data point.
         * </p>
         * 
         * @param entityType
         *        The type of the asset for which you want to get the data point.
         * @see TimeSeriesEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeSeriesEntityType
         */
        Builder entityType(TimeSeriesEntityType entityType);

        /**
         * <p>
         * The time series form that houses the data point that you want to get.
         * </p>
         * 
         * @param form
         *        The time series form that houses the data point that you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder form(TimeSeriesDataPointFormOutput form);

        /**
         * <p>
         * The time series form that houses the data point that you want to get.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesDataPointFormOutput.Builder}
         * avoiding the need to create one manually via {@link TimeSeriesDataPointFormOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesDataPointFormOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #form(TimeSeriesDataPointFormOutput)}.
         * 
         * @param form
         *        a consumer that will call methods on {@link TimeSeriesDataPointFormOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #form(TimeSeriesDataPointFormOutput)
         */
        default Builder form(Consumer<TimeSeriesDataPointFormOutput.Builder> form) {
            return form(TimeSeriesDataPointFormOutput.builder().applyMutation(form).build());
        }

        /**
         * <p>
         * The name of the time series form that houses the data point that you want to get.
         * </p>
         * 
         * @param formName
         *        The name of the time series form that houses the data point that you want to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formName(String formName);
    }

    static final class BuilderImpl extends DataZoneResponse.BuilderImpl implements Builder {
        private String domainId;

        private String entityId;

        private String entityType;

        private TimeSeriesDataPointFormOutput form;

        private String formName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesDataPointResponse model) {
            super(model);
            domainId(model.domainId);
            entityId(model.entityId);
            entityType(model.entityType);
            form(model.form);
            formName(model.formName);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final TimeSeriesDataPointFormOutput.Builder getForm() {
            return form != null ? form.toBuilder() : null;
        }

        public final void setForm(TimeSeriesDataPointFormOutput.BuilderImpl form) {
            this.form = form != null ? form.build() : null;
        }

        @Override
        public final Builder form(TimeSeriesDataPointFormOutput form) {
            this.form = form;
            return this;
        }

        public final String getFormName() {
            return formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        @Override
        public GetTimeSeriesDataPointResponse build() {
            return new GetTimeSeriesDataPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
