/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Glue connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueConnection implements SdkPojo, Serializable, ToCopyableBuilder<GlueConnection.Builder, GlueConnection> {
    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("athenaProperties")
            .getter(getter(GlueConnection::athenaProperties))
            .setter(setter(Builder::athenaProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuthenticationConfiguration> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("authenticationConfiguration")
            .getter(getter(GlueConnection::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration")
                    .build()).build();

    private static final SdkField<List<String>> COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("compatibleComputeEnvironments")
            .getter(getter(GlueConnection::compatibleComputeEnvironmentsAsStrings))
            .setter(setter(Builder::compatibleComputeEnvironmentsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleComputeEnvironments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("connectionProperties")
            .getter(getter(GlueConnection::connectionProperties))
            .setter(setter(Builder::connectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> CONNECTION_SCHEMA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("connectionSchemaVersion").getter(getter(GlueConnection::connectionSchemaVersion))
            .setter(setter(Builder::connectionSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionSchemaVersion").build())
            .build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionType").getter(getter(GlueConnection::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GlueConnection::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GlueConnection::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_CONNECTION_VALIDATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastConnectionValidationTime")
            .getter(getter(GlueConnection::lastConnectionValidationTime))
            .setter(setter(Builder::lastConnectionValidationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastConnectionValidationTime")
                    .build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedBy").getter(getter(GlueConnection::lastUpdatedBy)).setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedBy").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedTime").getter(getter(GlueConnection::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final SdkField<List<String>> MATCH_CRITERIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("matchCriteria")
            .getter(getter(GlueConnection::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchCriteria").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GlueConnection::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<PhysicalConnectionRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("physicalConnectionRequirements")
            .getter(getter(GlueConnection::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .constructor(PhysicalConnectionRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalConnectionRequirements")
                    .build()).build();

    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("pythonProperties")
            .getter(getter(GlueConnection::pythonProperties))
            .setter(setter(Builder::pythonProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sparkProperties")
            .getter(getter(GlueConnection::sparkProperties))
            .setter(setter(Builder::sparkProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GlueConnection::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GlueConnection::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD,
            AUTHENTICATION_CONFIGURATION_FIELD, COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD, CONNECTION_PROPERTIES_FIELD,
            CONNECTION_SCHEMA_VERSION_FIELD, CONNECTION_TYPE_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD,
            LAST_CONNECTION_VALIDATION_TIME_FIELD, LAST_UPDATED_BY_FIELD, LAST_UPDATED_TIME_FIELD, MATCH_CRITERIA_FIELD,
            NAME_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, PYTHON_PROPERTIES_FIELD, SPARK_PROPERTIES_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("athenaProperties", ATHENA_PROPERTIES_FIELD);
                    put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
                    put("compatibleComputeEnvironments", COMPATIBLE_COMPUTE_ENVIRONMENTS_FIELD);
                    put("connectionProperties", CONNECTION_PROPERTIES_FIELD);
                    put("connectionSchemaVersion", CONNECTION_SCHEMA_VERSION_FIELD);
                    put("connectionType", CONNECTION_TYPE_FIELD);
                    put("creationTime", CREATION_TIME_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("lastConnectionValidationTime", LAST_CONNECTION_VALIDATION_TIME_FIELD);
                    put("lastUpdatedBy", LAST_UPDATED_BY_FIELD);
                    put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
                    put("matchCriteria", MATCH_CRITERIA_FIELD);
                    put("name", NAME_FIELD);
                    put("physicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
                    put("pythonProperties", PYTHON_PROPERTIES_FIELD);
                    put("sparkProperties", SPARK_PROPERTIES_FIELD);
                    put("status", STATUS_FIELD);
                    put("statusReason", STATUS_REASON_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, String> athenaProperties;

    private final AuthenticationConfiguration authenticationConfiguration;

    private final List<String> compatibleComputeEnvironments;

    private final Map<String, String> connectionProperties;

    private final Integer connectionSchemaVersion;

    private final String connectionType;

    private final Instant creationTime;

    private final String description;

    private final Instant lastConnectionValidationTime;

    private final String lastUpdatedBy;

    private final Instant lastUpdatedTime;

    private final List<String> matchCriteria;

    private final String name;

    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private final Map<String, String> pythonProperties;

    private final Map<String, String> sparkProperties;

    private final String status;

    private final String statusReason;

    private GlueConnection(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.compatibleComputeEnvironments = builder.compatibleComputeEnvironments;
        this.connectionProperties = builder.connectionProperties;
        this.connectionSchemaVersion = builder.connectionSchemaVersion;
        this.connectionType = builder.connectionType;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.lastConnectionValidationTime = builder.lastConnectionValidationTime;
        this.lastUpdatedBy = builder.lastUpdatedBy;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.matchCriteria = builder.matchCriteria;
        this.name = builder.name;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.pythonProperties = builder.pythonProperties;
        this.sparkProperties = builder.sparkProperties;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    /**
     * For responses, this returns true if the service returned a value for the AthenaProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAthenaProperties() {
        return athenaProperties != null && !(athenaProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon Athena properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAthenaProperties} method.
     * </p>
     * 
     * @return The Amazon Athena properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> athenaProperties() {
        return athenaProperties;
    }

    /**
     * <p>
     * The authentication configuration of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The authentication configuration of the Amazon Web Services Glue connection.
     */
    public final AuthenticationConfiguration authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * <p>
     * The compatible compute environments of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleComputeEnvironments} method.
     * </p>
     * 
     * @return The compatible compute environments of the Amazon Web Services Glue connection.
     */
    public final List<ComputeEnvironments> compatibleComputeEnvironments() {
        return ComputeEnvironmentsListCopier.copyStringToEnum(compatibleComputeEnvironments);
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleComputeEnvironments property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCompatibleComputeEnvironments() {
        return compatibleComputeEnvironments != null && !(compatibleComputeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The compatible compute environments of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleComputeEnvironments} method.
     * </p>
     * 
     * @return The compatible compute environments of the Amazon Web Services Glue connection.
     */
    public final List<String> compatibleComputeEnvironmentsAsStrings() {
        return compatibleComputeEnvironments;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return The properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> connectionProperties() {
        return connectionProperties;
    }

    /**
     * <p>
     * The connection schema version of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The connection schema version of the Amazon Web Services Glue connection.
     */
    public final Integer connectionSchemaVersion() {
        return connectionSchemaVersion;
    }

    /**
     * <p>
     * The type of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the Amazon Web Services Glue connection.
     * @see ConnectionType
     */
    public final ConnectionType connectionType() {
        return ConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The type of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link ConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The type of the Amazon Web Services Glue connection.
     * @see ConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * The creation time of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The creation time of the Amazon Web Services Glue connection.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The description of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The description of the Amazon Web Services Glue connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The last validation time of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The last validation time of the Amazon Web Services Glue connection.
     */
    public final Instant lastConnectionValidationTime() {
        return lastConnectionValidationTime;
    }

    /**
     * <p>
     * The user who last updated the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The user who last updated the Amazon Web Services Glue connection.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    /**
     * <p>
     * The timestamp at which the Amazon Web Services Glue connection was last updated.
     * </p>
     * 
     * @return The timestamp at which the Amazon Web Services Glue connection was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchCriteria property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchCriteria() {
        return matchCriteria != null && !(matchCriteria instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The match criteria of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchCriteria} method.
     * </p>
     * 
     * @return The match criteria of the Amazon Web Services Glue connection.
     */
    public final List<String> matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * The name of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The name of the Amazon Web Services Glue connection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The physical connection requirements of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The physical connection requirements of the Amazon Web Services Glue connection.
     */
    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the PythonProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPythonProperties() {
        return pythonProperties != null && !(pythonProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Python properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPythonProperties} method.
     * </p>
     * 
     * @return The Python properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> pythonProperties() {
        return pythonProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the SparkProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSparkProperties() {
        return sparkProperties != null && !(sparkProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Spark properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSparkProperties} method.
     * </p>
     * 
     * @return The Spark properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> sparkProperties() {
        return sparkProperties;
    }

    /**
     * <p>
     * The status of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Web Services Glue connection.
     * @see ConnectionStatus
     */
    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Amazon Web Services Glue connection.
     * @see ConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The status reason of the Amazon Web Services Glue connection.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaProperties() ? athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCompatibleComputeEnvironments() ? compatibleComputeEnvironmentsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastConnectionValidationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchCriteria() ? matchCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(hasPythonProperties() ? pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSparkProperties() ? sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueConnection)) {
            return false;
        }
        GlueConnection other = (GlueConnection) obj;
        return hasAthenaProperties() == other.hasAthenaProperties()
                && Objects.equals(athenaProperties(), other.athenaProperties())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && hasCompatibleComputeEnvironments() == other.hasCompatibleComputeEnvironments()
                && Objects.equals(compatibleComputeEnvironmentsAsStrings(), other.compatibleComputeEnvironmentsAsStrings())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionProperties(), other.connectionProperties())
                && Objects.equals(connectionSchemaVersion(), other.connectionSchemaVersion())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(lastConnectionValidationTime(), other.lastConnectionValidationTime())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && hasMatchCriteria() == other.hasMatchCriteria()
                && Objects.equals(matchCriteria(), other.matchCriteria()) && Objects.equals(name(), other.name())
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements())
                && hasPythonProperties() == other.hasPythonProperties()
                && Objects.equals(pythonProperties(), other.pythonProperties())
                && hasSparkProperties() == other.hasSparkProperties()
                && Objects.equals(sparkProperties(), other.sparkProperties())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GlueConnection")
                .add("AthenaProperties", hasAthenaProperties() ? athenaProperties() : null)
                .add("AuthenticationConfiguration", authenticationConfiguration())
                .add("CompatibleComputeEnvironments",
                        hasCompatibleComputeEnvironments() ? compatibleComputeEnvironmentsAsStrings() : null)
                .add("ConnectionProperties", hasConnectionProperties() ? connectionProperties() : null)
                .add("ConnectionSchemaVersion", connectionSchemaVersion()).add("ConnectionType", connectionTypeAsString())
                .add("CreationTime", creationTime()).add("Description", description())
                .add("LastConnectionValidationTime", lastConnectionValidationTime()).add("LastUpdatedBy", lastUpdatedBy())
                .add("LastUpdatedTime", lastUpdatedTime()).add("MatchCriteria", hasMatchCriteria() ? matchCriteria() : null)
                .add("Name", name()).add("PhysicalConnectionRequirements", physicalConnectionRequirements())
                .add("PythonProperties", hasPythonProperties() ? pythonProperties() : null)
                .add("SparkProperties", hasSparkProperties() ? sparkProperties() : null).add("Status", statusAsString())
                .add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "athenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "authenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "compatibleComputeEnvironments":
            return Optional.ofNullable(clazz.cast(compatibleComputeEnvironmentsAsStrings()));
        case "connectionProperties":
            return Optional.ofNullable(clazz.cast(connectionProperties()));
        case "connectionSchemaVersion":
            return Optional.ofNullable(clazz.cast(connectionSchemaVersion()));
        case "connectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastConnectionValidationTime":
            return Optional.ofNullable(clazz.cast(lastConnectionValidationTime()));
        case "lastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "matchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "physicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        case "pythonProperties":
            return Optional.ofNullable(clazz.cast(pythonProperties()));
        case "sparkProperties":
            return Optional.ofNullable(clazz.cast(sparkProperties()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlueConnection, T> g) {
        return obj -> g.apply((GlueConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueConnection> {
        /**
         * <p>
         * The Amazon Athena properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param athenaProperties
         *        The Amazon Athena properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(Map<String, String> athenaProperties);

        /**
         * <p>
         * The authentication configuration of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration of the Amazon Web Services Glue connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfiguration.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #authenticationConfiguration(AuthenticationConfiguration)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfiguration)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfiguration.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfiguration.builder().applyMutation(authenticationConfiguration)
                    .build());
        }

        /**
         * <p>
         * The compatible compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        The compatible compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironmentsWithStrings(Collection<String> compatibleComputeEnvironments);

        /**
         * <p>
         * The compatible compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        The compatible compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironmentsWithStrings(String... compatibleComputeEnvironments);

        /**
         * <p>
         * The compatible compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        The compatible compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironments(Collection<ComputeEnvironments> compatibleComputeEnvironments);

        /**
         * <p>
         * The compatible compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param compatibleComputeEnvironments
         *        The compatible compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleComputeEnvironments(ComputeEnvironments... compatibleComputeEnvironments);

        /**
         * <p>
         * The properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionProperties
         *        The properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<String, String> connectionProperties);

        /**
         * <p>
         * The connection schema version of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionSchemaVersion
         *        The connection schema version of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionSchemaVersion(Integer connectionSchemaVersion);

        /**
         * <p>
         * The type of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionType
         *        The type of the Amazon Web Services Glue connection.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The type of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionType
         *        The type of the Amazon Web Services Glue connection.
         * @see ConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionType
         */
        Builder connectionType(ConnectionType connectionType);

        /**
         * <p>
         * The creation time of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The description of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param description
         *        The description of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The last validation time of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param lastConnectionValidationTime
         *        The last validation time of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastConnectionValidationTime(Instant lastConnectionValidationTime);

        /**
         * <p>
         * The user who last updated the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The user who last updated the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);

        /**
         * <p>
         * The timestamp at which the Amazon Web Services Glue connection was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp at which the Amazon Web Services Glue connection was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The match criteria of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param matchCriteria
         *        The match criteria of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(Collection<String> matchCriteria);

        /**
         * <p>
         * The match criteria of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param matchCriteria
         *        The match criteria of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String... matchCriteria);

        /**
         * <p>
         * The name of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The physical connection requirements of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        The physical connection requirements of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements);

        /**
         * <p>
         * The physical connection requirements of the Amazon Web Services Glue connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalConnectionRequirements.Builder}
         * avoiding the need to create one manually via {@link PhysicalConnectionRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalConnectionRequirements.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #physicalConnectionRequirements(PhysicalConnectionRequirements)}.
         * 
         * @param physicalConnectionRequirements
         *        a consumer that will call methods on {@link PhysicalConnectionRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalConnectionRequirements(PhysicalConnectionRequirements)
         */
        default Builder physicalConnectionRequirements(
                Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return physicalConnectionRequirements(PhysicalConnectionRequirements.builder()
                    .applyMutation(physicalConnectionRequirements).build());
        }

        /**
         * <p>
         * The Python properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param pythonProperties
         *        The Python properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonProperties(Map<String, String> pythonProperties);

        /**
         * <p>
         * The Spark properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param sparkProperties
         *        The Spark properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkProperties(Map<String, String> sparkProperties);

        /**
         * <p>
         * The status of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Web Services Glue connection.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param status
         *        The status of the Amazon Web Services Glue connection.
         * @see ConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConnectionStatus
         */
        Builder status(ConnectionStatus status);

        /**
         * <p>
         * The status reason of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();

        private AuthenticationConfiguration authenticationConfiguration;

        private List<String> compatibleComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private Integer connectionSchemaVersion;

        private String connectionType;

        private Instant creationTime;

        private String description;

        private Instant lastConnectionValidationTime;

        private String lastUpdatedBy;

        private Instant lastUpdatedTime;

        private List<String> matchCriteria = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueConnection model) {
            athenaProperties(model.athenaProperties);
            authenticationConfiguration(model.authenticationConfiguration);
            compatibleComputeEnvironmentsWithStrings(model.compatibleComputeEnvironments);
            connectionProperties(model.connectionProperties);
            connectionSchemaVersion(model.connectionSchemaVersion);
            connectionType(model.connectionType);
            creationTime(model.creationTime);
            description(model.description);
            lastConnectionValidationTime(model.lastConnectionValidationTime);
            lastUpdatedBy(model.lastUpdatedBy);
            lastUpdatedTime(model.lastUpdatedTime);
            matchCriteria(model.matchCriteria);
            name(model.name);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
            pythonProperties(model.pythonProperties);
            sparkProperties(model.sparkProperties);
            status(model.status);
            statusReason(model.statusReason);
        }

        public final Map<String, String> getAthenaProperties() {
            if (athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final AuthenticationConfiguration.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfiguration.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Collection<String> getCompatibleComputeEnvironments() {
            if (compatibleComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return compatibleComputeEnvironments;
        }

        public final void setCompatibleComputeEnvironments(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentsListCopier.copy(compatibleComputeEnvironments);
        }

        @Override
        public final Builder compatibleComputeEnvironmentsWithStrings(Collection<String> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentsListCopier.copy(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironmentsWithStrings(String... compatibleComputeEnvironments) {
            compatibleComputeEnvironmentsWithStrings(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        @Override
        public final Builder compatibleComputeEnvironments(Collection<ComputeEnvironments> compatibleComputeEnvironments) {
            this.compatibleComputeEnvironments = ComputeEnvironmentsListCopier.copyEnumToString(compatibleComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleComputeEnvironments(ComputeEnvironments... compatibleComputeEnvironments) {
            compatibleComputeEnvironments(Arrays.asList(compatibleComputeEnvironments));
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final Integer getConnectionSchemaVersion() {
            return connectionSchemaVersion;
        }

        public final void setConnectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
        }

        @Override
        public final Builder connectionSchemaVersion(Integer connectionSchemaVersion) {
            this.connectionSchemaVersion = connectionSchemaVersion;
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(ConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastConnectionValidationTime() {
            return lastConnectionValidationTime;
        }

        public final void setLastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
        }

        @Override
        public final Builder lastConnectionValidationTime(Instant lastConnectionValidationTime) {
            this.lastConnectionValidationTime = lastConnectionValidationTime;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Collection<String> getMatchCriteria() {
            if (matchCriteria instanceof SdkAutoConstructList) {
                return null;
            }
            return matchCriteria;
        }

        public final void setMatchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
        }

        @Override
        public final Builder matchCriteria(Collection<String> matchCriteria) {
            this.matchCriteria = MatchCriteriaCopier.copy(matchCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchCriteria(String... matchCriteria) {
            matchCriteria(Arrays.asList(matchCriteria));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return physicalConnectionRequirements != null ? physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(
                PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build()
                    : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public GlueConnection build() {
            return new GlueConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
