/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Web Services Glue connecton input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueConnectionInput implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueConnectionInput.Builder, GlueConnectionInput> {
    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("athenaProperties")
            .getter(getter(GlueConnectionInput::athenaProperties))
            .setter(setter(Builder::athenaProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<AuthenticationConfigurationInput> AUTHENTICATION_CONFIGURATION_FIELD = SdkField
            .<AuthenticationConfigurationInput> builder(MarshallingType.SDK_POJO)
            .memberName("authenticationConfiguration")
            .getter(getter(GlueConnectionInput::authenticationConfiguration))
            .setter(setter(Builder::authenticationConfiguration))
            .constructor(AuthenticationConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("connectionProperties")
            .getter(getter(GlueConnectionInput::connectionProperties))
            .setter(setter(Builder::connectionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionType").getter(getter(GlueConnectionInput::connectionTypeAsString))
            .setter(setter(Builder::connectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GlueConnectionInput::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MATCH_CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchCriteria").getter(getter(GlueConnectionInput::matchCriteria))
            .setter(setter(Builder::matchCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchCriteria").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GlueConnectionInput::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField
            .<PhysicalConnectionRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("physicalConnectionRequirements")
            .getter(getter(GlueConnectionInput::physicalConnectionRequirements))
            .setter(setter(Builder::physicalConnectionRequirements))
            .constructor(PhysicalConnectionRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalConnectionRequirements")
                    .build()).build();

    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("pythonProperties")
            .getter(getter(GlueConnectionInput::pythonProperties))
            .setter(setter(Builder::pythonProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sparkProperties")
            .getter(getter(GlueConnectionInput::sparkProperties))
            .setter(setter(Builder::sparkProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> VALIDATE_CREDENTIALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("validateCredentials").getter(getter(GlueConnectionInput::validateCredentials))
            .setter(setter(Builder::validateCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateCredentials").build())
            .build();

    private static final SdkField<List<String>> VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("validateForComputeEnvironments")
            .getter(getter(GlueConnectionInput::validateForComputeEnvironmentsAsStrings))
            .setter(setter(Builder::validateForComputeEnvironmentsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateForComputeEnvironments")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD,
            AUTHENTICATION_CONFIGURATION_FIELD, CONNECTION_PROPERTIES_FIELD, CONNECTION_TYPE_FIELD, DESCRIPTION_FIELD,
            MATCH_CRITERIA_FIELD, NAME_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, PYTHON_PROPERTIES_FIELD,
            SPARK_PROPERTIES_FIELD, VALIDATE_CREDENTIALS_FIELD, VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("athenaProperties", ATHENA_PROPERTIES_FIELD);
                    put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
                    put("connectionProperties", CONNECTION_PROPERTIES_FIELD);
                    put("connectionType", CONNECTION_TYPE_FIELD);
                    put("description", DESCRIPTION_FIELD);
                    put("matchCriteria", MATCH_CRITERIA_FIELD);
                    put("name", NAME_FIELD);
                    put("physicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
                    put("pythonProperties", PYTHON_PROPERTIES_FIELD);
                    put("sparkProperties", SPARK_PROPERTIES_FIELD);
                    put("validateCredentials", VALIDATE_CREDENTIALS_FIELD);
                    put("validateForComputeEnvironments", VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Map<String, String> athenaProperties;

    private final AuthenticationConfigurationInput authenticationConfiguration;

    private final Map<String, String> connectionProperties;

    private final String connectionType;

    private final String description;

    private final String matchCriteria;

    private final String name;

    private final PhysicalConnectionRequirements physicalConnectionRequirements;

    private final Map<String, String> pythonProperties;

    private final Map<String, String> sparkProperties;

    private final Boolean validateCredentials;

    private final List<String> validateForComputeEnvironments;

    private GlueConnectionInput(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.connectionProperties = builder.connectionProperties;
        this.connectionType = builder.connectionType;
        this.description = builder.description;
        this.matchCriteria = builder.matchCriteria;
        this.name = builder.name;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.pythonProperties = builder.pythonProperties;
        this.sparkProperties = builder.sparkProperties;
        this.validateCredentials = builder.validateCredentials;
        this.validateForComputeEnvironments = builder.validateForComputeEnvironments;
    }

    /**
     * For responses, this returns true if the service returned a value for the AthenaProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAthenaProperties() {
        return athenaProperties != null && !(athenaProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Amazon Athena properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAthenaProperties} method.
     * </p>
     * 
     * @return The Amazon Athena properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> athenaProperties() {
        return athenaProperties;
    }

    /**
     * <p>
     * The authentication configuration of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The authentication configuration of the Amazon Web Services Glue connection.
     */
    public final AuthenticationConfigurationInput authenticationConfiguration() {
        return authenticationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConnectionProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnectionProperties() {
        return connectionProperties != null && !(connectionProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The connection properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectionProperties} method.
     * </p>
     * 
     * @return The connection properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> connectionProperties() {
        return connectionProperties;
    }

    /**
     * <p>
     * The connection type of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link GlueConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type of the Amazon Web Services Glue connection.
     * @see GlueConnectionType
     */
    public final GlueConnectionType connectionType() {
        return GlueConnectionType.fromValue(connectionType);
    }

    /**
     * <p>
     * The connection type of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionType}
     * will return {@link GlueConnectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #connectionTypeAsString}.
     * </p>
     * 
     * @return The connection type of the Amazon Web Services Glue connection.
     * @see GlueConnectionType
     */
    public final String connectionTypeAsString() {
        return connectionType;
    }

    /**
     * <p>
     * The description of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The description of the Amazon Web Services Glue connection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The match criteria of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The match criteria of the Amazon Web Services Glue connection.
     */
    public final String matchCriteria() {
        return matchCriteria;
    }

    /**
     * <p>
     * The name of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The name of the Amazon Web Services Glue connection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The physical connection requirements for the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return The physical connection requirements for the Amazon Web Services Glue connection.
     */
    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return physicalConnectionRequirements;
    }

    /**
     * For responses, this returns true if the service returned a value for the PythonProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPythonProperties() {
        return pythonProperties != null && !(pythonProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Python properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPythonProperties} method.
     * </p>
     * 
     * @return The Python properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> pythonProperties() {
        return pythonProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the SparkProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSparkProperties() {
        return sparkProperties != null && !(sparkProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Spark properties of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSparkProperties} method.
     * </p>
     * 
     * @return The Spark properties of the Amazon Web Services Glue connection.
     */
    public final Map<String, String> sparkProperties() {
        return sparkProperties;
    }

    /**
     * <p>
     * Speciefies whether to validate credentials of the Amazon Web Services Glue connection.
     * </p>
     * 
     * @return Speciefies whether to validate credentials of the Amazon Web Services Glue connection.
     */
    public final Boolean validateCredentials() {
        return validateCredentials;
    }

    /**
     * <p>
     * Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidateForComputeEnvironments} method.
     * </p>
     * 
     * @return Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
     */
    public final List<ComputeEnvironments> validateForComputeEnvironments() {
        return ComputeEnvironmentsListCopier.copyStringToEnum(validateForComputeEnvironments);
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidateForComputeEnvironments property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasValidateForComputeEnvironments() {
        return validateForComputeEnvironments != null && !(validateForComputeEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidateForComputeEnvironments} method.
     * </p>
     * 
     * @return Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
     */
    public final List<String> validateForComputeEnvironmentsAsStrings() {
        return validateForComputeEnvironments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAthenaProperties() ? athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectionProperties() ? connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(hasPythonProperties() ? pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSparkProperties() ? sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(validateCredentials());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasValidateForComputeEnvironments() ? validateForComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueConnectionInput)) {
            return false;
        }
        GlueConnectionInput other = (GlueConnectionInput) obj;
        return hasAthenaProperties() == other.hasAthenaProperties()
                && Objects.equals(athenaProperties(), other.athenaProperties())
                && Objects.equals(authenticationConfiguration(), other.authenticationConfiguration())
                && hasConnectionProperties() == other.hasConnectionProperties()
                && Objects.equals(connectionProperties(), other.connectionProperties())
                && Objects.equals(connectionTypeAsString(), other.connectionTypeAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(matchCriteria(), other.matchCriteria())
                && Objects.equals(name(), other.name())
                && Objects.equals(physicalConnectionRequirements(), other.physicalConnectionRequirements())
                && hasPythonProperties() == other.hasPythonProperties()
                && Objects.equals(pythonProperties(), other.pythonProperties())
                && hasSparkProperties() == other.hasSparkProperties()
                && Objects.equals(sparkProperties(), other.sparkProperties())
                && Objects.equals(validateCredentials(), other.validateCredentials())
                && hasValidateForComputeEnvironments() == other.hasValidateForComputeEnvironments()
                && Objects.equals(validateForComputeEnvironmentsAsStrings(), other.validateForComputeEnvironmentsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GlueConnectionInput")
                .add("AthenaProperties", hasAthenaProperties() ? athenaProperties() : null)
                .add("AuthenticationConfiguration", authenticationConfiguration())
                .add("ConnectionProperties", hasConnectionProperties() ? connectionProperties() : null)
                .add("ConnectionType", connectionTypeAsString())
                .add("Description", description())
                .add("MatchCriteria", matchCriteria())
                .add("Name", name())
                .add("PhysicalConnectionRequirements", physicalConnectionRequirements())
                .add("PythonProperties", hasPythonProperties() ? pythonProperties() : null)
                .add("SparkProperties", hasSparkProperties() ? sparkProperties() : null)
                .add("ValidateCredentials", validateCredentials())
                .add("ValidateForComputeEnvironments",
                        hasValidateForComputeEnvironments() ? validateForComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "athenaProperties":
            return Optional.ofNullable(clazz.cast(athenaProperties()));
        case "authenticationConfiguration":
            return Optional.ofNullable(clazz.cast(authenticationConfiguration()));
        case "connectionProperties":
            return Optional.ofNullable(clazz.cast(connectionProperties()));
        case "connectionType":
            return Optional.ofNullable(clazz.cast(connectionTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "matchCriteria":
            return Optional.ofNullable(clazz.cast(matchCriteria()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "physicalConnectionRequirements":
            return Optional.ofNullable(clazz.cast(physicalConnectionRequirements()));
        case "pythonProperties":
            return Optional.ofNullable(clazz.cast(pythonProperties()));
        case "sparkProperties":
            return Optional.ofNullable(clazz.cast(sparkProperties()));
        case "validateCredentials":
            return Optional.ofNullable(clazz.cast(validateCredentials()));
        case "validateForComputeEnvironments":
            return Optional.ofNullable(clazz.cast(validateForComputeEnvironmentsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlueConnectionInput, T> g) {
        return obj -> g.apply((GlueConnectionInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueConnectionInput> {
        /**
         * <p>
         * The Amazon Athena properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param athenaProperties
         *        The Amazon Athena properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder athenaProperties(Map<String, String> athenaProperties);

        /**
         * <p>
         * The authentication configuration of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param authenticationConfiguration
         *        The authentication configuration of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationConfiguration(AuthenticationConfigurationInput authenticationConfiguration);

        /**
         * <p>
         * The authentication configuration of the Amazon Web Services Glue connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthenticationConfigurationInput.Builder}
         * avoiding the need to create one manually via {@link AuthenticationConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthenticationConfigurationInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #authenticationConfiguration(AuthenticationConfigurationInput)}.
         * 
         * @param authenticationConfiguration
         *        a consumer that will call methods on {@link AuthenticationConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationConfiguration(AuthenticationConfigurationInput)
         */
        default Builder authenticationConfiguration(Consumer<AuthenticationConfigurationInput.Builder> authenticationConfiguration) {
            return authenticationConfiguration(AuthenticationConfigurationInput.builder()
                    .applyMutation(authenticationConfiguration).build());
        }

        /**
         * <p>
         * The connection properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionProperties
         *        The connection properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionProperties(Map<String, String> connectionProperties);

        /**
         * <p>
         * The connection type of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionType
         *        The connection type of the Amazon Web Services Glue connection.
         * @see GlueConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlueConnectionType
         */
        Builder connectionType(String connectionType);

        /**
         * <p>
         * The connection type of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param connectionType
         *        The connection type of the Amazon Web Services Glue connection.
         * @see GlueConnectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GlueConnectionType
         */
        Builder connectionType(GlueConnectionType connectionType);

        /**
         * <p>
         * The description of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param description
         *        The description of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The match criteria of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param matchCriteria
         *        The match criteria of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchCriteria(String matchCriteria);

        /**
         * <p>
         * The name of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The physical connection requirements for the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param physicalConnectionRequirements
         *        The physical connection requirements for the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements);

        /**
         * <p>
         * The physical connection requirements for the Amazon Web Services Glue connection.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalConnectionRequirements.Builder}
         * avoiding the need to create one manually via {@link PhysicalConnectionRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalConnectionRequirements.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #physicalConnectionRequirements(PhysicalConnectionRequirements)}.
         * 
         * @param physicalConnectionRequirements
         *        a consumer that will call methods on {@link PhysicalConnectionRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalConnectionRequirements(PhysicalConnectionRequirements)
         */
        default Builder physicalConnectionRequirements(
                Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return physicalConnectionRequirements(PhysicalConnectionRequirements.builder()
                    .applyMutation(physicalConnectionRequirements).build());
        }

        /**
         * <p>
         * The Python properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param pythonProperties
         *        The Python properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pythonProperties(Map<String, String> pythonProperties);

        /**
         * <p>
         * The Spark properties of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param sparkProperties
         *        The Spark properties of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparkProperties(Map<String, String> sparkProperties);

        /**
         * <p>
         * Speciefies whether to validate credentials of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param validateCredentials
         *        Speciefies whether to validate credentials of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateCredentials(Boolean validateCredentials);

        /**
         * <p>
         * Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironmentsWithStrings(Collection<String> validateForComputeEnvironments);

        /**
         * <p>
         * Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironmentsWithStrings(String... validateForComputeEnvironments);

        /**
         * <p>
         * Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironments(Collection<ComputeEnvironments> validateForComputeEnvironments);

        /**
         * <p>
         * Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * </p>
         * 
         * @param validateForComputeEnvironments
         *        Speciefies whether to validate for compute environments of the Amazon Web Services Glue connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateForComputeEnvironments(ComputeEnvironments... validateForComputeEnvironments);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();

        private AuthenticationConfigurationInput authenticationConfiguration;

        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();

        private String connectionType;

        private String description;

        private String matchCriteria;

        private String name;

        private PhysicalConnectionRequirements physicalConnectionRequirements;

        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();

        private Boolean validateCredentials;

        private List<String> validateForComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueConnectionInput model) {
            athenaProperties(model.athenaProperties);
            authenticationConfiguration(model.authenticationConfiguration);
            connectionProperties(model.connectionProperties);
            connectionType(model.connectionType);
            description(model.description);
            matchCriteria(model.matchCriteria);
            name(model.name);
            physicalConnectionRequirements(model.physicalConnectionRequirements);
            pythonProperties(model.pythonProperties);
            sparkProperties(model.sparkProperties);
            validateCredentials(model.validateCredentials);
            validateForComputeEnvironmentsWithStrings(model.validateForComputeEnvironments);
        }

        public final Map<String, String> getAthenaProperties() {
            if (athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final AuthenticationConfigurationInput.Builder getAuthenticationConfiguration() {
            return authenticationConfiguration != null ? authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfigurationInput.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfigurationInput authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final String getConnectionType() {
            return connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(GlueConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMatchCriteria() {
            return matchCriteria;
        }

        public final void setMatchCriteria(String matchCriteria) {
            this.matchCriteria = matchCriteria;
        }

        @Override
        public final Builder matchCriteria(String matchCriteria) {
            this.matchCriteria = matchCriteria;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return physicalConnectionRequirements != null ? physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(
                PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build()
                    : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final Boolean getValidateCredentials() {
            return validateCredentials;
        }

        public final void setValidateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
        }

        @Override
        public final Builder validateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
            return this;
        }

        public final Collection<String> getValidateForComputeEnvironments() {
            if (validateForComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return validateForComputeEnvironments;
        }

        public final void setValidateForComputeEnvironments(Collection<String> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentsListCopier.copy(validateForComputeEnvironments);
        }

        @Override
        public final Builder validateForComputeEnvironmentsWithStrings(Collection<String> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentsListCopier.copy(validateForComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validateForComputeEnvironmentsWithStrings(String... validateForComputeEnvironments) {
            validateForComputeEnvironmentsWithStrings(Arrays.asList(validateForComputeEnvironments));
            return this;
        }

        @Override
        public final Builder validateForComputeEnvironments(Collection<ComputeEnvironments> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentsListCopier.copyEnumToString(validateForComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validateForComputeEnvironments(ComputeEnvironments... validateForComputeEnvironments) {
            validateForComputeEnvironments(Arrays.asList(validateForComputeEnvironments));
            return this;
        }

        @Override
        public GlueConnectionInput build() {
            return new GlueConnectionInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
