/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The GlueOAuth2 credentials of a connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueOAuth2Credentials implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueOAuth2Credentials.Builder, GlueOAuth2Credentials> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(GlueOAuth2Credentials::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<String> JWT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jwtToken").getter(getter(GlueOAuth2Credentials::jwtToken)).setter(setter(Builder::jwtToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jwtToken").build()).build();

    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("refreshToken").getter(getter(GlueOAuth2Credentials::refreshToken)).setter(setter(Builder::refreshToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()).build();

    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userManagedClientApplicationClientSecret")
            .getter(getter(GlueOAuth2Credentials::userManagedClientApplicationClientSecret))
            .setter(setter(Builder::userManagedClientApplicationClientSecret))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("userManagedClientApplicationClientSecret").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD,
            JWT_TOKEN_FIELD, REFRESH_TOKEN_FIELD, USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accessToken", ACCESS_TOKEN_FIELD);
                    put("jwtToken", JWT_TOKEN_FIELD);
                    put("refreshToken", REFRESH_TOKEN_FIELD);
                    put("userManagedClientApplicationClientSecret", USER_MANAGED_CLIENT_APPLICATION_CLIENT_SECRET_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accessToken;

    private final String jwtToken;

    private final String refreshToken;

    private final String userManagedClientApplicationClientSecret;

    private GlueOAuth2Credentials(BuilderImpl builder) {
        this.accessToken = builder.accessToken;
        this.jwtToken = builder.jwtToken;
        this.refreshToken = builder.refreshToken;
        this.userManagedClientApplicationClientSecret = builder.userManagedClientApplicationClientSecret;
    }

    /**
     * <p>
     * The access token of a connection.
     * </p>
     * 
     * @return The access token of a connection.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * <p>
     * The jwt token of the connection.
     * </p>
     * 
     * @return The jwt token of the connection.
     */
    public final String jwtToken() {
        return jwtToken;
    }

    /**
     * <p>
     * The refresh token of the connection.
     * </p>
     * 
     * @return The refresh token of the connection.
     */
    public final String refreshToken() {
        return refreshToken;
    }

    /**
     * <p>
     * The user managed client application client secret of the connection.
     * </p>
     * 
     * @return The user managed client application client secret of the connection.
     */
    public final String userManagedClientApplicationClientSecret() {
        return userManagedClientApplicationClientSecret;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(jwtToken());
        hashCode = 31 * hashCode + Objects.hashCode(refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(userManagedClientApplicationClientSecret());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueOAuth2Credentials)) {
            return false;
        }
        GlueOAuth2Credentials other = (GlueOAuth2Credentials) obj;
        return Objects.equals(accessToken(), other.accessToken()) && Objects.equals(jwtToken(), other.jwtToken())
                && Objects.equals(refreshToken(), other.refreshToken())
                && Objects.equals(userManagedClientApplicationClientSecret(), other.userManagedClientApplicationClientSecret());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GlueOAuth2Credentials").add("AccessToken", accessToken()).add("JwtToken", jwtToken())
                .add("RefreshToken", refreshToken())
                .add("UserManagedClientApplicationClientSecret", userManagedClientApplicationClientSecret()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "jwtToken":
            return Optional.ofNullable(clazz.cast(jwtToken()));
        case "refreshToken":
            return Optional.ofNullable(clazz.cast(refreshToken()));
        case "userManagedClientApplicationClientSecret":
            return Optional.ofNullable(clazz.cast(userManagedClientApplicationClientSecret()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlueOAuth2Credentials, T> g) {
        return obj -> g.apply((GlueOAuth2Credentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueOAuth2Credentials> {
        /**
         * <p>
         * The access token of a connection.
         * </p>
         * 
         * @param accessToken
         *        The access token of a connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The jwt token of the connection.
         * </p>
         * 
         * @param jwtToken
         *        The jwt token of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwtToken(String jwtToken);

        /**
         * <p>
         * The refresh token of the connection.
         * </p>
         * 
         * @param refreshToken
         *        The refresh token of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshToken(String refreshToken);

        /**
         * <p>
         * The user managed client application client secret of the connection.
         * </p>
         * 
         * @param userManagedClientApplicationClientSecret
         *        The user managed client application client secret of the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret);
    }

    static final class BuilderImpl implements Builder {
        private String accessToken;

        private String jwtToken;

        private String refreshToken;

        private String userManagedClientApplicationClientSecret;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueOAuth2Credentials model) {
            accessToken(model.accessToken);
            jwtToken(model.jwtToken);
            refreshToken(model.refreshToken);
            userManagedClientApplicationClientSecret(model.userManagedClientApplicationClientSecret);
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final String getJwtToken() {
            return jwtToken;
        }

        public final void setJwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
        }

        @Override
        public final Builder jwtToken(String jwtToken) {
            this.jwtToken = jwtToken;
            return this;
        }

        public final String getRefreshToken() {
            return refreshToken;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final String getUserManagedClientApplicationClientSecret() {
            return userManagedClientApplicationClientSecret;
        }

        public final void setUserManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
        }

        @Override
        public final Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
            this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
            return this;
        }

        @Override
        public GlueOAuth2Credentials build() {
            return new GlueOAuth2Credentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
