/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details of the Amazon Web Services Glue data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GlueRunConfigurationOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<GlueRunConfigurationOutput.Builder, GlueRunConfigurationOutput> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(GlueRunConfigurationOutput::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<Boolean> AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoImportDataQualityResult")
            .getter(getter(GlueRunConfigurationOutput::autoImportDataQualityResult))
            .setter(setter(Builder::autoImportDataQualityResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoImportDataQualityResult")
                    .build()).build();

    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("catalogName").getter(getter(GlueRunConfigurationOutput::catalogName))
            .setter(setter(Builder::catalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogName").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataAccessRole").getter(getter(GlueRunConfigurationOutput::dataAccessRole))
            .setter(setter(Builder::dataAccessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRole").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(GlueRunConfigurationOutput::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<List<RelationalFilterConfiguration>> RELATIONAL_FILTER_CONFIGURATIONS_FIELD = SdkField
            .<List<RelationalFilterConfiguration>> builder(MarshallingType.LIST)
            .memberName("relationalFilterConfigurations")
            .getter(getter(GlueRunConfigurationOutput::relationalFilterConfigurations))
            .setter(setter(Builder::relationalFilterConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalFilterConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalFilterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalFilterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD, CATALOG_NAME_FIELD, DATA_ACCESS_ROLE_FIELD, REGION_FIELD,
            RELATIONAL_FILTER_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("accountId", ACCOUNT_ID_FIELD);
                    put("autoImportDataQualityResult", AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD);
                    put("catalogName", CATALOG_NAME_FIELD);
                    put("dataAccessRole", DATA_ACCESS_ROLE_FIELD);
                    put("region", REGION_FIELD);
                    put("relationalFilterConfigurations", RELATIONAL_FILTER_CONFIGURATIONS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final Boolean autoImportDataQualityResult;

    private final String catalogName;

    private final String dataAccessRole;

    private final String region;

    private final List<RelationalFilterConfiguration> relationalFilterConfigurations;

    private GlueRunConfigurationOutput(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.autoImportDataQualityResult = builder.autoImportDataQualityResult;
        this.catalogName = builder.catalogName;
        this.dataAccessRole = builder.dataAccessRole;
        this.region = builder.region;
        this.relationalFilterConfigurations = builder.relationalFilterConfigurations;
    }

    /**
     * <p>
     * The Amazon Web Services account ID included in the configuration details of the Amazon Web Services Glue data
     * source.
     * </p>
     * 
     * @return The Amazon Web Services account ID included in the configuration details of the Amazon Web Services Glue
     *         data source.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Specifies whether to automatically import data quality metrics as part of the data source run.
     * </p>
     * 
     * @return Specifies whether to automatically import data quality metrics as part of the data source run.
     */
    public final Boolean autoImportDataQualityResult() {
        return autoImportDataQualityResult;
    }

    /**
     * <p>
     * The catalog name in the Amazon Web Services Glue run configuration.
     * </p>
     * 
     * @return The catalog name in the Amazon Web Services Glue run configuration.
     */
    public final String catalogName() {
        return catalogName;
    }

    /**
     * <p>
     * The data access role included in the configuration details of the Amazon Web Services Glue data source.
     * </p>
     * 
     * @return The data access role included in the configuration details of the Amazon Web Services Glue data source.
     */
    public final String dataAccessRole() {
        return dataAccessRole;
    }

    /**
     * <p>
     * The Amazon Web Services region included in the configuration details of the Amazon Web Services Glue data source.
     * </p>
     * 
     * @return The Amazon Web Services region included in the configuration details of the Amazon Web Services Glue data
     *         source.
     */
    public final String region() {
        return region;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelationalFilterConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRelationalFilterConfigurations() {
        return relationalFilterConfigurations != null && !(relationalFilterConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The relational filter configurations included in the configuration details of the Amazon Web Services Glue data
     * source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelationalFilterConfigurations} method.
     * </p>
     * 
     * @return The relational filter configurations included in the configuration details of the Amazon Web Services
     *         Glue data source.
     */
    public final List<RelationalFilterConfiguration> relationalFilterConfigurations() {
        return relationalFilterConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(autoImportDataQualityResult());
        hashCode = 31 * hashCode + Objects.hashCode(catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRelationalFilterConfigurations() ? relationalFilterConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueRunConfigurationOutput)) {
            return false;
        }
        GlueRunConfigurationOutput other = (GlueRunConfigurationOutput) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(autoImportDataQualityResult(), other.autoImportDataQualityResult())
                && Objects.equals(catalogName(), other.catalogName()) && Objects.equals(dataAccessRole(), other.dataAccessRole())
                && Objects.equals(region(), other.region())
                && hasRelationalFilterConfigurations() == other.hasRelationalFilterConfigurations()
                && Objects.equals(relationalFilterConfigurations(), other.relationalFilterConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GlueRunConfigurationOutput")
                .add("AccountId", accountId())
                .add("AutoImportDataQualityResult", autoImportDataQualityResult())
                .add("CatalogName", catalogName())
                .add("DataAccessRole", dataAccessRole())
                .add("Region", region())
                .add("RelationalFilterConfigurations",
                        hasRelationalFilterConfigurations() ? relationalFilterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "autoImportDataQualityResult":
            return Optional.ofNullable(clazz.cast(autoImportDataQualityResult()));
        case "catalogName":
            return Optional.ofNullable(clazz.cast(catalogName()));
        case "dataAccessRole":
            return Optional.ofNullable(clazz.cast(dataAccessRole()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "relationalFilterConfigurations":
            return Optional.ofNullable(clazz.cast(relationalFilterConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlueRunConfigurationOutput, T> g) {
        return obj -> g.apply((GlueRunConfigurationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GlueRunConfigurationOutput> {
        /**
         * <p>
         * The Amazon Web Services account ID included in the configuration details of the Amazon Web Services Glue data
         * source.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID included in the configuration details of the Amazon Web Services
         *        Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Specifies whether to automatically import data quality metrics as part of the data source run.
         * </p>
         * 
         * @param autoImportDataQualityResult
         *        Specifies whether to automatically import data quality metrics as part of the data source run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoImportDataQualityResult(Boolean autoImportDataQualityResult);

        /**
         * <p>
         * The catalog name in the Amazon Web Services Glue run configuration.
         * </p>
         * 
         * @param catalogName
         *        The catalog name in the Amazon Web Services Glue run configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogName(String catalogName);

        /**
         * <p>
         * The data access role included in the configuration details of the Amazon Web Services Glue data source.
         * </p>
         * 
         * @param dataAccessRole
         *        The data access role included in the configuration details of the Amazon Web Services Glue data
         *        source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRole(String dataAccessRole);

        /**
         * <p>
         * The Amazon Web Services region included in the configuration details of the Amazon Web Services Glue data
         * source.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services region included in the configuration details of the Amazon Web Services Glue
         *        data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The relational filter configurations included in the configuration details of the Amazon Web Services Glue
         * data source.
         * </p>
         * 
         * @param relationalFilterConfigurations
         *        The relational filter configurations included in the configuration details of the Amazon Web Services
         *        Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> relationalFilterConfigurations);

        /**
         * <p>
         * The relational filter configurations included in the configuration details of the Amazon Web Services Glue
         * data source.
         * </p>
         * 
         * @param relationalFilterConfigurations
         *        The relational filter configurations included in the configuration details of the Amazon Web Services
         *        Glue data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalFilterConfigurations(RelationalFilterConfiguration... relationalFilterConfigurations);

        /**
         * <p>
         * The relational filter configurations included in the configuration details of the Amazon Web Services Glue
         * data source.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #relationalFilterConfigurations(List<RelationalFilterConfiguration>)}.
         * 
         * @param relationalFilterConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalFilterConfigurations(java.util.Collection<RelationalFilterConfiguration>)
         */
        Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder>... relationalFilterConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private Boolean autoImportDataQualityResult;

        private String catalogName;

        private String dataAccessRole;

        private String region;

        private List<RelationalFilterConfiguration> relationalFilterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueRunConfigurationOutput model) {
            accountId(model.accountId);
            autoImportDataQualityResult(model.autoImportDataQualityResult);
            catalogName(model.catalogName);
            dataAccessRole(model.dataAccessRole);
            region(model.region);
            relationalFilterConfigurations(model.relationalFilterConfigurations);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getAutoImportDataQualityResult() {
            return autoImportDataQualityResult;
        }

        public final void setAutoImportDataQualityResult(Boolean autoImportDataQualityResult) {
            this.autoImportDataQualityResult = autoImportDataQualityResult;
        }

        @Override
        public final Builder autoImportDataQualityResult(Boolean autoImportDataQualityResult) {
            this.autoImportDataQualityResult = autoImportDataQualityResult;
            return this;
        }

        public final String getCatalogName() {
            return catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getDataAccessRole() {
            return dataAccessRole;
        }

        public final void setDataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
        }

        @Override
        public final Builder dataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<RelationalFilterConfiguration.Builder> getRelationalFilterConfigurations() {
            List<RelationalFilterConfiguration.Builder> result = RelationalFilterConfigurationsCopier
                    .copyToBuilder(this.relationalFilterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalFilterConfigurations(
                Collection<RelationalFilterConfiguration.BuilderImpl> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier
                    .copyFromBuilder(relationalFilterConfigurations);
        }

        @Override
        public final Builder relationalFilterConfigurations(
                Collection<RelationalFilterConfiguration> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copy(relationalFilterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(RelationalFilterConfiguration... relationalFilterConfigurations) {
            relationalFilterConfigurations(Arrays.asList(relationalFilterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(
                Consumer<RelationalFilterConfiguration.Builder>... relationalFilterConfigurations) {
            relationalFilterConfigurations(Stream.of(relationalFilterConfigurations)
                    .map(c -> RelationalFilterConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GlueRunConfigurationOutput build() {
            return new GlueRunConfigurationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
