/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The group principal to whom the policy is granted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupPolicyGrantPrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupPolicyGrantPrincipal.Builder, GroupPolicyGrantPrincipal> {
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupIdentifier").getter(getter(GroupPolicyGrantPrincipal::groupIdentifier))
            .setter(setter(Builder::groupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String groupIdentifier;

    private final Type type;

    private GroupPolicyGrantPrincipal(BuilderImpl builder) {
        this.groupIdentifier = builder.groupIdentifier;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID Of the group of the group principal.
     * </p>
     * 
     * @return The ID Of the group of the group principal.
     */
    public final String groupIdentifier() {
        return groupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupPolicyGrantPrincipal)) {
            return false;
        }
        GroupPolicyGrantPrincipal other = (GroupPolicyGrantPrincipal) obj;
        return Objects.equals(groupIdentifier(), other.groupIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupPolicyGrantPrincipal").add("GroupIdentifier", groupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupIdentifier":
            return Optional.ofNullable(clazz.cast(groupIdentifier()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #groupIdentifier()} initialized to the given value.
     *
     * <p>
     * The ID Of the group of the group principal.
     * </p>
     * 
     * @param groupIdentifier
     *        The ID Of the group of the group principal.
     */
    public static GroupPolicyGrantPrincipal fromGroupIdentifier(String groupIdentifier) {
        return builder().groupIdentifier(groupIdentifier).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GroupPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((GroupPolicyGrantPrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupPolicyGrantPrincipal> {
        /**
         * <p>
         * The ID Of the group of the group principal.
         * </p>
         * 
         * @param groupIdentifier
         *        The ID Of the group of the group principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIdentifier(String groupIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String groupIdentifier;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GroupPolicyGrantPrincipal model) {
            groupIdentifier(model.groupIdentifier);
        }

        public final String getGroupIdentifier() {
            return groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            Object oldValue = this.groupIdentifier;
            this.groupIdentifier = groupIdentifier;
            handleUnionValueChange(Type.GROUP_IDENTIFIER, oldValue, this.groupIdentifier);
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            Object oldValue = this.groupIdentifier;
            this.groupIdentifier = groupIdentifier;
            handleUnionValueChange(Type.GROUP_IDENTIFIER, oldValue, this.groupIdentifier);
            return this;
        }

        @Override
        public GroupPolicyGrantPrincipal build() {
            return new GroupPolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GroupPolicyGrantPrincipal#type()
     */
    public enum Type {
        GROUP_IDENTIFIER,

        UNKNOWN_TO_SDK_VERSION
    }
}
