/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies that a value is less than an expression.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LessThanExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<LessThanExpression.Builder, LessThanExpression> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("columnName").getter(getter(LessThanExpression::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(LessThanExpression::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLUMN_NAME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("columnName", COLUMN_NAME_FIELD);
                    put("value", VALUE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String value;

    private LessThanExpression(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the column.
     * </p>
     * 
     * @return The name of the column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The value that might be less than the expression.
     * </p>
     * 
     * @return The value that might be less than the expression.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LessThanExpression)) {
            return false;
        }
        LessThanExpression other = (LessThanExpression) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LessThanExpression").add("ColumnName", columnName()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LessThanExpression, T> g) {
        return obj -> g.apply((LessThanExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LessThanExpression> {
        /**
         * <p>
         * The name of the column.
         * </p>
         * 
         * @param columnName
         *        The name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The value that might be less than the expression.
         * </p>
         * 
         * @param value
         *        The value that might be less than the expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(LessThanExpression model) {
            columnName(model.columnName);
            value(model.value);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public LessThanExpression build() {
            return new LessThanExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
